/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client.sounds;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.ReflectionHelper;
import hardcorequesting.QuestingData;
import hardcorequesting.client.sounds.Sounds;
import hardcorequesting.network.DataReader;
import hardcorequesting.network.DataWriter;
import hardcorequesting.network.PacketHandler;
import hardcorequesting.network.PacketId;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.audio.SoundPool;
import net.minecraft.client.audio.SoundPoolEntry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;

public class SoundHandler {
    private String mainPath;
    private static List<String> paths = new ArrayList<String>();
    private static final String LABEL = "hqm:lore";
    private static int loreNumber;
    private static boolean loreMusic;
    private static String name;
    private static int bitCount;

    public SoundHandler(String mainPath) {
        this.mainPath = mainPath;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @ForgeSubscribe
    public void onSoundsLoad(SoundLoadEvent event) {
        for (Sounds sound : Sounds.values()) {
            event.manager.func_77372_a(sound.getSound() + ".ogg");
        }
        SoundHandler.loadLoreReading(this.mainPath);
    }

    public static void loadLoreReading(String path) {
        loreMusic = false;
        loreNumber = -1;
        int index = paths.indexOf(path);
        if (index == -1) {
            if (new File(path + "lore.ogg").exists()) {
                int number = paths.size();
                SoundPool pool = Minecraft.func_71410_x().field_71416_A.field_77379_b;
                try {
                    Map nameToSoundPoolEntriesMapping = (Map)ReflectionHelper.getPrivateValue(SoundPool.class, (Object)pool, (int)1);
                    List object = (List)nameToSoundPoolEntriesMapping.get(LABEL + number + ".ogg");
                    if (object == null) {
                        object = Lists.newArrayList();
                        nameToSoundPoolEntriesMapping.put(LABEL + number + ".ogg", object);
                    }
                    object.add(new SoundPoolEntry(LABEL + number + ".ogg", new File(path + "lore.ogg").toURI().toURL()));
                    loreMusic = true;
                    loreNumber = number;
                    paths.add(path);
                }
                catch (MalformedURLException malformedurlexception) {
                    malformedurlexception.printStackTrace();
                    throw new RuntimeException(malformedurlexception);
                }
            }
        } else {
            loreNumber = index;
            loreMusic = true;
        }
    }

    public static void playLoreMusic() {
        SoundHandler.play(LABEL + loreNumber + ".ogg", 4.0f, 1.0f);
        name = "sound_" + ReflectionHelper.getPrivateValue(SoundManager.class, (Object)Minecraft.func_71410_x().field_71416_A, (int)7);
    }

    private static int getBitCount() {
        if (bitCount == -1) {
            bitCount = (int)(Math.log10(Sounds.values().length + 1) / Math.log10(2.0)) + 1;
        }
        return bitCount;
    }

    public static void play(Sounds sound, EntityPlayer player) {
        DataWriter dw = PacketHandler.getWriter(PacketId.SOUND);
        dw.writeData(sound.ordinal(), SoundHandler.getBitCount());
        PacketHandler.sendToRawPlayer(player, dw);
    }

    public static void playToAll(Sounds sound) {
        DataWriter dw = PacketHandler.getWriter(PacketId.SOUND);
        dw.writeData(sound.ordinal(), SoundHandler.getBitCount());
        PacketHandler.sendToAllPlayers(dw);
    }

    private static void play(String sound, float volume, float pitch) {
        Minecraft.func_71410_x().field_71416_A.func_77366_a(sound, volume, pitch);
    }

    public static void stopLoreMusic() {
        if (SoundHandler.isLorePlaying()) {
            Minecraft.func_71410_x().field_71416_A.field_77381_a.stop(name);
            name = null;
        }
    }

    public static boolean isLorePlaying() {
        boolean value;
        boolean bl = value = name != null && Minecraft.func_71410_x().field_71416_A.field_77381_a.playing(name);
        if (!value) {
            name = null;
        }
        return value;
    }

    public static boolean hasLoreMusic() {
        return loreMusic;
    }

    public static void handleSoundPacket(DataReader dr) {
        int id = dr.readData(SoundHandler.getBitCount());
        SoundHandler.play(Sounds.values()[id].getSound(), 1.0f, 1.0f);
    }

    public static void triggerFirstLore() {
        PacketHandler.sendToServer(PacketHandler.getWriter(PacketId.LORE));
        SoundHandler.playLoreMusic();
    }

    public static void handleLorePacket(EntityPlayer player, DataReader dr) {
        QuestingData.getQuestingData((EntityPlayer)player).playedLore = true;
    }

    static {
        loreMusic = false;
        bitCount = -1;
    }
}

