/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client.interfaces;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.DeathStats;
import hardcorequesting.OPBookHelper;
import hardcorequesting.QuestingData;
import hardcorequesting.Team;
import hardcorequesting.bag.BagTier;
import hardcorequesting.bag.Group;
import hardcorequesting.bag.GroupTier;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.client.interfaces.GuiEditMenu;
import hardcorequesting.client.interfaces.GuiEditMenuDeath;
import hardcorequesting.client.interfaces.GuiEditMenuItem;
import hardcorequesting.client.interfaces.GuiEditMenuRepeat;
import hardcorequesting.client.interfaces.GuiEditMenuTeam;
import hardcorequesting.client.interfaces.GuiEditMenuTextEditor;
import hardcorequesting.client.interfaces.GuiEditMenuTier;
import hardcorequesting.client.interfaces.GuiEditMenuTrigger;
import hardcorequesting.client.interfaces.LargeButton;
import hardcorequesting.client.interfaces.RenderRotation;
import hardcorequesting.client.interfaces.ResourceHelper;
import hardcorequesting.client.interfaces.ScrollBar;
import hardcorequesting.client.interfaces.TextBoxGroup;
import hardcorequesting.client.sounds.SoundHandler;
import hardcorequesting.items.Items;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.network.FileHelper;
import hardcorequesting.network.PacketHandler;
import hardcorequesting.quests.ItemPrecision;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestLine;
import hardcorequesting.quests.QuestSet;
import hardcorequesting.quests.QuestTask;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiQuestBook
extends GuiBase {
    private static QuestSet selectedSet;
    private static boolean isSetOpened;
    private static Quest selectedQuest;
    private static boolean isMainPageOpen;
    private static boolean isBagPage;
    private static Group selectedGroup;
    private final EntityPlayer player;
    private final boolean isOpBook;
    private ScrollBar setScroll;
    private ScrollBar descriptionScroll;
    private ScrollBar mainDescriptionScroll;
    private ScrollBar groupScroll;
    private ScrollBar tierScroll;
    private List<ScrollBar> scrollBars = new ArrayList<ScrollBar>();
    private TextBoxGroup.TextBox textBoxGroupAmount;
    private TextBoxGroup textBoxes;
    private int tick;
    private GuiEditMenu editMenu;
    private FileHelper.SaveResult saveResult;
    private LargeButton saveButton;
    private List<LargeButton> buttons;
    private static final String FRONT_KEY = "hqm_front_texture";
    private static final int TEXTURE_WIDTH = 340;
    public static final int PAGE_WIDTH = 170;
    private static final int TEXTURE_HEIGHT = 234;
    private static final int LIST_X = 25;
    private static final int LIST_Y = 20;
    private static final int TEXT_HEIGHT = 9;
    private static final int TEXT_SPACING = 20;
    private static final int LINE_2_X = 10;
    private static final int LINE_2_Y = 12;
    private static final int DESCRIPTION_X = 180;
    private static final int DESCRIPTION_Y = 20;
    private static final int VISIBLE_DESCRIPTION_LINES = 7;
    private static final int VISIBLE_MAIN_DESCRIPTION_LINES = 21;
    private static final int INFO_Y = 100;
    private static final int VISIBLE_SETS = 7;
    private static final int INFO_QUEST_Y = 150;
    private static final int INFO_LIVES_Y = 20;
    private static final int INFO_DEATHS_Y = 55;
    private static final int INFO_TEAM_Y = 95;
    private static final int INFO_QUEST_Y_OP = 120;
    private static final int INFO_TEAM_Y_OP = 65;
    private static final int INFO_HEARTS_X = 185;
    private static final int INFO_HEARTS_Y = 12;
    private static final int INFO_HEARTS_SPACING = 18;
    private static final int TEAM_TEXT_Y = 12;
    private static final int TEAM_CLICK_TEXT_Y = 30;
    private static final int DEATH_TEXT_Y = 0;
    private static final int DEATH_CLICK_TEXT_Y = 10;
    private static final int TIERS_X = 180;
    private static final int TIERS_Y = 20;
    private static final int TIERS_SPACING = 25;
    private static final int TIERS_SECOND_LINE_X = -5;
    private static final int TIERS_SECOND_LINE_Y = 12;
    private static final int WEIGHT_SPACING = 25;
    private static final int VISIBLE_TIERS = 8;
    private static final int GROUPS_X = 20;
    private static final int GROUPS_Y = 20;
    private static final int GROUPS_SPACING = 25;
    private static final int GROUPS_SECOND_LINE_X = 5;
    private static final int GROUPS_SECOND_LINE_Y = 12;
    private static final int VISIBLE_GROUPS = 8;
    private static final int GROUP_ITEMS_X = 20;
    private static final int GROUP_ITEMS_Y = 40;
    private static final int GROUP_ITEMS_SPACING = 20;
    private static final int ITEMS_PER_LINE = 7;
    private static final ResourceLocation BG_TEXTURE;
    private Group modifyingGroup;
    private QuestSet modifyingQuestSet;
    private Quest modifyingQuest;
    private EditMode currentMode;
    private static final int BUTTON_SIZE = 16;
    private static final int BUTTON_ICON_SIZE = 12;
    private static final int BUTTON_ICON_SRC_X = 0;
    private static final int BUTTON_ICON_SRC_Y = 0;
    private EditButton[] groupButtons;
    private EditButton[] bagButtons;
    private EditButton[] mainButtons;
    private EditButton[] overviewButtons;
    private EditButton[] setButtons;
    private EditButton[] questButtons;

    public static void resetBookPosition() {
        selectedSet = null;
        isSetOpened = false;
        selectedQuest = null;
        isMainPageOpen = true;
        isBagPage = false;
        selectedGroup = null;
    }

    public static Group getSelectedGroup() {
        return selectedGroup;
    }

    @Override
    public void setEditMenu(GuiEditMenu editMenu) {
        this.editMenu = editMenu;
    }

    private GuiQuestBook(EntityPlayer player, boolean isOpBook) {
        this.descriptionScroll = new ScrollBar(312, 18, 64, 249, 102, 180){

            @Override
            public boolean isVisible(GuiBase gui) {
                return !isBagPage && !isMainPageOpen && selectedSet != null && !isSetOpened && selectedSet.getDescription(gui).size() > 7;
            }
        };
        this.scrollBars.add(this.descriptionScroll);
        this.setScroll = new ScrollBar(160, 18, 186, 171, 69, 25){

            @Override
            public boolean isVisible(GuiBase gui) {
                return !isBagPage && !isMainPageOpen && (selectedSet == null || !isSetOpened) && Quest.getQuestSets().size() > 7;
            }
        };
        this.scrollBars.add(this.setScroll);
        this.mainDescriptionScroll = new ScrollBar(312, 18, 186, 171, 69, 180){

            @Override
            public boolean isVisible(GuiBase gui) {
                return !isBagPage && isMainPageOpen && Quest.getMainDescription(gui).size() > 21;
            }
        };
        this.scrollBars.add(this.mainDescriptionScroll);
        this.groupScroll = new ScrollBar(160, 18, 186, 171, 69, 20){

            @Override
            public boolean isVisible(GuiBase gui) {
                return isBagPage && selectedGroup == null && Group.getGroups().size() > 8;
            }
        };
        this.scrollBars.add(this.groupScroll);
        this.tierScroll = new ScrollBar(312, 18, 186, 171, 69, 180){

            @Override
            public boolean isVisible(GuiBase gui) {
                return isBagPage && selectedGroup == null && GroupTier.getTiers().size() > 8;
            }
        };
        this.scrollBars.add(this.tierScroll);
        this.textBoxes = new TextBoxGroup();
        this.textBoxGroupAmount = new TextBoxGroup.TextBox(this, "0", 180, 30, false){

            @Override
            protected boolean isCharacterValid(char c) {
                return this.getText().length() < 3 && Character.isDigit(c);
            }

            @Override
            protected void textChanged(GuiBase gui) {
                try {
                    int number = this.getText().equals("") ? 1 : Integer.parseInt(this.getText());
                    if (selectedGroup != null) {
                        selectedGroup.setLimit(number);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.textBoxes.add(this.textBoxGroupAmount);
        this.saveResult = null;
        this.buttons = new ArrayList<LargeButton>();
        this.saveButton = new LargeButton("Save all", 185, 190){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return Quest.isEditing && !isBagPage && !isMainPageOpen && !isSetOpened && selectedSet == null;
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                GuiQuestBook.this.saveResult = Quest.FILE_HELPER.saveData(null);
            }
        };
        this.buttons.add(this.saveButton);
        this.buttons.add(new LargeButton("Open", 245, 190){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return selectedSet != null && !isBagPage && !isSetOpened && !isMainPageOpen;
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                isSetOpened = true;
            }
        });
        this.buttons.add(new LargeButton("Create Set", 185, 50){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return Quest.getQuestSets().size() < DataBitHelper.QUEST_SETS.getMaximum();
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return Quest.isEditing && GuiQuestBook.this.currentMode == EditMode.CREATE && !isBagPage && !isSetOpened;
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                Quest.getQuestSets().add(new QuestSet("Unnamed set", "No description"));
            }
        });
        this.buttons.add(new LargeButton("Create Group", 100, 175){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return GroupTier.getTiers().size() > 0 && Group.getGroups().size() < DataBitHelper.GROUP_COUNT.getMaximum();
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return isBagPage && GuiQuestBook.this.currentMode == EditMode.CREATE && selectedGroup == null;
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                Group.add(new Group());
            }
        });
        this.buttons.add(new LargeButton("Create Tier", 100, 200){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return GroupTier.getTiers().size() < DataBitHelper.TIER_COUNT.getMaximum();
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return isBagPage && GuiQuestBook.this.currentMode == EditMode.CREATE && selectedGroup == null;
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                GroupTier.getTiers().add(new GroupTier("New Tier", GuiColor.BLACK, 0, 0, 0, 0, 0));
            }
        });
        this.buttons.add(new LargeButton("Reset", 245, 190){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return GuiScreen.func_73861_o() && GuiScreen.func_73877_p();
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return !isBagPage && !isMainPageOpen && selectedSet == null && GuiQuestBook.this.isOpBook && !Quest.isEditing;
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                OPBookHelper.reset(player);
            }
        });
        this.currentMode = EditMode.NORMAL;
        this.groupButtons = this.createButtons(EditMode.NORMAL, EditMode.ITEM, EditMode.DELETE);
        this.bagButtons = this.createButtons(EditMode.NORMAL, EditMode.CREATE, EditMode.RENAME, EditMode.TIER, EditMode.DELETE);
        this.mainButtons = this.createButtons(EditMode.NORMAL, EditMode.RENAME);
        this.overviewButtons = this.createButtons(EditMode.NORMAL, EditMode.CREATE, EditMode.RENAME, EditMode.SWAP_SELECT, EditMode.BAG, EditMode.DELETE);
        this.setButtons = this.createButtons(EditMode.NORMAL, EditMode.MOVE, EditMode.CREATE, EditMode.REQUIREMENT, EditMode.SIZE, EditMode.ITEM, EditMode.REPEATABLE, EditMode.TRIGGER, EditMode.QUEST_SELECTION, EditMode.QUEST_OPTION, EditMode.SWAP, EditMode.DELETE);
        this.questButtons = this.createButtons(EditMode.NORMAL, EditMode.RENAME, EditMode.TASK, EditMode.CHANGE_TASK, EditMode.ITEM, EditMode.LOCATION, EditMode.MOB, EditMode.DELETE);
        this.player = player;
        this.isOpBook = isOpBook;
        if (Quest.isEditing) {
            Keyboard.enableRepeatEvents((boolean)true);
        }
        QuestingData data = QuestingData.getQuestingData(player);
        if (!data.playedLore && SoundHandler.hasLoreMusic()) {
            SoundHandler.triggerFirstLore();
            data.playedLore = true;
        }
    }

    public void func_73874_b() {
        Keyboard.enableRepeatEvents((boolean)true);
        SoundHandler.stopLoreMusic();
        PacketHandler.closeInterface();
    }

    public static void displayGui(EntityPlayer player, boolean isOpBook) {
        if (!(player == null || Minecraft.func_71410_x().field_71462_r != null && Minecraft.func_71410_x().field_71462_r instanceof GuiQuestBook)) {
            Minecraft.func_71410_x().func_71373_a((GuiScreen)new GuiQuestBook(player, isOpBook));
        }
    }

    public void func_73876_c() {
        ++this.tick;
        super.func_73876_c();
    }

    public void func_73863_a(int x0, int y0, float f) {
        this.left = (this.field_73880_f - 340) / 2;
        this.top = (this.field_73881_g - 234) / 2;
        int x = x0 - this.left;
        int y = y0 - this.top;
        this.applyColor(-1);
        ResourceHelper.bindResource(BG_TEXTURE);
        this.drawRect(0, 0, 0, 0, 170, 234);
        this.drawRect(170, 0, 0, 0, 170, 234, RenderRotation.FLIP_HORIZONTAL);
        this.applyColor(-1);
        ResourceHelper.bindResource(MAP_TEXTURE);
        if (this.editMenu == null) {
            int start;
            int i;
            if (Quest.isEditing) {
                for (EditButton button : this.getButtons()) {
                    button.draw(x, y);
                }
            }
            for (ScrollBar scrollBar : this.scrollBars) {
                scrollBar.draw(this);
            }
            for (LargeButton button : this.buttons) {
                button.draw(this, this.player, x, y);
            }
            if (isBagPage) {
                if (selectedGroup != null) {
                    int yPos;
                    int i2;
                    this.drawString(selectedGroup.getName(), 20, 20, selectedGroup.getTier().getColor().getHexColor());
                    List<ItemStack> items = selectedGroup.getItems();
                    for (i2 = 0; i2 < Math.min(DataBitHelper.GROUP_ITEMS.getMaximum(), items.size() + 1); ++i2) {
                        ItemStack itemStack = i2 < items.size() ? items.get(i2) : null;
                        int xPos = i2 % 7 * 20 + 20;
                        yPos = i2 / 7 * 20 + 40;
                        this.drawItem(itemStack, xPos, yPos, x, y, false);
                    }
                    for (i2 = 0; i2 < items.size(); ++i2) {
                        ItemStack itemStack = items.get(i2);
                        int xPos = i2 % 7 * 20 + 20;
                        yPos = i2 / 7 * 20 + 40;
                        if (!this.inBounds(xPos, yPos, 18, 18, x, y)) continue;
                        if (itemStack == null || itemStack.func_77973_b() == null) break;
                        try {
                            this.drawMouseOver(itemStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x), x + this.left, y + this.top);
                        }
                        catch (Exception ignored) {}
                        break;
                    }
                    this.drawString("Maximum retrieval count", 180, 20, 0x404040);
                    this.drawString("Leave at 0 for no restriction", 180, 48, 0.7f, 0x404040);
                    this.textBoxes.draw(this);
                } else {
                    List<GroupTier> tiers = GroupTier.getTiers();
                    for (i = start = this.tierScroll.isVisible(this) ? Math.round((float)(tiers.size() - 8) * this.tierScroll.getScroll()) : 0; i < Math.min(start + 8, tiers.size()); ++i) {
                        GroupTier groupTier = tiers.get(i);
                        String str = groupTier.getName();
                        int yPos = 20 + 25 * (i - start);
                        boolean inBounds = this.inBounds(180, yPos, this.getStringWidth(str), 9, x, y);
                        int color = groupTier.getColor().getHexColor();
                        if (inBounds) {
                            color &= 0xFFFFFF;
                            color |= 0xBB000000;
                            GL11.glEnable((int)3042);
                        }
                        this.drawString(str, 180, yPos, color);
                        if (inBounds) {
                            GL11.glDisable((int)3042);
                        }
                        for (int j = 0; j < BagTier.values().length; ++j) {
                            BagTier bagTier = BagTier.values()[j];
                            this.drawCenteredString(bagTier.getColor().toString() + groupTier.getWeights()[j], 175 + j * 25, yPos + 12, 0.7f, 25, 0, 0x404040);
                        }
                    }
                    List<Group> groups = Group.getGroups();
                    for (int i3 = start = this.groupScroll.isVisible(this) ? Math.round((float)(groups.size() - 8) * this.groupScroll.getScroll()) : 0; i3 < Math.min(start + 8, groups.size()); ++i3) {
                        boolean selected;
                        Group group = groups.get(i3);
                        String str = group.getName();
                        int yPos = 20 + 25 * (i3 - start);
                        boolean inBounds = this.inBounds(20, yPos, this.getStringWidth(str), 9, x, y);
                        int color = group.getTier().getColor().getHexColor();
                        boolean bl = selected = group == this.modifyingGroup;
                        if (inBounds || selected) {
                            color &= 0xFFFFFF;
                            GL11.glEnable((int)3042);
                            color = selected ? (color |= 0x50000000) : (color |= 0xBB000000);
                        }
                        this.drawString(str, 20, yPos, color);
                        if (inBounds || selected) {
                            GL11.glDisable((int)3042);
                        }
                        this.drawString(group.getItems().size() + " items", 25, yPos + 12, 0.7f, 0x404040);
                    }
                }
            } else if (isMainPageOpen) {
                int startLine = this.mainDescriptionScroll.isVisible(this) ? Math.round((float)(Quest.getMainDescription(this).size() - 21) * this.mainDescriptionScroll.getScroll()) : 0;
                this.drawString(Quest.getMainDescription(this), startLine, 21, 180, 20, 0.7f, 0x404040);
                this.drawCenteredString("Click here to start", 0, 195, 0.7f, 170, 39, 0x707070);
                if (SoundHandler.hasLoreMusic() && !SoundHandler.isLorePlaying()) {
                    this.drawCenteredString("Click to play again", 170, 195, 0.7f, 160, 39, 0x707070);
                }
                if (QuestLine.getActiveQuestLine().front == null && QuestLine.getActiveQuestLine().mainPath != null) {
                    File file = new File(QuestLine.getActiveQuestLine().mainPath + "front.png");
                    if (file.exists()) {
                        try {
                            BufferedImage img = ImageIO.read(file);
                            DynamicTexture dm = new DynamicTexture(img);
                            QuestLine.getActiveQuestLine().front = Minecraft.func_71410_x().func_110434_K().func_110578_a(FRONT_KEY, dm);
                        }
                        catch (IOException ignored) {
                            QuestLine.getActiveQuestLine().front = ResourceHelper.getResource("front");
                        }
                    } else {
                        QuestLine.getActiveQuestLine().front = ResourceHelper.getResource("front");
                    }
                }
                if (QuestLine.getActiveQuestLine().front != null) {
                    ResourceHelper.bindResource(QuestLine.getActiveQuestLine().front);
                    this.applyColor(-1);
                    this.drawRect(20, 20, 0, 0, 140, 180);
                }
            } else if (selectedSet == null || !isSetOpened) {
                int total;
                List<QuestSet> questSets = Quest.getQuestSets();
                for (i = start = this.setScroll.isVisible(this) ? Math.round((float)(Quest.getQuestSets().size() - 7) * this.setScroll.getScroll()) : 0; i < Math.min(start + 7, questSets.size()); ++i) {
                    QuestSet questSet = questSets.get(i);
                    int setY = 20 + (i - start) * 29;
                    total = questSet.getQuests().size();
                    boolean enabled = questSet.isEnabled(this.player);
                    int completedCount = enabled ? questSet.getCompletedCount(this.player) : 0;
                    boolean completed = true;
                    for (Quest quest : questSet.getQuests()) {
                        if (quest.isCompleted(this.player) || !quest.isLinkFree(this.player)) continue;
                        completed = false;
                        break;
                    }
                    boolean selected = questSet == selectedSet;
                    boolean inBounds = this.inBounds(25, setY, this.getStringWidth(questSet.getName(i)), 9, x, y);
                    int color = this.modifyingQuestSet == questSet ? 0x4040DD : (enabled ? (completed ? (selected ? (inBounds ? 0x40BB40 : 0x40A040) : (inBounds ? 0x10A010 : 0x107010)) : (selected ? (inBounds ? 0xAAAAAA : 0x888888) : (inBounds ? 0x666666 : 0x404040))) : 0xDDDDDD);
                    this.drawString(questSet.getName(i), 25, setY, color);
                    String info = enabled ? (completed ? "All Quests Completed" : completedCount * 100 / total + "% Completed") : "Locked";
                    this.drawString(info, 35, setY + 12, 0.7f, color);
                }
                if (Quest.isEditing && this.currentMode == EditMode.CREATE) {
                    this.drawString(this.getLinesFromText("Click the button below to create a new empty quest set.", 0.7f, 130), 180, 20, 0.7f, 0x404040);
                } else {
                    if (selectedSet != null) {
                        int startLine = this.descriptionScroll.isVisible(this) ? Math.round((float)(selectedSet.getDescription(this).size() - 7) * this.descriptionScroll.getScroll()) : 0;
                        this.drawString(selectedSet.getDescription(this), startLine, 7, 180, 20, 0.7f, 0x404040);
                    }
                    int completed = 0;
                    int reward = 0;
                    int enabled = 0;
                    total = 0;
                    int realTotal = 0;
                    for (Quest quest : Quest.getQuests()) {
                        if (selectedSet != null && !quest.hasSet(selectedSet)) continue;
                        ++realTotal;
                        if (!quest.isVisible(this.player)) continue;
                        ++total;
                        if (!quest.isEnabled(this.player)) continue;
                        ++enabled;
                        if (!quest.isCompleted(this.player)) continue;
                        ++completed;
                        if (!quest.hasReward(this.player)) continue;
                        ++reward;
                    }
                    int teamY = this.isOpBook || Quest.isEditing ? 65 : 95;
                    int questY = this.isOpBook || Quest.isEditing ? 120 : 150;
                    ArrayList<String> info = new ArrayList<String>();
                    info.add(GuiColor.GRAY.toString() + total + " " + (total == 1 ? "quest" : "quests") + " in total");
                    info.add(GuiColor.CYAN.toString() + enabled + " unlocked " + (enabled == 1 ? "quest" : "quests"));
                    info.add(GuiColor.GREEN.toString() + completed + " completed " + (completed == 1 ? "quest" : "quests"));
                    info.add(GuiColor.LIGHT_BLUE.toString() + (enabled - completed) + " " + (enabled - completed == 1 ? "quest" : "quests") + " available for completion");
                    if (reward > 0) {
                        info.add(GuiColor.PURPLE.toString() + reward + " " + (reward == 1 ? "quest" : "quests") + " with unclaimed rewards");
                    }
                    if (Quest.isEditing && !GuiQuestBook.func_73861_o()) {
                        info.add(GuiColor.LIGHT_GRAY.toString() + realTotal + " " + (realTotal == 1 ? "quest" : "quests") + " including invisible ones");
                    }
                    this.drawString(info, 180, selectedSet == null ? questY + 13 : 100, 0.7f, 0x404040);
                    if (selectedSet == null) {
                        String str;
                        Team team;
                        this.drawString("Lives", 180, 20, 0x404040);
                        this.drawString("Party", 180, teamY, 0x404040);
                        this.drawString("Quests", 180, questY, 0x404040);
                        if (QuestingData.isHardcoreActive()) {
                            int spacing;
                            int count;
                            int heartX;
                            boolean almostOut;
                            boolean bl = almostOut = QuestingData.getQuestingData(this.player).getLives() == QuestingData.getQuestingData(this.player).getLivesToStayAlive();
                            if (almostOut) {
                                this.drawString((Object)((Object)GuiColor.RED) + "If you die, you're out.", 230, 22, 0.7f, 0x404040);
                            }
                            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            int lives = QuestingData.getQuestingData(this.player).getLives();
                            if (lives < 8) {
                                heartX = 185;
                                count = lives;
                                spacing = 18;
                            } else {
                                heartX = 205;
                                count = 3;
                                spacing = 3;
                                this.drawString(lives + " x", 185, 37, 0.7f, 0x404040);
                            }
                            for (int i4 = 0; i4 < count; ++i4) {
                                this.drawItem(new ItemStack(Items.hearts, 1, 3), heartX + spacing * i4, 32, almostOut);
                            }
                        } else {
                            this.drawString(this.getLinesFromText("Hardcore mode is not active, you have an infinite amount of lives.", 0.5f, 140), 180, 32, 0.5f, 0x707070);
                        }
                        if (!this.isOpBook && !Quest.isEditing) {
                            int deaths = DeathStats.getDeathStats(QuestingData.getUserName(this.player)).getTotalDeaths();
                            this.drawString("You've currently died " + deaths + " " + (deaths == 1 ? "time" : "times"), 180, 55, 0.7f, 0x404040);
                            this.drawString("Click here for more info", 180, 65, 0.7f, 0x707070);
                        }
                        if ((team = QuestingData.getQuestingData(this.player).getTeam()).isSingle()) {
                            int invites;
                            int n = invites = team.getInvites() == null ? 0 : team.getInvites().size();
                            str = invites > 0 ? "You have " + invites + " party " + (invites == 1 ? "invite" : "invites") : "You're currently not in a party.";
                        } else {
                            int players = 0;
                            for (Team.PlayerEntry player : team.getPlayers()) {
                                if (!player.isInTeam()) continue;
                                ++players;
                            }
                            str = "You're in a party with " + players + " " + (players == 1 ? "player" : "players");
                        }
                        this.drawString(str, 180, teamY + 12, 0.7f, 0x404040);
                        this.drawString("Click here to open party window", 180, teamY + 30, 0.7f, 0x707070);
                        if (this.isOpBook && !Quest.isEditing) {
                            this.drawString("Reset the quest progress for the entire party.", 177, 182, 0.6f, 0x404040);
                            this.drawString(this.getLinesFromText("Hold shift+ctrl while clicking to confirm.", 0.6f, 70), 177, 192, 0.6f, GuiColor.RED.getHexColor());
                        }
                    }
                }
                if (Quest.isEditing && this.saveResult != null) {
                    if (this.saveButton.inButtonBounds(this, x, y)) {
                        String str = (this.saveResult == FileHelper.SaveResult.SUCCESS ? GuiColor.GREEN : GuiColor.RED).toString();
                        str = str + this.saveResult.getName() + "\n\n";
                        str = str + (Object)((Object)GuiColor.WHITE);
                        str = str + this.saveResult.getText();
                        this.drawMouseOver(this.getLinesFromText(str, 1.0f, 130), x + this.left, y + this.top);
                    } else {
                        this.saveResult = null;
                    }
                }
            } else if (selectedQuest == null) {
                int color;
                if (this.isOpBook) {
                    this.drawString(this.getLinesFromText("Hold shift and click on quests to automatically complete them or reset their progress.", 0.7f, 130), 184, 192, 0.7f, 0x707070);
                }
                for (Quest child : selectedSet.getQuests()) {
                    if (!Quest.isEditing && !child.isVisible(this.player)) continue;
                    for (Quest parent : child.getRequirement()) {
                        if (!Quest.isEditing && !parent.isVisible(this.player) || !parent.hasSameSetAs(child)) continue;
                        color = Quest.isEditing && (!child.isVisible(this.player) || !parent.isVisible(this.player)) ? 0x55404040 : -12566464;
                        this.drawLine(this.left + parent.getGuiCenterX(), this.top + parent.getGuiCenterY(), this.left + child.getGuiCenterX(), this.top + child.getGuiCenterY(), 5, color);
                    }
                }
                if (Quest.isEditing) {
                    for (Quest child : selectedSet.getQuests()) {
                        for (Quest parent : child.getOptionLinks()) {
                            if (!parent.hasSameSetAs(child)) continue;
                            color = !child.isVisible(this.player) || !parent.isVisible(this.player) ? 1430274269 : -12566307;
                            this.drawLine(this.left + parent.getGuiCenterX(), this.top + parent.getGuiCenterY(), this.left + child.getGuiCenterX(), this.top + child.getGuiCenterY(), 5, color);
                        }
                    }
                }
                for (Quest quest : selectedSet.getQuests()) {
                    if (!Quest.isEditing && !quest.isVisible(this.player)) continue;
                    GL11.glPushMatrix();
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    this.applyColor(quest == this.modifyingQuest ? -4456517 : quest.getColorFilter(this.player, this.tick));
                    ResourceHelper.bindResource(MAP_TEXTURE);
                    this.drawRect(quest.getGuiX(), quest.getGuiY(), quest.getGuiU(), quest.getGuiV(this.player, x, y), quest.getGuiW(), quest.getGuiH());
                    int iconX = quest.getGuiCenterX() - 8;
                    int iconY = quest.getGuiCenterY() - 8;
                    if (quest.useBigIcon()) {
                        ++iconX;
                        ++iconY;
                    }
                    this.drawItem(quest.getIcon(), iconX, iconY, true);
                    GL11.glPopMatrix();
                }
                for (Quest quest : selectedSet.getQuests()) {
                    boolean editing;
                    boolean bl = editing = Quest.isEditing && !GuiQuestBook.func_73861_o();
                    if (!editing && !quest.isVisible(this.player) || !quest.isMouseInObject(x, y)) continue;
                    boolean shouldDrawText = false;
                    boolean enabled = quest.isEnabled(this.player);
                    String txt = "";
                    if (enabled || editing) {
                        txt = txt + quest.getName();
                    }
                    if (!enabled) {
                        if (editing) {
                            txt = txt + "\n";
                        }
                        txt = txt + (Object)((Object)GuiColor.GRAY) + "Locked Quest";
                    }
                    if (!enabled || editing) {
                        int totalParentCount = 0;
                        int totalCompletedCount = 0;
                        int parentCount = 0;
                        int completed = 0;
                        ArrayList<Quest> externalQuests = new ArrayList<Quest>();
                        for (Quest parent : quest.getRequirement()) {
                            ++totalParentCount;
                            boolean isCompleted = parent.isCompleted(this.player);
                            if (isCompleted) {
                                ++totalCompletedCount;
                            }
                            if (parent.hasSameSetAs(quest)) continue;
                            externalQuests.add(parent);
                            ++parentCount;
                            if (!isCompleted) continue;
                            ++completed;
                        }
                        if (editing && totalParentCount > 0) {
                            txt = txt + "\n" + (Object)((Object)GuiColor.GRAY) + "Requires " + (totalParentCount - totalCompletedCount) + "/" + totalParentCount + " " + (totalParentCount == 1 ? "quest" : "quests") + " to be completed.";
                            if (Keyboard.isKeyDown((int)19)) {
                                txt = txt + " [Holding R]";
                                for (Quest parent : quest.getRequirement()) {
                                    txt = txt + "\n" + (Object)((Object)GuiColor.GRAY) + parent.getName();
                                    if (!parent.isCompleted(this.player)) continue;
                                    txt = txt + " " + (Object)((Object)GuiColor.WHITE) + " [Completed]";
                                }
                            } else {
                                txt = txt + " [Hold R]";
                            }
                        }
                        if (parentCount - completed > 0 || editing && parentCount > 0) {
                            txt = txt + "\n" + (Object)((Object)GuiColor.PINK) + "Requires " + (parentCount - completed) + "/" + parentCount + " " + (parentCount == 1 ? "quest" : "quests") + " to be completed elsewhere.";
                            shouldDrawText = true;
                            if (editing) {
                                if (Keyboard.isKeyDown((int)18)) {
                                    txt = txt + " [Holding E]";
                                    for (Quest parent : externalQuests) {
                                        txt = txt + "\n" + (Object)((Object)GuiColor.PINK) + parent.getName() + " (" + parent.getQuestSet().getName() + ")";
                                        if (!parent.isCompleted(this.player)) continue;
                                        txt = txt + " " + (Object)((Object)GuiColor.WHITE) + " [Completed]";
                                    }
                                } else {
                                    txt = txt + " [Hold E]";
                                }
                            }
                        }
                    }
                    if (enabled || editing) {
                        String repeatMessage;
                        if (quest.isCompleted(this.player)) {
                            txt = txt + "\n" + (Object)((Object)GuiColor.GREEN) + "Completed";
                        }
                        if (quest.hasReward(this.player)) {
                            txt = txt + "\n" + (Object)((Object)GuiColor.PURPLE) + "Unclaimed reward";
                        }
                        String string = repeatMessage = enabled ? quest.getRepeatInfo().getMessage(quest, this.player) : quest.getRepeatInfo().getShortMessage();
                        if (repeatMessage != null) {
                            txt = txt + "\n" + repeatMessage;
                        }
                        if (editing) {
                            int totalTasks = 0;
                            int completedTasks = 0;
                            for (QuestTask task : quest.getTasks()) {
                                ++totalTasks;
                                if (!task.isCompleted(this.player)) continue;
                                ++completedTasks;
                            }
                            if (totalTasks == 0) {
                                txt = txt + "\n" + (Object)((Object)GuiColor.RED) + "This quest has no tasks!";
                            } else {
                                txt = txt + "\n" + (Object)((Object)GuiColor.CYAN) + completedTasks + "/" + totalTasks + " completed tasks.";
                                if (Keyboard.isKeyDown((int)20)) {
                                    txt = txt + " [Holding T]";
                                    for (QuestTask task : quest.getTasks()) {
                                        txt = txt + "\n" + (Object)((Object)GuiColor.CYAN) + task.getDescription();
                                        if (!task.isCompleted(this.player)) continue;
                                        txt = txt + (Object)((Object)GuiColor.WHITE) + " [Completed]";
                                    }
                                } else {
                                    txt = txt + " [Hold T]";
                                }
                            }
                            String triggerMessage = quest.getTriggerType().getMessage(quest);
                            if (triggerMessage != null) {
                                txt = txt + "\n" + triggerMessage;
                            }
                            if (!quest.isVisible(this.player)) {
                                String invisibilityMessage;
                                if (quest.isLinkFree(this.player)) {
                                    boolean parentInvisible = false;
                                    for (Quest parent : quest.getRequirement()) {
                                        if (parent.isVisible(this.player)) continue;
                                        parentInvisible = true;
                                        break;
                                    }
                                    switch (quest.getTriggerType()) {
                                        case ANTI_TRIGGER: {
                                            invisibilityMessage = "Invisible while locked";
                                            break;
                                        }
                                        case QUEST_TRIGGER: {
                                            invisibilityMessage = "Permanently invisible";
                                            parentInvisible = false;
                                            break;
                                        }
                                        case TASK_TRIGGER: {
                                            invisibilityMessage = "Invisible until " + quest.getTriggerTasks() + " " + (quest.getTriggerTasks() > 1 ? "tasks have" : "task has") + " been completed.";
                                            break;
                                        }
                                        default: {
                                            invisibilityMessage = null;
                                        }
                                    }
                                    if (parentInvisible) {
                                        String parentText = "Inherited invisibility";
                                        invisibilityMessage = invisibilityMessage == null ? parentText : parentText + " and " + invisibilityMessage;
                                    }
                                } else {
                                    invisibilityMessage = "Invisible through quest option.";
                                }
                                if (invisibilityMessage != null) {
                                    txt = txt + "\n" + (Object)((Object)GuiColor.LIGHT_BLUE) + invisibilityMessage;
                                }
                            }
                            ArrayList<Integer> ids = new ArrayList<Integer>();
                            for (Quest option : quest.getOptionLinks()) {
                                ids.add(Integer.valueOf(option.getId()));
                            }
                            for (Quest option : quest.getReversedOptionLinks()) {
                                short id = option.getId();
                                if (ids.contains(id)) continue;
                                ids.add(Integer.valueOf(id));
                            }
                            int optionLinks = ids.size();
                            if (optionLinks > 0) {
                                txt = txt + "\n" + (Object)((Object)GuiColor.BLUE) + "Connected to " + optionLinks + " " + (optionLinks > 1 ? "quests" : "quest") + " through option links.";
                                if (Keyboard.isKeyDown((int)24)) {
                                    txt = txt + " [Holding O]";
                                    Iterator<Quest> i$ = ids.iterator();
                                    while (i$.hasNext()) {
                                        int id = (Integer)((Object)i$.next());
                                        Quest option = Quest.getQuest(id);
                                        txt = txt + "\n" + (Object)((Object)GuiColor.BLUE) + option.getName();
                                        if (option.hasSameSetAs(quest)) continue;
                                        txt = txt + " (" + option.getQuestSet().getName() + ")";
                                    }
                                } else {
                                    txt = txt + " [Hold O]";
                                }
                            }
                        }
                        ArrayList<Quest> externalQuests = new ArrayList<Quest>();
                        int childCount = 0;
                        for (Quest child : quest.getReversedRequirement()) {
                            if (quest.hasSameSetAs(child)) continue;
                            ++childCount;
                            externalQuests.add(child);
                        }
                        if (childCount > 0) {
                            txt = txt + "\n" + (Object)((Object)GuiColor.PINK) + "Unlocks " + childCount + " " + (childCount == 1 ? "quest" : "quests") + " elsewhere.";
                            if (editing) {
                                if (Keyboard.isKeyDown((int)22)) {
                                    txt = txt + " [Holding U]";
                                    for (Quest child : externalQuests) {
                                        txt = txt + "\n" + (Object)((Object)GuiColor.PINK) + child.getName() + " (" + child.getQuestSet().getName() + ")";
                                    }
                                } else {
                                    txt = txt + " [Hold U]";
                                }
                            }
                        }
                        shouldDrawText = true;
                    }
                    if (editing) {
                        txt = txt + "\n\n" + (Object)((Object)GuiColor.GRAY) + "Hold Ctrl to see this as a non-editor.";
                    }
                    if (this.isOpBook && GuiScreen.func_73877_p()) {
                        txt = quest.isCompleted(this.player) ? txt + "\n\n" + (Object)((Object)GuiColor.RED) + "Click to reset quest" : txt + "\n\n" + (Object)((Object)GuiColor.ORANGE) + "Click to complete quest";
                    }
                    if (shouldDrawText) {
                        this.drawMouseOver(txt, x0, y0);
                    }
                    break;
                }
            } else {
                selectedQuest.drawMenu(this, this.player, x, y);
            }
            if (Quest.isEditing) {
                for (EditButton button : this.getButtons()) {
                    button.drawInfo(x, y);
                }
            }
            for (LargeButton button : this.buttons) {
                button.drawMouseOver(this, this.player, x, y);
            }
            if (this.currentMode == EditMode.DELETE) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)200.0f);
                this.drawCenteredString("WARNING!", 0, 0, 2.0f, 340, 234, 0xFF0000);
                this.drawCenteredString("You're now deleting everything you click on!", 0, this.field_73886_k.field_78288_b * 2, 1.0f, 340, 234, 0xFF0000);
                this.applyColor(-1);
                ResourceHelper.bindResource(MAP_TEXTURE);
                GL11.glPopMatrix();
            }
        } else {
            this.editMenu.draw(this, x, y);
            this.editMenu.drawMouseOver(this, x, y);
        }
    }

    public void func_73867_d() {
        super.func_73867_d();
        int x = Mouse.getEventX() * this.field_73880_f / this.field_73882_e.field_71443_c - this.left;
        int y = this.field_73881_g - Mouse.getEventY() * this.field_73881_g / this.field_73882_e.field_71440_d - 1 - this.top;
        int scroll = Mouse.getEventDWheel();
        if (scroll != 0) {
            if (this.editMenu != null) {
                this.editMenu.onScroll(this, x, y, scroll);
            } else if (selectedQuest != null) {
                selectedQuest.onScroll(this, x, y, scroll);
            } else {
                for (ScrollBar scrollBar : this.scrollBars) {
                    scrollBar.onScroll(this, x, y, scroll);
                }
            }
        }
    }

    protected void func_73869_a(char c, int k) {
        super.func_73869_a(c, k);
        if (this.editMenu != null) {
            this.editMenu.onKeyTyped(this, c, k);
        } else if (isBagPage && selectedGroup != null) {
            this.textBoxes.onKeyStroke(this, c, k);
        }
    }

    protected void func_73864_a(int x0, int y0, int button) {
        super.func_73864_a(x0, y0, button);
        int x = x0 - this.left;
        int y = y0 - this.top;
        if (this.editMenu == null) {
            int start;
            int i;
            if (Quest.isEditing) {
                for (EditButton editButton : this.getButtons()) {
                    if (!editButton.onClick(x, y)) continue;
                    if (this.currentMode != EditMode.BAG) break;
                    this.currentMode = EditMode.NORMAL;
                    isBagPage = true;
                    break;
                }
            }
            for (ScrollBar scrollBar : this.scrollBars) {
                scrollBar.onClick(this, x, y);
            }
            for (LargeButton largeButton : this.buttons) {
                if (!largeButton.isVisible(this, this.player) || !largeButton.isEnabled(this, this.player) || !largeButton.inButtonBounds(this, x, y)) continue;
                largeButton.onClick(this, this.player);
            }
            if (isBagPage) {
                if (selectedGroup != null) {
                    if (button == 1) {
                        selectedGroup = null;
                    } else {
                        List<ItemStack> items = selectedGroup.getItems();
                        for (int i2 = 0; i2 < Math.min(DataBitHelper.GROUP_ITEMS.getMaximum(), items.size() + 1); ++i2) {
                            int xPos = i2 % 7 * 20 + 20;
                            int yPos = i2 / 7 * 20 + 40;
                            if (!this.inBounds(xPos, yPos, 18, 18, x, y)) continue;
                            if (this.currentMode == EditMode.ITEM) {
                                int amount;
                                ItemStack itemStack;
                                ItemStack itemStack2 = itemStack = i2 < items.size() ? items.get(i2) : null;
                                if (itemStack != null) {
                                    itemStack = itemStack.func_77946_l();
                                    amount = itemStack.field_77994_a;
                                } else {
                                    amount = 1;
                                }
                                this.editMenu = new GuiEditMenuItem((GuiBase)this, this.player, itemStack, i2, GuiEditMenuItem.Type.BAG_ITEM, amount, ItemPrecision.PRECISE);
                                break;
                            }
                            if (this.currentMode != EditMode.DELETE) break;
                            selectedGroup.removeItem(i2);
                            break;
                        }
                        this.textBoxes.onClick(this, x, y);
                    }
                } else if (button == 1) {
                    isBagPage = false;
                } else {
                    List<Group> groups = Group.getGroups();
                    for (i = start = this.groupScroll.isVisible(this) ? Math.round((float)(groups.size() - 8) * this.groupScroll.getScroll()) : 0; i < Math.min(start + 8, groups.size()); ++i) {
                        int posY = 20 + 25 * (i - start);
                        Group group = groups.get(i);
                        if (!this.inBounds(20, posY, this.getStringWidth(group.getName()), 9, x, y)) continue;
                        if (this.currentMode == EditMode.TIER) {
                            if (group == this.modifyingGroup) {
                                this.modifyingGroup = null;
                                break;
                            }
                            this.modifyingGroup = group;
                            break;
                        }
                        if (this.currentMode == EditMode.NORMAL) {
                            selectedGroup = group;
                            this.textBoxGroupAmount.setTextAndCursor(this, String.valueOf(selectedGroup.getLimit()));
                            break;
                        }
                        if (this.currentMode == EditMode.RENAME) {
                            this.editMenu = new GuiEditMenuTextEditor(this, this.player, group);
                            break;
                        }
                        if (this.currentMode != EditMode.DELETE) break;
                        group.remove(i);
                        break;
                    }
                    List<GroupTier> tiers = GroupTier.getTiers();
                    for (int i3 = start = this.tierScroll.isVisible(this) ? Math.round((float)(tiers.size() - 8) * this.tierScroll.getScroll()) : 0; i3 < Math.min(start + 8, tiers.size()); ++i3) {
                        int posY = 20 + 25 * (i3 - start);
                        GroupTier groupTier = tiers.get(i3);
                        if (!this.inBounds(180, posY, this.getStringWidth(groupTier.getName()), 9, x, y)) continue;
                        if (this.currentMode == EditMode.NORMAL) {
                            this.editMenu = new GuiEditMenuTier(this, this.player, groupTier);
                        } else if (this.currentMode == EditMode.TIER && this.modifyingGroup != null) {
                            this.modifyingGroup.setTier(groupTier);
                        } else if (this.currentMode == EditMode.RENAME) {
                            this.editMenu = new GuiEditMenuTextEditor(this, this.player, groupTier);
                        } else if (this.currentMode == EditMode.DELETE && (tiers.size() > 1 || groups.size() == 0)) {
                            for (Group group : groups) {
                                if (group.getTier() != groupTier) continue;
                                group.setTier(i3 == 0 ? tiers.get(1) : tiers.get(0));
                            }
                            tiers.remove(i3);
                        }
                        break;
                    }
                }
            } else if (isMainPageOpen) {
                if (x > 0 && x < 170 && y > 205) {
                    isMainPageOpen = false;
                    SoundHandler.stopLoreMusic();
                } else if (x > 170 && x < 340 && y > 205) {
                    if (SoundHandler.hasLoreMusic() && !SoundHandler.isLorePlaying()) {
                        SoundHandler.playLoreMusic();
                    }
                } else if (Quest.isEditing && this.currentMode == EditMode.RENAME && this.inBounds(180, 20, 130, 132, x, y)) {
                    this.editMenu = new GuiEditMenuTextEditor(this, this.player);
                }
            } else if (selectedSet == null || !isSetOpened) {
                if (button == 1) {
                    isMainPageOpen = true;
                    return;
                }
                if (selectedSet == null && this.inBounds(180, (this.isOpBook || Quest.isEditing ? 65 : 95) + 30, 170, 6, x, y)) {
                    this.editMenu = new GuiEditMenuTeam(this, this.player);
                    return;
                }
                if (!this.isOpBook && !Quest.isEditing && selectedSet == null && this.inBounds(180, 65, 170, 6, x, y)) {
                    this.editMenu = new GuiEditMenuDeath(this, this.player);
                    return;
                }
                List<QuestSet> questSets = Quest.getQuestSets();
                for (i = start = this.setScroll.isVisible(this) ? Math.round((float)(Quest.getQuestSets().size() - 7) * this.setScroll.getScroll()) : 0; i < Math.min(start + 7, questSets.size()); ++i) {
                    int setY = 20 + (i - start) * 29;
                    QuestSet questSet = questSets.get(i);
                    if (!this.inBounds(25, setY, this.getStringWidth(questSet.getName(i)), 9, x, y)) continue;
                    if (Quest.isEditing && this.currentMode == EditMode.DELETE && questSet.getQuests().isEmpty()) {
                        for (int j = questSet.getId() + 1; j < Quest.getQuestSets().size(); ++j) {
                            Quest.getQuestSets().get(j).decreaseId();
                        }
                        Quest.getQuestSets().remove(questSet);
                        break;
                    }
                    if (Quest.isEditing && this.currentMode == EditMode.SWAP_SELECT) {
                        if (this.modifyingQuestSet == questSet) {
                            this.modifyingQuestSet = null;
                            break;
                        }
                        this.modifyingQuestSet = questSet;
                        break;
                    }
                    if (Quest.isEditing && this.currentMode == EditMode.RENAME) {
                        this.editMenu = new GuiEditMenuTextEditor(this, this.player, questSet, true);
                        break;
                    }
                    if ((!Quest.isEditing || this.currentMode != EditMode.NORMAL) && (Quest.isEditing || !questSet.isEnabled(this.player))) break;
                    if (selectedSet == questSet) {
                        selectedSet = null;
                        break;
                    }
                    selectedSet = questSet;
                    break;
                }
                if (Quest.isEditing && this.currentMode == EditMode.RENAME && this.inBounds(180, 20, 130, 44, x, y)) {
                    this.editMenu = new GuiEditMenuTextEditor(this, this.player, selectedSet, false);
                }
            } else if (selectedQuest == null) {
                if (button == 1) {
                    isSetOpened = false;
                } else if (Quest.isEditing && this.currentMode == EditMode.CREATE) {
                    if (x > 0 && Quest.size() < DataBitHelper.QUESTS.getMaximum()) {
                        Quest newQuest = new Quest(Quest.size(), "Unnamed", "Unnamed quest", 0, 0, false);
                        newQuest.setGuiCenterX(x);
                        newQuest.setGuiCenterY(y);
                        newQuest.setQuestSet(selectedSet);
                    }
                } else {
                    for (Quest quest : selectedSet.getQuests()) {
                        if (!Quest.isEditing && !quest.isVisible(this.player) || !quest.isMouseInObject(x, y)) continue;
                        if (Quest.isEditing && this.currentMode != EditMode.NORMAL) {
                            if (this.currentMode == EditMode.MOVE) {
                                this.modifyingQuest = quest;
                            } else if (this.currentMode == EditMode.REQUIREMENT) {
                                if (this.modifyingQuest == quest) {
                                    if (GuiScreen.func_73877_p()) {
                                        this.modifyingQuest.clearRequirements();
                                    }
                                    this.modifyingQuest = null;
                                } else if (this.modifyingQuest == null) {
                                    this.modifyingQuest = quest;
                                } else {
                                    this.modifyingQuest.addRequirement(quest.getId());
                                }
                            } else if (this.currentMode == EditMode.SIZE) {
                                int cX = quest.getGuiCenterX();
                                int cY = quest.getGuiCenterY();
                                quest.setBigIcon(!quest.useBigIcon());
                                quest.setGuiCenterX(cX);
                                quest.setGuiCenterY(cY);
                            } else if (this.currentMode == EditMode.ITEM) {
                                this.editMenu = new GuiEditMenuItem((GuiBase)this, this.player, quest.getIcon(), (int)quest.getId(), GuiEditMenuItem.Type.QUEST_ICON, 1, ItemPrecision.PRECISE);
                            } else if (this.currentMode == EditMode.DELETE) {
                                Quest.removeQuest(quest);
                            } else if (this.currentMode == EditMode.SWAP && this.modifyingQuestSet != null && this.modifyingQuestSet != selectedSet) {
                                quest.setQuestSet(this.modifyingQuestSet);
                            } else if (this.currentMode == EditMode.REPEATABLE) {
                                this.editMenu = new GuiEditMenuRepeat(this, this.player, quest);
                            } else if (this.currentMode == EditMode.TRIGGER) {
                                this.editMenu = new GuiEditMenuTrigger(this, this.player, quest);
                            } else if (this.currentMode == EditMode.QUEST_SELECTION) {
                                Quest.selectedQuestId = quest.getId();
                            } else if (this.currentMode == EditMode.QUEST_OPTION) {
                                if (this.modifyingQuest == quest) {
                                    if (GuiScreen.func_73877_p()) {
                                        this.modifyingQuest.clearOptionLinks();
                                    }
                                    this.modifyingQuest = null;
                                } else if (this.modifyingQuest == null) {
                                    this.modifyingQuest = quest;
                                } else {
                                    this.modifyingQuest.addOptionLink(quest.getId());
                                }
                            }
                        } else if (quest.isEnabled(this.player) || Quest.isEditing) {
                            if (this.isOpBook && GuiScreen.func_73877_p()) {
                                OPBookHelper.reverseQuestCompletion(quest, this.player);
                            } else {
                                selectedQuest = quest;
                                quest.onOpen(this, this.player);
                            }
                        }
                        break;
                    }
                }
            } else {
                selectedQuest.onClick(this, this.player, x, y, button);
            }
        } else {
            this.editMenu.onClick(this, x, y, button);
        }
    }

    protected void func_73879_b(int x0, int y0, int button) {
        super.func_73879_b(x0, y0, button);
        int x = x0 - this.left;
        int y = y0 - this.top;
        this.updatePosition(x, y);
        if (this.currentMode == EditMode.MOVE) {
            this.modifyingQuest = null;
        }
        if (this.editMenu != null) {
            this.editMenu.onRelease(this, x, y);
        } else if (selectedQuest != null) {
            selectedQuest.onRelease(this, this.player, x, y, button);
        } else {
            for (ScrollBar scrollBar : this.scrollBars) {
                scrollBar.onRelease(this, x, y);
            }
        }
    }

    protected void func_85041_a(int x0, int y0, int button, long ticks) {
        super.func_85041_a(x0, y0, button, ticks);
        int x = x0 - this.left;
        int y = y0 - this.top;
        this.updatePosition(x, y);
        if (this.editMenu != null) {
            this.editMenu.onDrag(this, x, y);
        } else if (selectedQuest != null) {
            selectedQuest.onDrag(this, this.player, x, y, button);
        } else {
            for (ScrollBar scrollBar : this.scrollBars) {
                scrollBar.onDrag(this, x, y);
            }
        }
    }

    private void updatePosition(int x, int y) {
        if (this.modifyingQuest != null && this.currentMode == EditMode.MOVE && Quest.isEditing) {
            this.modifyingQuest.setGuiCenterX(x);
            this.modifyingQuest.setGuiCenterY(y);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void loadMap() {
        selectedQuest = null;
    }

    public EditMode getCurrentMode() {
        return this.currentMode;
    }

    public Quest getSelectedQuest() {
        return selectedQuest;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    private EditButton[] getButtons() {
        return isBagPage ? (selectedGroup != null ? this.groupButtons : this.bagButtons) : (isMainPageOpen ? this.mainButtons : (selectedSet == null || !isSetOpened ? this.overviewButtons : (selectedQuest == null ? this.setButtons : this.questButtons)));
    }

    private EditButton[] createButtons(EditMode ... modes) {
        EditButton[] ret = new EditButton[modes.length];
        for (int i = 0; i < modes.length; ++i) {
            EditMode mode = modes[i];
            ret[i] = new EditButton(mode, i);
        }
        return ret;
    }

    static {
        isMainPageOpen = true;
        BG_TEXTURE = ResourceHelper.getResource("book");
    }

    public class EditButton {
        private int x;
        private int y;
        private EditMode mode;
        private List<String> text;

        public EditButton(EditMode mode, int id) {
            this.mode = mode;
            this.x = -30;
            this.y = 5 + id * 20;
        }

        private void draw(int mX, int mY) {
            int srcY = GuiQuestBook.this.currentMode == this.mode ? 2 : (GuiQuestBook.this.inBounds(this.x, this.y, 16, 16, mX, mY) ? 1 : 0);
            GuiQuestBook.this.drawRect(this.x, this.y, 240, srcY * 16, 16, 16);
            GuiQuestBook.this.drawRect(this.x + 2, this.y + 2, 0 + this.mode.ordinal() % 4 * 12, 0 + this.mode.ordinal() / 4 * 12, 12, 12);
        }

        private void drawInfo(int mX, int mY) {
            if (GuiQuestBook.this.inBounds(this.x, this.y, 16, 16, mX, mY)) {
                if (this.text == null) {
                    this.text = GuiQuestBook.this.getLinesFromText(this.mode.getName() + "\n\n" + this.mode.getDescription(), 1.0f, 150);
                    for (int i = 1; i < this.text.size(); ++i) {
                        this.text.set(i, (Object)((Object)GuiColor.GRAY) + this.text.get(i));
                    }
                }
                GuiQuestBook.this.drawMouseOver(this.text, mX + 30 + GuiQuestBook.this.left, mY + GuiQuestBook.this.top);
            }
        }

        private boolean onClick(int mX, int mY) {
            if (GuiQuestBook.this.inBounds(this.x, this.y, 16, 16, mX, mY)) {
                GuiQuestBook.this.currentMode = this.mode;
                GuiQuestBook.this.modifyingQuest = null;
                return true;
            }
            return false;
        }
    }

    public static enum EditMode {
        NORMAL("Cursor", "Use the book as if you would be in play mode."),
        MOVE("Move", "Click and drag to move quests"),
        CREATE("Create", "Click to create quests, quest sets, reward groups or reward tiers."),
        REQUIREMENT("Quest Requirements", "Click on a quest to select it and then click on the quests you want as requirements for the selected quest.\n\nHold shift and click on the selected quest to remove its requirements."),
        SIZE("Change Size", "Click on a quest to change its size, this is purely visual and has no impact on how the quest works."),
        RENAME("Edit Text", "Click on the text you want to edit. Works with names and descriptions for quest sets, quests, tasks, main lore, reward groups and reward tiers."),
        ITEM("Change Item", "Click on an item or item slot to open the item selector. This works for quest rewards and task items. It also works for quest icons, simply click on the quest for that."),
        TASK("Create Task", "Opens up the task creation menu."),
        DELETE("Delete", "Be careful with this one, things you click on will be deleted. Works with quest sets, quests, tasks, rewards and task items."),
        SWAP("Change Set", "Click on a quest to move it to another set. Before using this you will have to use the \"Target Set\" command to select a target set."),
        SWAP_SELECT("Target Set", "Mark a set as the target for quest movement. The \"Change Set\" command can then be used to move quests to this set"),
        TIER("Set group tier", "Selected a group and then click on a tier to set the group's tier."),
        BAG("Reward Bags", "Open up the reward bag menu. Here you will be able to modify the group tiers and add groups of items for the reward bags.\n\nRemember that you will have to save these as well, you use the normal button for it."),
        LOCATION("Edit Location", "Edit the target location for location tasks."),
        REPEATABLE("Set Repeatability", "Change if a quest should be repeatable or not, and if so, the properties of the repeatability."),
        TRIGGER("Trigger Quests", "Specify any properties for trigger quests."),
        MOB("Edit Monster", "Edit the monster target for killing tasks."),
        QUEST_SELECTION("Select Quest", "Mark a quest as the selected quest. When a quest is selected you can bind it to a Quest Tracker System or a Quest Gate System by right clicking it with a book."),
        QUEST_OPTION("Quest Option", "Click on a quest to select it and then click on the quests you want to link it to. If an option linked quest is completed all quests it's linked to becomes invisible and uncompletable. \n\nHold shift and click on the selected quest to remove all its links."),
        CHANGE_TASK("Change Task", "Change the task type of item tasks.");

        private String name;
        private String description;

        private EditMode(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

