/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client.interfaces;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.bag.Group;
import hardcorequesting.bag.GroupTier;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiEditMenu;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.LargeButton;
import hardcorequesting.client.interfaces.TextBoxLogic;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestSet;
import hardcorequesting.quests.QuestTask;
import hardcorequesting.quests.QuestTaskLocation;
import hardcorequesting.quests.QuestTaskMob;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;

@SideOnly(value=Side.CLIENT)
public class GuiEditMenuTextEditor
extends GuiEditMenu {
    private static final int TEXT_HEIGHT = 9;
    private TextBoxLogic text;
    private Quest quest;
    private QuestTask task;
    private QuestSet questSet;
    private Group group;
    private GroupTier groupTier;
    private int location = -1;
    private int mob = -1;
    private boolean isName;
    private static final int START_X = 20;
    private static final int START_Y = 20;
    private static final int LINES_PER_PAGE = 21;

    private GuiEditMenuTextEditor(GuiQuestBook gui, EntityPlayer player, String txt, boolean isName) {
        super(gui, player, false);
        this.text = new TextBoxLogic(gui, txt, 140, true);
        this.text.setMaxLength(isName ? DataBitHelper.QUEST_NAME_LENGTH.getMaximum() : DataBitHelper.QUEST_DESCRIPTION_LENGTH.getMaximum());
        this.isName = isName;
        this.buttons.add(new LargeButton("Copy all", 185, 20){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                GuiScreen.func_73865_d((String)GuiEditMenuTextEditor.this.text.getText());
            }
        });
        this.buttons.add(new LargeButton("Paste", 245, 20){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                GuiEditMenuTextEditor.this.text.addText(gui, GuiScreen.func_73870_l());
            }
        });
        this.buttons.add(new LargeButton("Clear", 185, 40){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                GuiEditMenuTextEditor.this.text.setTextAndCursor(gui, "");
            }
        });
        this.buttons.add(new LargeButton("Clear & Paste", 245, 40){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                GuiEditMenuTextEditor.this.text.setTextAndCursor(gui, GuiScreen.func_73870_l());
            }
        });
    }

    public GuiEditMenuTextEditor(GuiQuestBook gui, EntityPlayer player, QuestTask task, boolean isName) {
        this(gui, player, isName ? task.getDescription() : task.getLongDescription(), isName);
        this.task = task;
    }

    public GuiEditMenuTextEditor(GuiQuestBook gui, EntityPlayer player, Quest quest, boolean isName) {
        this(gui, player, isName ? quest.getName() : quest.getDescription(), isName);
        this.quest = quest;
    }

    public GuiEditMenuTextEditor(GuiQuestBook gui, EntityPlayer player, QuestSet questSet, boolean isName) {
        this(gui, player, isName ? questSet.getName() : questSet.getDescription(), isName);
        this.questSet = questSet;
    }

    public GuiEditMenuTextEditor(GuiQuestBook gui, EntityPlayer player) {
        this(gui, player, Quest.getRawMainDescription(), false);
    }

    public GuiEditMenuTextEditor(GuiQuestBook gui, EntityPlayer player, Group group) {
        this(gui, player, group.getName(), true);
        this.group = group;
    }

    public GuiEditMenuTextEditor(GuiQuestBook gui, EntityPlayer player, GroupTier groupTier) {
        this(gui, player, groupTier.getName(), true);
        this.groupTier = groupTier;
    }

    public GuiEditMenuTextEditor(GuiQuestBook gui, EntityPlayer player, QuestTaskLocation task, int id, QuestTaskLocation.Location location) {
        this(gui, player, location.getName(), true);
        this.task = task;
        this.location = id;
    }

    public GuiEditMenuTextEditor(GuiQuestBook gui, EntityPlayer player, QuestTaskMob task, int id, QuestTaskMob.Mob mob) {
        this(gui, player, mob.getName(), true);
        this.task = task;
        this.mob = id;
    }

    @Override
    public void draw(GuiBase gui, int mX, int mY) {
        super.draw(gui, mX, mY);
        int page = this.text.getCursorLine(gui) / 21;
        gui.drawString(this.text.getLines(), page * 21, 21, 20, 20, 1.0f, 0x404040);
        gui.drawCursor(20 + this.text.getCursorPositionX(gui) - 1, 20 + this.text.getCursorPositionY(gui) - 3 - page * 21 * 9, 10, 1.0f, -7303024);
    }

    @Override
    public void onKeyTyped(GuiBase gui, char c, int k) {
        super.onKeyTyped(gui, c, k);
        this.text.onKeyStroke(gui, c, k);
    }

    @Override
    protected void save(GuiBase gui) {
        if (this.quest != null) {
            if (this.isName) {
                this.quest.setName(this.text.getText());
            } else {
                this.quest.setDescription(this.text.getText());
            }
        } else if (this.task != null) {
            if (this.location != -1) {
                String str = this.text.getText();
                while (gui.getStringWidth(str) > 110) {
                    str = str.substring(0, str.length() - 1);
                }
                ((QuestTaskLocation)this.task).setName(this.location, str, this.player);
            } else if (this.mob != -1) {
                String str = this.text.getText();
                while (gui.getStringWidth(str) > 110) {
                    str = str.substring(0, str.length() - 1);
                }
                ((QuestTaskMob)this.task).setName(this.mob, str, this.player);
            } else if (this.isName) {
                this.task.setDescription(this.text.getText());
            } else {
                this.task.setLongDescription(this.text.getText());
            }
        } else if (this.questSet != null) {
            if (this.isName) {
                this.questSet.setName(this.text.getText());
            } else {
                this.questSet.setDescription(this.text.getText());
            }
        } else if (this.group != null) {
            this.group.setName(this.text.getText());
        } else if (this.groupTier != null) {
            String str = this.text.getText();
            while (gui.getStringWidth(str) > 110) {
                str = str.substring(0, str.length() - 1);
            }
            this.groupTier.setName(str);
        } else {
            Quest.setMainDescription(this.text.getText());
        }
    }
}

