/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting;

import cpw.mods.fml.common.IPlayerTracker;
import hardcorequesting.QuestingData;
import hardcorequesting.network.PacketHandler;
import hardcorequesting.quests.QuestLine;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatMessageComponent;

public class PlayerTracker
implements IPlayerTracker {
    public int lives;

    public int getRemainingLives(ICommandSender sender) {
        this.lives = QuestingData.getQuestingData((EntityPlayer)sender).getLives();
        return this.lives;
    }

    public void onPlayerLogin(EntityPlayer player) {
        if (!QuestingData.hasData(player)) {
            QuestingData.getQuestingData(player).getDeathStat().refreshSync();
        }
        QuestLine.sendServerSync(player);
        if (QuestingData.isHardcoreActive()) {
            this.sendLoginMessage(player);
        } else {
            player.func_70006_a(ChatMessageComponent.func_111066_d((String)"This server doesn't have HQM Mode Enabled."));
        }
        NBTTagCompound tags = player.getEntityData();
        if (tags.func_74764_b("HardcoreQuesting")) {
            if (tags.func_74775_l("HardcoreQuesting").func_74767_n("questBook")) {
                QuestingData.getQuestingData((EntityPlayer)player).receivedBook = true;
            }
            if (QuestingData.isQuestActive()) {
                tags.func_82580_o("HardcoreQuesting");
            }
        }
        QuestingData.spawnBook(player);
    }

    private void sendLoginMessage(EntityPlayer player) {
        player.func_70006_a(ChatMessageComponent.func_111066_d((String)("This server currently has HQM mode enabled! You currently have " + this.getRemainingLives((ICommandSender)player) + " live(s) left.")));
    }

    public void onPlayerLogout(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            PacketHandler.remove(player);
        }
    }

    public void onPlayerChangedDimension(EntityPlayer player) {
    }

    public void onPlayerRespawn(EntityPlayer player) {
    }
}

