/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.netherores.ores;

import appeng.api.IAppEngGrinderRecipe;
import appeng.api.Util;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameRegistry;
import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.Recipes;
import java.lang.reflect.Constructor;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;
import net.minecraftforge.oredict.OreDictionary;
import powercrystals.netherores.NetherOresCore;

public enum Ores {
    Coal(8, 16, 2, 4),
    Diamond(4, 3, 2, 5),
    Gold(8, 6, 2, 4),
    Iron(8, 8, 2, 4),
    Lapis(6, 6, 2, 24),
    Redstone(6, 8, 2, 24),
    Copper(8, 8, 2, 4),
    Tin(8, 8, 2, 4),
    Emerald(3, 2, 2, 5),
    Silver(6, 4, 2, 4),
    Lead(6, 6, 2, 4),
    Uranium(3, 2, 2, 4, "crushed"),
    Nikolite(8, 4, 2, 24),
    Ruby(6, 3, 2, 5),
    Peridot(6, 3, 2, 5),
    Sapphire(6, 3, 2, 5),
    Platinum(1, 3, 2, 4),
    Nickel(4, 6, 2, 4),
    Steel(3, 4, 2, 4),
    Iridium(1, 2, 2, 4, "drop"),
    Osmium(8, 7, 2, 4),
    Sulfur(12, 12, 2, 24),
    Titanium(3, 2, 2, 4),
    Mythril(6, 6, 2, 4),
    Adamantium(5, 4, 2, 4),
    Rutile(3, 4, 2, 4),
    Tungsten(8, 8, 2, 4),
    Amber(5, 6, 2, 5),
    Tennantite(8, 8, 2, 4),
    Salt(5, 5, 2, 12, "food"),
    Saltpeter(6, 4, 2, 10);

    private int _blockIndex;
    private int _metadata;
    private String _secondary;
    private boolean _registeredSmelting;
    private boolean _registeredMacerator;
    private int _oreGenMinY = 1;
    private int _oreGenMaxY = 126;
    private int _oreGenGroupsPerChunk = 6;
    private int _oreGenBlocksPerGroup = 14;
    private boolean _oreGenDisable = false;
    private boolean _oreGenForced = false;
    private int _smeltCount;
    private int _pulvCount;
    private int _miningLevel;

    private Ores(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, "gem");
    }

    private Ores(int n2, int n3, int n4, int n5, String string2) {
        int n6 = this.ordinal();
        this._blockIndex = n6 / 16;
        this._metadata = n6 % 16;
        this._oreGenGroupsPerChunk = n2;
        this._oreGenBlocksPerGroup = n3;
        this._smeltCount = n4;
        this._pulvCount = n5;
        this._miningLevel = 2;
        this._secondary = string2;
    }

    public int getBlockIndex() {
        return this._blockIndex;
    }

    public int getMetadata() {
        return this._metadata;
    }

    public String getOreName() {
        return "ore" + this.name();
    }

    public String getDustName() {
        return "dust" + this.name();
    }

    public String getAltName() {
        return this._secondary + this.name();
    }

    public boolean isRegisteredSmelting() {
        return this._registeredSmelting;
    }

    public boolean isRegisteredMacerator() {
        return this._registeredMacerator;
    }

    public int getMaxY() {
        return this._oreGenMaxY;
    }

    public int getMinY() {
        return this._oreGenMinY;
    }

    public int getGroupsPerChunk() {
        return this._oreGenGroupsPerChunk;
    }

    public int getBlocksPerGroup() {
        return this._oreGenBlocksPerGroup;
    }

    public boolean getDisabled() {
        return this._oreGenDisable;
    }

    public boolean getForced() {
        return this._oreGenForced;
    }

    public int getSmeltCount() {
        return this._smeltCount;
    }

    public int getMaceCount() {
        return this._pulvCount;
    }

    public void load() {
        MinecraftForge.setBlockHarvestLevel((Block)NetherOresCore.getOreBlock(this._blockIndex), (int)this._metadata, (String)"pickaxe", (int)this._miningLevel);
        if (this._oreGenForced | !this._oreGenDisable) {
            ItemStack itemStack = new ItemStack(NetherOresCore.getOreBlock(this._blockIndex), 1, this._metadata);
            OreDictionary.registerOre((String)("oreNether" + this.name()), (ItemStack)itemStack);
        }
    }

    public void registerSmelting(ItemStack itemStack) {
        ItemStack itemStack2;
        if (this._registeredSmelting) {
            return;
        }
        this._registeredSmelting = true;
        if (NetherOresCore.enableStandardFurnaceRecipes.getBoolean(true)) {
            itemStack2 = itemStack.func_77946_l();
            itemStack2.field_77994_a = this._smeltCount;
            FurnaceRecipes.func_77602_a().addSmelting(NetherOresCore.getOreBlock((int)this._blockIndex).field_71990_ca, this._metadata, itemStack2, 1.0f);
        }
        if (NetherOresCore.enableInductionSmelterRecipes.getBoolean(true) && Loader.isModLoaded((String)"ThermalExpansion")) {
            itemStack2 = new ItemStack(NetherOresCore.getOreBlock(this._blockIndex), 1, this._metadata);
            ItemStack itemStack3 = new ItemStack(Block.field_71939_E);
            ItemStack itemStack4 = GameRegistry.findItemStack((String)"ThermalExpansion", (String)"slagRich", (int)1);
            ItemStack itemStack5 = GameRegistry.findItemStack((String)"ThermalExpansion", (String)"slag", (int)1);
            ItemStack itemStack6 = itemStack.func_77946_l();
            itemStack6.field_77994_a = this._smeltCount;
            ItemStack itemStack7 = itemStack.func_77946_l();
            itemStack7.field_77994_a = this._smeltCount + (int)Math.ceil((float)this._smeltCount / 3.0f);
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74768_a("energy", 3200);
            nBTTagCompound.func_74766_a("primaryInput", new NBTTagCompound());
            nBTTagCompound.func_74766_a("secondaryInput", new NBTTagCompound());
            nBTTagCompound.func_74766_a("primaryOutput", new NBTTagCompound());
            nBTTagCompound.func_74766_a("secondaryOutput", new NBTTagCompound());
            itemStack2.func_77955_b(nBTTagCompound.func_74775_l("primaryInput"));
            itemStack3.func_77955_b(nBTTagCompound.func_74775_l("secondaryInput"));
            itemStack6.func_77955_b(nBTTagCompound.func_74775_l("primaryOutput"));
            itemStack4.func_77955_b(nBTTagCompound.func_74775_l("secondaryOutput"));
            nBTTagCompound.func_74768_a("secondaryChance", 10);
            FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"SmelterRecipe", (NBTTagCompound)nBTTagCompound);
            nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74768_a("energy", 4000);
            nBTTagCompound.func_74766_a("primaryInput", new NBTTagCompound());
            nBTTagCompound.func_74766_a("secondaryInput", new NBTTagCompound());
            nBTTagCompound.func_74766_a("primaryOutput", new NBTTagCompound());
            nBTTagCompound.func_74766_a("secondaryOutput", new NBTTagCompound());
            itemStack2.func_77955_b(nBTTagCompound.func_74775_l("primaryInput"));
            itemStack4.func_77955_b(nBTTagCompound.func_74775_l("secondaryInput"));
            itemStack7.func_77955_b(nBTTagCompound.func_74775_l("primaryOutput"));
            itemStack5.func_77955_b(nBTTagCompound.func_74775_l("secondaryOutput"));
            nBTTagCompound.func_74768_a("secondaryChance", 100);
            FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"SmelterRecipe", (NBTTagCompound)nBTTagCompound);
        }
    }

    public void registerMacerator(ItemStack itemStack) {
        block10: {
            ItemStack itemStack2;
            ItemStack itemStack3;
            if (this._registeredMacerator) {
                return;
            }
            this._registeredMacerator = true;
            if (NetherOresCore.enableMaceratorRecipes.getBoolean(true) && Loader.isModLoaded((String)"IC2")) {
                itemStack3 = itemStack.func_77946_l();
                itemStack3.field_77994_a = this._pulvCount;
                itemStack2 = null;
                try {
                    for (Object object : IMachineRecipeManager.class.getDeclaredMethods()) {
                        if (!object.getName().equals("addRecipe")) continue;
                        itemStack2 = object;
                        break;
                    }
                    itemStack2.invoke((Object)Recipes.macerator, new ItemStack(NetherOresCore.getOreBlock(this._blockIndex), 1, this._metadata), itemStack3.func_77946_l());
                }
                catch (Throwable throwable) {
                    try {
                        Object object;
                        Class<?> clazz = Class.forName("ic2.api.recipe.RecipeInputItemStack");
                        Constructor<?> constructor = clazz.getDeclaredConstructor(ItemStack.class);
                        object = constructor.newInstance(new ItemStack(NetherOresCore.getOreBlock(this._blockIndex), 1, this._metadata));
                        itemStack2.invoke((Object)Recipes.macerator, object, null, new ItemStack[]{itemStack3.func_77946_l()});
                    }
                    catch (Throwable throwable2) {
                        throwable2.printStackTrace();
                    }
                }
            }
            if (NetherOresCore.enablePulverizerRecipes.getBoolean(true) && Loader.isModLoaded((String)"ThermalExpansion")) {
                itemStack3 = new ItemStack(NetherOresCore.getOreBlock(this._blockIndex), 1, this._metadata);
                itemStack2 = itemStack.func_77946_l();
                ItemStack itemStack4 = new ItemStack(Block.field_72012_bb);
                itemStack2.field_77994_a = this._pulvCount;
                itemStack4.field_77994_a = 1;
                NBTTagCompound nBTTagCompound = new NBTTagCompound();
                nBTTagCompound.func_74768_a("energy", 3200);
                nBTTagCompound.func_74766_a("input", new NBTTagCompound());
                nBTTagCompound.func_74766_a("primaryOutput", new NBTTagCompound());
                nBTTagCompound.func_74766_a("secondaryOutput", new NBTTagCompound());
                itemStack3.func_77955_b(nBTTagCompound.func_74775_l("input"));
                itemStack2.func_77955_b(nBTTagCompound.func_74775_l("primaryOutput"));
                itemStack4.func_77955_b(nBTTagCompound.func_74775_l("secondaryOutput"));
                nBTTagCompound.func_74768_a("secondaryChance", 15);
                FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"PulverizerRecipe", (NBTTagCompound)nBTTagCompound);
            }
            if (NetherOresCore.enableGrinderRecipes.getBoolean(true) && Loader.isModLoaded((String)"AppliedEnergistics")) {
                itemStack3 = itemStack.func_77946_l();
                itemStack3.field_77994_a = this._pulvCount;
                itemStack2 = Util.getGrinderRecipeManage();
                for (ItemStack itemStack5 : OreDictionary.getOres((String)this.getOreName())) {
                    IAppEngGrinderRecipe iAppEngGrinderRecipe = itemStack2.getRecipeForInput(itemStack5);
                    if (iAppEngGrinderRecipe == null) continue;
                    itemStack2.addRecipe(new ItemStack(NetherOresCore.getOreBlock(this._blockIndex), 1, this._metadata), itemStack3, iAppEngGrinderRecipe.getEnergyCost() * 2);
                    break block10;
                }
                itemStack2.addRecipe(new ItemStack(NetherOresCore.getOreBlock(this._blockIndex), 1, this._metadata), itemStack3, 16);
            }
        }
    }

    public void loadConfig(Configuration configuration) {
        String string = this.getOreName();
        this._oreGenMaxY = Ores.loadLegacy(configuration, "WorldGen", string + ".MaxY", string + "MaxY", this._oreGenMaxY).getInt();
        this._oreGenMinY = Ores.loadLegacy(configuration, "WorldGen", string + ".MinY", string + "MinY", this._oreGenMinY).getInt();
        this._oreGenGroupsPerChunk = Ores.loadLegacy(configuration, "WorldGen", string + ".GroupsPerChunk", string + "GroupsPerChunk", this._oreGenGroupsPerChunk).getInt();
        this._oreGenBlocksPerGroup = Ores.loadLegacy(configuration, "WorldGen", string + ".BlocksPerGroup", string + "BlocksPerGroup", this._oreGenBlocksPerGroup).getInt();
        this._oreGenDisable = Ores.loadLegacy(configuration, "WorldGen", string + ".Disable", string + "Disable", false).getBoolean(false);
        this._oreGenForced = Ores.loadLegacy(configuration, "WorldGen", string + ".Force", string + "Force", false).getBoolean(false);
        this._miningLevel = configuration.get("WorldGen", string + ".MiningLevel", this._miningLevel).getInt();
        this._smeltCount = configuration.get("Smelting", string + ".SmeltedCount", this._smeltCount).getInt();
        this._pulvCount = configuration.get("Smelting", string + ".PulverizedCount", this._pulvCount).getInt();
        if (this._oreGenMinY >= this._oreGenMaxY) {
            this._oreGenMinY = this._oreGenMaxY - 1;
        }
    }

    private static Property loadLegacy(Configuration configuration, String string, String string2, String string3, int n) {
        Property property = null;
        String string4 = null;
        if (configuration.hasKey(string, string3)) {
            property = configuration.get(string, string3, n);
            string4 = property.getString();
            Ores.deleteEntry(configuration, string, string3);
        }
        property = configuration.get(string, string2, n);
        if (string4 != null) {
            property.set(string4);
        }
        return property;
    }

    private static Property loadLegacy(Configuration configuration, String string, String string2, String string3, boolean bl) {
        Property property = null;
        String string4 = null;
        if (configuration.hasKey(string, string3)) {
            property = configuration.get(string, string3, bl);
            string4 = property.getString();
            Ores.deleteEntry(configuration, string, string3);
        }
        property = configuration.get(string, string2, bl);
        if (string4 != null) {
            property.set(string4);
        }
        return property;
    }

    private static void deleteEntry(Configuration configuration, String string, String string2) {
        configuration.getCategory(string).remove((Object)string2);
    }
}

