/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.netherores.ores;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import powercrystals.netherores.NetherOresCore;
import powercrystals.netherores.entity.EntityArmedOre;
import powercrystals.netherores.gui.NOCreativeTab;
import powercrystals.netherores.ores.INetherOre;
import powercrystals.netherores.ores.Ores;

public class BlockNetherOres
extends Block {
    private static int _aggroRange = 32;
    private int _blockIndex = 0;
    private Icon[] _netherOresIcons = new Icon[16];
    private ThreadLocal<Boolean> explode = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };
    private ThreadLocal<Boolean> willAnger = new ThreadLocal();

    public BlockNetherOres(int n, int n2) {
        super(n, Block.field_72012_bb.field_72018_cp);
        this.func_71848_c(5.0f);
        this.func_71894_b(1.0f);
        this.func_71864_b("netherores.ore." + n2);
        this.func_71884_a(field_71976_h);
        this.func_71849_a(NOCreativeTab.tab);
        this._blockIndex = n2;
    }

    public int getBlockIndex() {
        return this._blockIndex;
    }

    public void func_94332_a(IconRegister iconRegister) {
        Ores[] oresArray = Ores.values();
        int n = this._blockIndex * 16;
        int n2 = Math.min(n + 15, oresArray.length - 1) % 16;
        for (int i = 0; i <= n2; ++i) {
            this._netherOresIcons[i] = iconRegister.func_94245_a("netherores:" + oresArray[n + i].name());
        }
    }

    public Icon func_71858_a(int n, int n2) {
        return this._netherOresIcons[n2];
    }

    public int func_71899_b(int n) {
        return n;
    }

    public int func_71925_a(Random random) {
        return 1;
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer entityPlayer, int n, int n2, int n3) {
        boolean bl = entityPlayer == null || !EnchantmentHelper.func_77502_d((EntityLivingBase)entityPlayer);
        this.explode.set(bl);
        this.willAnger.set(true);
        boolean bl2 = super.removeBlockByPlayer(world, entityPlayer, n, n2, n3);
        if (bl || NetherOresCore.silkyStopsPigmen.getBoolean(true)) {
            BlockNetherOres.angerPigmen(entityPlayer, world, n, n2, n3);
        }
        this.willAnger.set(false);
        this.explode.set(true);
        return bl2;
    }

    public void func_71852_a(World world, int n, int n2, int n3, int n4, int n5) {
        Boolean bl;
        if (this.explode.get().booleanValue()) {
            BlockNetherOres.checkExplosionChances(this, world, n, n2, n3);
        }
        if ((bl = this.willAnger.get()) == null || !bl.booleanValue()) {
            BlockNetherOres.angerPigmen(world, n, n2, n3);
        }
        super.func_71852_a(world, n, n2, n3, n4, n5);
    }

    public void onBlockExploded(World world, int n, int n2, int n3, Explosion explosion) {
        this.explode.set(false);
        this.willAnger.set(NetherOresCore.enableMobsAngerPigmen.getBoolean(true) || explosion == null || !(explosion.func_94613_c() instanceof EntityLiving));
        super.onBlockExploded(world, n, n2, n3, explosion);
        this.willAnger.set(true);
        this.explode.set(true);
        if (NetherOresCore.enableExplosionChainReactions.getBoolean(true)) {
            BlockNetherOres.checkExplosionChances(this, world, n, n2, n3);
        }
    }

    public static void checkExplosionChances(Block block, World world, int n, int n2, int n3) {
        if (!world.field_72995_K && NetherOresCore.enableExplosions.getBoolean(true)) {
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        int n4;
                        int n5;
                        int n6;
                        if ((i | j | k) == 0 || !(Block.field_71973_m[world.func_72798_a(n6 = n + i, n5 = n2 + j, n4 = n3 + k)] instanceof INetherOre) || world.field_73012_v.nextInt(1000) >= NetherOresCore.explosionProbability.getInt()) continue;
                        EntityArmedOre entityArmedOre = new EntityArmedOre(world, (double)n6 + 0.5, (double)n5 + 0.5, (double)n4 + 0.5, block);
                        world.func_72838_d((Entity)entityArmedOre);
                        world.func_72908_a((double)n + 0.5, (double)n2 + 0.5, (double)n3 + 0.5, "random.fuse", 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    public static void angerPigmen(EntityPlayer entityPlayer, World world, int n, int n2, int n3) {
        if (NetherOresCore.enableAngryPigmen.getBoolean(true)) {
            List list = world.func_72872_a(EntityPigZombie.class, AxisAlignedBB.func_72330_a((double)(n - _aggroRange), (double)(n2 - _aggroRange), (double)(n3 - _aggroRange), (double)(n + _aggroRange + 1), (double)(n2 + _aggroRange + 1), (double)(n3 + _aggroRange + 1)));
            for (int i = 0; i < list.size(); ++i) {
                ((EntityPigZombie)list.get(i)).func_70835_c((Entity)entityPlayer);
            }
        }
    }

    public static void angerPigmen(World world, int n, int n2, int n3) {
        BlockNetherOres.angerPigmen(null, world, n, n2, n3);
    }
}

