/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.netherores;

import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.oredict.OreDictionary;
import powercrystals.core.mod.BaseMod;
import powercrystals.core.updater.IUpdateableMod;
import powercrystals.core.updater.UpdateManager;
import powercrystals.netherores.entity.EntityArmedOre;
import powercrystals.netherores.entity.EntityHellfish;
import powercrystals.netherores.net.ClientPacketHandler;
import powercrystals.netherores.net.ConnectionHandler;
import powercrystals.netherores.net.INetherOresProxy;
import powercrystals.netherores.net.ServerPacketHandler;
import powercrystals.netherores.ores.BlockNetherOres;
import powercrystals.netherores.ores.BlockNetherOverrideOre;
import powercrystals.netherores.ores.ItemBlockNetherOre;
import powercrystals.netherores.ores.Ores;
import powercrystals.netherores.world.BlockHellfish;
import powercrystals.netherores.world.NetherOresWorldGenHandler;

@Mod(modid="NetherOres", name="Nether Ores", version="1.6.2R2.2.2", dependencies="required-after:PowerCrystalsCore;before:ThermalExpansion")
@NetworkMod(clientSideRequired=true, serverSideRequired=false, clientPacketHandlerSpec=@NetworkMod.SidedPacketHandler(channels={"NetherOres"}, packetHandler=ClientPacketHandler.class), serverPacketHandlerSpec=@NetworkMod.SidedPacketHandler(channels={"NetherOres"}, packetHandler=ServerPacketHandler.class), connectionHandler=ConnectionHandler.class)
public class NetherOresCore
extends BaseMod {
    public static final String modId = "NetherOres";
    public static final String version = "1.6.2R2.2.2";
    public static final String modName = "Nether Ores";
    public static final String mobTextureFolder = "netherores:textures/mob/";
    public static Block[] blockNetherOres = new Block[(Ores.values().length + 15) / 16];
    public static Block blockHellfish;
    private static Property[] netherOreBlockIds;
    private static Property hellfishBlockId;
    public static Property explosionPower;
    public static Property explosionProbability;
    public static Property enableExplosions;
    public static Property enableExplosionChainReactions;
    public static Property enableAngryPigmen;
    public static Property enableHellfish;
    public static Property enableStandardFurnaceRecipes;
    public static Property enableMaceratorRecipes;
    public static Property enablePulverizerRecipes;
    public static Property enableInductionSmelterRecipes;
    public static Property enableGrinderRecipes;
    public static Property forceOreSpawn;
    public static Property worldGenAllDimensions;
    public static Property enableWorldGen;
    public static Property enableHellQuartz;
    public static Property silkyStopsPigmen;
    public static Property hellFishPerChunk;
    public static Property hellFishPerGroup;
    public static Property hellFishMinY;
    public static Property hellFishMaxY;
    public static Property enableMobsAngerPigmen;
    @SidedProxy(clientSide="powercrystals.netherores.net.ClientProxy", serverSide="powercrystals.netherores.net.ServerProxy")
    public static INetherOresProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent fMLPreInitializationEvent) {
        this.setConfigFolderBase(fMLPreInitializationEvent.getModConfigurationDirectory());
        this.loadConfig(this.getCommonConfig());
        this.extractLang(new String[]{"en_US", "es_AR", "es_ES", "es_MX", "es_UY", "es_VE", "de_DE", "ru_RU", "sv_SE"});
        this.loadLang();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent fMLInitializationEvent) {
        int n;
        int n2 = blockNetherOres.length;
        for (n = 0; n < n2; ++n) {
            NetherOresCore.blockNetherOres[n] = new BlockNetherOres(netherOreBlockIds[n].getInt(), n);
            BlockNetherOres blockNetherOres = NetherOresCore.blockNetherOres[n];
            GameRegistry.registerBlock((Block)blockNetherOres, ItemBlockNetherOre.class, (String)blockNetherOres.func_71917_a());
        }
        blockHellfish = new BlockHellfish(hellfishBlockId.getInt());
        GameRegistry.registerBlock((Block)blockHellfish, ItemBlock.class, (String)"netherOresBlockHellfish", (String)"Minecraft");
        GameRegistry.registerWorldGenerator((IWorldGenerator)new NetherOresWorldGenHandler());
        if (enableHellQuartz.getBoolean(true)) {
            Block block;
            n = Block.field_94342_cr.field_71990_ca;
            Block.field_71973_m[n] = null;
            Block.field_94342_cr = block = new BlockNetherOverrideOre(n).func_71848_c(3.0f).func_71894_b(5.0f).func_71884_a(Block.field_71976_h).func_71864_b("netherquartz").func_111022_d("quartz_ore");
        }
        for (Ores ores : Ores.values()) {
            ores.load();
        }
        EntityRegistry.registerModEntity(EntityArmedOre.class, (String)"netherOresArmedOre", (int)0, (Object)((Object)this), (int)80, (int)5, (boolean)false);
        EntityRegistry.registerModEntity(EntityHellfish.class, (String)"netherOresHellfish", (int)1, (Object)((Object)this), (int)160, (int)5, (boolean)true);
        proxy.load();
        TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)new UpdateManager((IUpdateableMod)this), (Side)Side.CLIENT);
    }

    @Mod.EventHandler
    public void postInit(FMLInterModComms.IMCEvent iMCEvent) {
        Ores.Coal.registerSmelting(new ItemStack(Block.field_71950_I));
        Ores.Gold.registerSmelting(new ItemStack(Block.field_71941_G));
        Ores.Iron.registerSmelting(new ItemStack(Block.field_71949_H));
        Ores.Lapis.registerSmelting(new ItemStack(Block.field_71947_N));
        Ores.Diamond.registerSmelting(new ItemStack(Block.field_72073_aw));
        Ores.Emerald.registerSmelting(new ItemStack(Block.field_72068_bR));
        Ores.Redstone.registerSmelting(new ItemStack(Block.field_72047_aN));
        Ores.Coal.registerMacerator(new ItemStack(Item.field_77705_m));
        Ores.Diamond.registerMacerator(new ItemStack(Item.field_77702_n));
        Ores.Emerald.registerMacerator(new ItemStack(Item.field_77817_bH));
        Ores.Redstone.registerMacerator(new ItemStack(Item.field_77767_aC));
        Ores.Lapis.registerMacerator(new ItemStack(Item.field_77756_aW, 1, 4));
        for (Ores ores : Ores.values()) {
            String string = ores.getOreName();
            if (OreDictionary.getOres((String)string).size() > 0) {
                this.registerOreDictSmelt(ores, string, (ItemStack)OreDictionary.getOres((String)string).get(0));
            }
            if (OreDictionary.getOres((String)(string = ores.getDustName())).size() > 0) {
                this.registerOreDictDust(ores, string, (ItemStack)OreDictionary.getOres((String)string).get(0));
            }
            if (OreDictionary.getOres((String)(string = ores.getAltName())).size() <= 0) continue;
            this.registerOreDictGem(ores, string, (ItemStack)OreDictionary.getOres((String)string).get(0));
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static Block getOreBlock(int n) {
        if (n >= 0 && n < blockNetherOres.length) {
            return blockNetherOres[n];
        }
        return null;
    }

    private void loadConfig(File file) {
        int n;
        Configuration configuration = new Configuration(file);
        configuration.load();
        Property property = configuration.get("block", "BaseID", 1440);
        property.comment = "This is the base ID blocks will assign from. Delete the other IDs here to auto-align to this value.";
        int n2 = n = property.getInt(1440);
        NetherOresCore.netherOreBlockIds[0] = configuration.getBlock("block", "ID.NetherOreBlock", n2++);
        hellfishBlockId = configuration.getBlock("block", "ID.HellfishBlock", n2++);
        for (int i = 1; i < netherOreBlockIds.length; ++i) {
            NetherOresCore.netherOreBlockIds[i] = configuration.getBlock("block", "ID.NetherOreBlock" + i, n2++);
        }
        explosionPower = configuration.get("general", "ExplosionPower", 2);
        NetherOresCore.explosionPower.comment = "How powerful an explosion will be. Creepers are 3, TNT is 4, electrified creepers are 6. This affects both the ability of the explosion to punch through blocks as well as the blast radius.";
        explosionProbability = configuration.get("general", "ExplosionProbability", 75);
        NetherOresCore.explosionProbability.comment = "The likelyhood an adjacent netherore will turn into an armed ore when one is mined. Percent chance out of 1000 (lower is less likely).";
        enableExplosions = configuration.get("general", "ExplosionEnable", true);
        NetherOresCore.enableExplosions.comment = "NetherOres have a chance to explode when mined if true.";
        enableExplosionChainReactions = configuration.get("general", "ExplosionChainReactEnable", true);
        NetherOresCore.enableExplosionChainReactions.comment = "NetherOre explosions can trigger more explosions if true. Does nothing if ExplosionEnable is false.";
        enableAngryPigmen = configuration.get("general", "AngryPigmenEnable", true);
        NetherOresCore.enableAngryPigmen.comment = "If true, when NetherOres are mined, nearby pigmen become angry to the player.";
        enableStandardFurnaceRecipes = configuration.get("general", "EnableStandardFurnaceRecipes", true);
        NetherOresCore.enableStandardFurnaceRecipes.comment = "Set this to false to remove the standard furnace recipes (ie, nether iron ore -> normal iron ore).";
        enableMaceratorRecipes = configuration.get("general", "EnableMaceratorRecipes", true);
        NetherOresCore.enableMaceratorRecipes.comment = "Set this to false to remove the IC2 Macerator recipes (ie, nether iron ore -> 4x iron dust).";
        enablePulverizerRecipes = configuration.get("general", "EnablePulverizerRecipes", true);
        NetherOresCore.enablePulverizerRecipes.comment = "Set this to false to remove the TE Pulvierzer recipes (ie, nether iron ore -> 4x iron dust).";
        enableInductionSmelterRecipes = configuration.get("general", "EnableInductionSmelterRecipes", true);
        NetherOresCore.enableInductionSmelterRecipes.comment = "Set this to false to remove the TE Induction Smelter recipes (ie, nether iron ore -> 2x normal iron ore).";
        enableGrinderRecipes = configuration.get("general", "EnableGrinderRecipes", true);
        NetherOresCore.enableGrinderRecipes.comment = "Set this to false to remove the AE Grind Stone recipes (ie, nether iron ore -> 4x iron dust).";
        forceOreSpawn = configuration.get("general", "ForceOreSpawn", false);
        NetherOresCore.forceOreSpawn.comment = "If true, will spawn nether ores regardless of if a furnace or macerator recipe was found. If false, at least one of those two must be found to spawn the ore.";
        enableHellfish = configuration.get("general", "HellfishEnable", true);
        NetherOresCore.enableHellfish.comment = "If true, Hellfish will spawn in the Nether. Note that setting this false will not kill active Hellfish mobs.";
        worldGenAllDimensions = configuration.get("general", "AllDimensionWorldGen", false);
        NetherOresCore.worldGenAllDimensions.comment = "If true, Nether Ores oregen will run in all dimensions instead of just the Nether. It will still require netherrack to place ores.";
        enableWorldGen = configuration.get("general", "EnableOreWorldGen", true);
        NetherOresCore.enableWorldGen.comment = "If true, Nether Ores oregen will run and places ores in the world where appropriate. Only disable this if you intend to use the ores with a custom ore generator.";
        enableHellQuartz = configuration.get("general", "OverrideNetherQuartz", true);
        NetherOresCore.enableHellQuartz.comment = "If true, Nether Quartz ore will be a NetherOre and will follow the same rules as all other NetherOres.";
        silkyStopsPigmen = configuration.get("general", "SilkyAngryPigmenEnable", false);
        NetherOresCore.silkyStopsPigmen.comment = "If true, when NetherOres are mined with Silk Touch, nearby pigmen become angry to the player.";
        enableMobsAngerPigmen = configuration.get("general", "MobsAngerPigmen", true);
        NetherOresCore.enableMobsAngerPigmen.comment = "If true, any entity not a player exploding a NetherOre will anger nearby pigmen.";
        hellFishPerChunk = configuration.get("WorldGen", "HellFish.GroupsPerChunk", 9);
        NetherOresCore.hellFishPerChunk.comment = "The maximum number of hellfish veins per chunk.";
        hellFishPerGroup = configuration.get("WorldGen", "HellFish.BlocksPerGroup", 12);
        NetherOresCore.hellFishPerGroup.comment = "The maximum number of hellfish blocks per vein.";
        hellFishMinY = configuration.get("WorldGen", "HellFish.MinY", 1);
        hellFishMaxY = configuration.get("WorldGen", "HellFish.MaxY", 127);
        for (Ores ores : Ores.values()) {
            ores.loadConfig(configuration);
        }
        configuration.save();
    }

    @ForgeSubscribe
    public void registerOreEvent(OreDictionary.OreRegisterEvent oreRegisterEvent) {
        this.registerOreDictionaryEntry(oreRegisterEvent.Name, oreRegisterEvent.Ore);
    }

    private void registerOreDictionaryEntry(String string, ItemStack itemStack) {
        for (Ores ores : Ores.values()) {
            this.registerOreDictSmelt(ores, string, itemStack);
            this.registerOreDictDust(ores, string, itemStack);
            this.registerOreDictGem(ores, string, itemStack);
        }
    }

    private void registerOreDictSmelt(Ores ores, String string, ItemStack itemStack) {
        if (!ores.isRegisteredSmelting() && ores.getOreName().equals(string)) {
            ores.registerSmelting(itemStack);
        }
    }

    private void registerOreDictDust(Ores ores, String string, ItemStack itemStack) {
        if (!ores.isRegisteredMacerator() && ores.getDustName().equals(string)) {
            ores.registerMacerator(itemStack);
        }
    }

    private void registerOreDictGem(Ores ores, String string, ItemStack itemStack) {
        if (!ores.isRegisteredMacerator() && ores.getAltName().equals(string)) {
            ores.registerMacerator(itemStack);
        }
    }

    public String getModId() {
        return modId;
    }

    public String getModName() {
        return modName;
    }

    public String getModVersion() {
        return version;
    }

    static {
        netherOreBlockIds = new Property[blockNetherOres.length];
    }
}

