/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.util;

import java.nio.charset.Charset;
import java.util.Arrays;

public class DataArrayInputStream {
    private byte[] data;
    private int index;

    public DataArrayInputStream(byte[] data) {
        this.data = data;
        this.index = 0;
    }

    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    public byte readByte() {
        return this.data[this.index++];
    }

    public short readShort() {
        int b0 = this.data[this.index++] & 0xFF;
        int b1 = this.data[this.index++] & 0xFF;
        return (short)(b0 << 8 | b1);
    }

    public int readInt() {
        int b0 = this.data[this.index++] & 0xFF;
        int b1 = this.data[this.index++] & 0xFF;
        int b2 = this.data[this.index++] & 0xFF;
        int b3 = this.data[this.index++] & 0xFF;
        return b0 << 24 | b1 << 16 | b2 << 8 | b3;
    }

    public long readLong() {
        long i0 = (long)this.readInt() & 0xFFFFFFFFL;
        long i1 = (long)this.readInt() & 0xFFFFFFFFL;
        return i0 << 32 | i1;
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readUTF() {
        int size = this.readInt();
        String result = new String(this.data, this.index, size, Charset.forName("UTF-8"));
        this.index += size;
        return result;
    }

    public byte[] readBytes(int size) {
        byte[] result = Arrays.copyOfRange(this.data, this.index, this.index + size);
        this.index += size;
        return result;
    }

    public byte[] readByteArray() {
        int size = this.readInt();
        return this.readBytes(size);
    }
}

