/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.script.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import stanhebben.minetweaker.script.parser.CompiledDFA;
import stanhebben.minetweaker.script.parser.ParseException;
import stanhebben.minetweaker.script.parser.Token;
import stanhebben.minetweaker.script.parser.TokenException;

public class TokenStream
implements Iterator<Token> {
    private final String file;
    private CountingReader reader;
    private CompiledDFA dfa;
    private Token next;
    private int nextChar;
    private int line;
    private int lineOffset;
    private int tokenMemoryOffset;
    private LinkedList<Token> tokenMemory;
    private Stack<Integer> marks;
    private int tokenMemoryCurrent;

    public TokenStream(String filename, Reader reader, CompiledDFA dfa) throws IOException {
        this.file = filename;
        this.tokenMemoryOffset = 0;
        this.tokenMemoryCurrent = 0;
        this.tokenMemory = new LinkedList();
        this.marks = new Stack();
        this.reader = new CountingReader(reader);
        this.dfa = dfa;
        this.nextChar = this.reader.read();
        this.line = 1;
        this.lineOffset = 1;
        this.advance();
    }

    public TokenStream(String filename, String data, CompiledDFA dfa) throws IOException {
        this(filename, new StringReader(data), dfa);
    }

    public Token peek() {
        if (this.tokenMemoryCurrent < this.tokenMemoryOffset + this.tokenMemory.size()) {
            return this.tokenMemory.get(this.tokenMemoryCurrent - this.tokenMemoryOffset);
        }
        return this.next;
    }

    public boolean isNext(int type) {
        return this.peek().getType() == type;
    }

    public Token optional(int type) {
        if (this.peek() != null && this.peek().getType() == type) {
            return this.next();
        }
        return null;
    }

    public Token required(int type, String error) {
        Token t = this.peek();
        if (t != null && t.getType() == type) {
            return this.next();
        }
        throw new ParseException(t, error);
    }

    public void pushMark() {
        this.marks.push(this.tokenMemoryCurrent);
    }

    public void popMark() {
        this.marks.pop();
        if (this.marks.isEmpty()) {
            this.tokenMemoryOffset = this.tokenMemoryCurrent;
            this.tokenMemory.clear();
        }
    }

    public void reset() {
        this.tokenMemoryCurrent = this.marks.pop();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Token next() {
        if (this.tokenMemoryCurrent < this.tokenMemoryOffset + this.tokenMemory.size()) {
            return this.tokenMemory.get(this.tokenMemoryCurrent++ - this.tokenMemoryOffset);
        }
        Token result = this.next;
        if (this.marks.isEmpty()) {
            ++this.tokenMemoryOffset;
        } else {
            this.tokenMemory.add(result);
        }
        ++this.tokenMemoryCurrent;
        this.advance();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported.");
    }

    protected Token process(Token token) {
        return token;
    }

    private void advance() {
        do {
            this.advanceToken();
        } while (this.next != null && this.next.getType() < 0);
    }

    private void advanceToken() {
        if (this.nextChar < 0) {
            this.next = null;
            return;
        }
        try {
            int state = 0;
            StringBuilder value = new StringBuilder();
            int tLine = this.line;
            int tLineOffset = this.lineOffset;
            while (this.dfa.transitions[state].containsKey(this.nextChar)) {
                value.append((char)this.nextChar);
                state = this.dfa.transitions[state].get(this.nextChar);
                this.line = this.reader.line;
                this.lineOffset = this.reader.lineOffset;
                this.nextChar = this.reader.read();
            }
            if (this.dfa.finals[state] != Integer.MIN_VALUE) {
                if (state == 0) {
                    throw new TokenException(this.line, this.lineOffset, (char)this.nextChar);
                }
            } else {
                throw new TokenException(this.line, this.lineOffset, (char)this.nextChar);
            }
            this.next = this.process(new Token(value.toString(), this.dfa.finals[state], this.file, tLine, tLineOffset));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private class CountingReader {
        private int line;
        private int lineOffset;
        private Reader reader;
        private boolean eof;

        public CountingReader(Reader reader) {
            this.reader = reader;
            this.line = 1;
            this.lineOffset = 1;
        }

        public int read() throws IOException {
            int ch2 = this.reader.read();
            if (ch2 == -1) {
                this.eof = true;
                return ch2;
            }
            if (ch2 == 10) {
                ++this.line;
                this.lineOffset = 1;
            } else {
                ++this.lineOffset;
            }
            return ch2;
        }
    }
}

