/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.oredict;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.minecraftforge.oredict.OreDictionary;
import stanhebben.minetweaker.api.value.TweakerItem;
import stanhebben.minetweaker.oredict.OreEntryListener;

public class TweakerOreEntry {
    private List<OreEntryListener> listeners = null;
    private String name;

    public TweakerOreEntry(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addItem(TweakerItem item) {
        OreDictionary.registerOre((String)this.name, (ye)item.make(1));
        if (this.listeners != null) {
            for (OreEntryListener listener : this.listeners) {
                listener.itemAdded(this, item);
            }
        }
    }

    public void addWildcard(int id) {
        OreDictionary.registerOre((String)this.name, (ye)new ye(id, 1, Short.MAX_VALUE));
        if (this.listeners != null) {
            for (OreEntryListener listener : this.listeners) {
                listener.itemWildcardAdded(this, id);
            }
        }
    }

    public void removeItem(TweakerItem item) {
        OreDictionary.getOres((String)this.name).remove(item.make(1));
        if (this.listeners != null) {
            for (OreEntryListener listener : this.listeners) {
                listener.itemRemoved(this, item);
            }
        }
    }

    public void removeWildcard(int id) {
        OreDictionary.registerOre((String)this.name, (ye)new ye(id, 1, Short.MAX_VALUE));
        if (this.listeners != null) {
            for (OreEntryListener listener : this.listeners) {
                listener.itemWildcardRemoved(this, id);
            }
        }
    }

    public List<TweakerItem> getItems() {
        return new WrappingList(OreDictionary.getOres((String)this.name));
    }

    public void addListener(OreEntryListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<OreEntryListener>();
        }
        this.listeners.add(listener);
    }

    public void removeListener(OreEntryListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    private class WrappingList
    implements List<TweakerItem> {
        private List<ye> original;

        private WrappingList(List<ye> original) {
            this.original = original;
        }

        @Override
        public int size() {
            return this.original.size();
        }

        @Override
        public boolean isEmpty() {
            return this.original.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof TweakerItem)) {
                return false;
            }
            return this.original.contains(((TweakerItem)o).make(1));
        }

        @Override
        public Iterator<TweakerItem> iterator() {
            return new Iterator<TweakerItem>(){
                private Iterator<ye> baseIterator;
                {
                    this.baseIterator = WrappingList.this.original.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.baseIterator.hasNext();
                }

                @Override
                public TweakerItem next() {
                    return TweakerItem.get(this.baseIterator.next());
                }

                @Override
                public void remove() {
                    this.baseIterator.remove();
                }
            };
        }

        @Override
        public Object[] toArray() {
            Object[] result = new TweakerItem[this.original.size()];
            int i = 0;
            Iterator<ye> iter = this.original.iterator();
            while (iter.hasNext()) {
                result[i++] = TweakerItem.get(iter.next());
            }
            return result;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            TweakerItem[] result = new TweakerItem[this.original.size()];
            int i = 0;
            Iterator<ye> iter = this.original.iterator();
            while (iter.hasNext()) {
                result[i++] = TweakerItem.get(iter.next());
            }
            return result;
        }

        @Override
        public boolean add(TweakerItem e) {
            return this.original.add(e.make(1));
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof TweakerItem)) {
                return false;
            }
            return this.original.remove(((TweakerItem)o).make(1));
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends TweakerItem> c) {
            boolean result = false;
            for (TweakerItem tweakerItem : c) {
                result |= this.original.add(tweakerItem.make(1));
            }
            return result;
        }

        @Override
        public boolean addAll(int index, Collection<? extends TweakerItem> c) {
            for (TweakerItem tweakerItem : c) {
                this.original.add(index++, tweakerItem.make(1));
            }
            return !c.isEmpty();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean result = false;
            for (Object o : c) {
                result |= this.remove(o);
            }
            return result;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void clear() {
            this.original.clear();
        }

        @Override
        public TweakerItem get(int index) {
            return TweakerItem.get(this.original.get(index));
        }

        @Override
        public TweakerItem set(int index, TweakerItem element) {
            return TweakerItem.get(this.original.set(index, element.make(1)));
        }

        @Override
        public void add(int index, TweakerItem element) {
            this.original.add(index, element.make(1));
        }

        @Override
        public TweakerItem remove(int index) {
            return TweakerItem.get(this.original.remove(index));
        }

        @Override
        public int indexOf(Object o) {
            if (!(o instanceof TweakerItem)) {
                return -1;
            }
            return this.original.indexOf(((TweakerItem)o).make(1));
        }

        @Override
        public int lastIndexOf(Object o) {
            if (!(o instanceof TweakerItem)) {
                return -1;
            }
            return this.original.lastIndexOf(((TweakerItem)o).make(1));
        }

        @Override
        public ListIterator<TweakerItem> listIterator() {
            return new ListIterator<TweakerItem>(){
                ListIterator<ye> originalIter;
                {
                    this.originalIter = WrappingList.this.original.listIterator();
                }

                @Override
                public boolean hasNext() {
                    return this.originalIter.hasNext();
                }

                @Override
                public TweakerItem next() {
                    return TweakerItem.get(this.originalIter.next());
                }

                @Override
                public boolean hasPrevious() {
                    return this.originalIter.hasPrevious();
                }

                @Override
                public TweakerItem previous() {
                    return TweakerItem.get(this.originalIter.previous());
                }

                @Override
                public int nextIndex() {
                    return this.originalIter.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return this.originalIter.previousIndex();
                }

                @Override
                public void remove() {
                    this.originalIter.remove();
                }

                @Override
                public void set(TweakerItem e) {
                    this.originalIter.set(e.make(1));
                }

                @Override
                public void add(TweakerItem e) {
                    this.originalIter.add(e.make(1));
                }
            };
        }

        @Override
        public ListIterator<TweakerItem> listIterator(final int index) {
            return new ListIterator<TweakerItem>(){
                ListIterator<ye> originalIter;
                {
                    this.originalIter = WrappingList.this.original.listIterator(index);
                }

                @Override
                public boolean hasNext() {
                    return this.originalIter.hasNext();
                }

                @Override
                public TweakerItem next() {
                    return TweakerItem.get(this.originalIter.next());
                }

                @Override
                public boolean hasPrevious() {
                    return this.originalIter.hasPrevious();
                }

                @Override
                public TweakerItem previous() {
                    return TweakerItem.get(this.originalIter.previous());
                }

                @Override
                public int nextIndex() {
                    return this.originalIter.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return this.originalIter.previousIndex();
                }

                @Override
                public void remove() {
                    this.originalIter.remove();
                }

                @Override
                public void set(TweakerItem e) {
                    this.originalIter.set(e.make(1));
                }

                @Override
                public void add(TweakerItem e) {
                    this.originalIter.add(e.make(1));
                }
            };
        }

        @Override
        public List<TweakerItem> subList(int fromIndex, int toIndex) {
            return new WrappingList(this.original.subList(fromIndex, toIndex));
        }
    }
}

