/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.mfr.action;

import powercrystals.minefactoryreloaded.api.FactoryRegistry;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.mods.mfr.MFRHacks;

public class SafariNetAddBlacklistAction
implements IUndoableAction {
    private final Class<?> entityClass;
    private final boolean existed;

    public SafariNetAddBlacklistAction(Class<?> entityClass) {
        this.entityClass = entityClass;
        this.existed = MFRHacks.safariNetBlacklist == null ? false : MFRHacks.safariNetBlacklist.contains(entityClass);
    }

    @Override
    public void apply() {
        if (!this.existed) {
            FactoryRegistry.registerSafariNetBlacklist(this.entityClass);
        }
    }

    @Override
    public boolean canUndo() {
        return MFRHacks.safariNetBlacklist != null;
    }

    @Override
    public void undo() {
        if (!this.existed) {
            MFRHacks.safariNetBlacklist.remove(this.entityClass);
        }
    }

    @Override
    public String describe() {
        return "Blacklisting " + this.entityClass.getCanonicalName() + " on the safari net";
    }

    @Override
    public String describeUndo() {
        return "Unblacklisting " + this.entityClass.getCanonicalName() + " on the safari net";
    }
}

