/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.mfr.action;

import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.mods.mfr.MFRHacks;

public class AutoSpawnerRemoveBlacklistAction
implements IUndoableAction {
    private final Class<?> entityClass;
    private final boolean existed;

    public AutoSpawnerRemoveBlacklistAction(Class<?> entityClass) {
        this.entityClass = entityClass;
        this.existed = MFRHacks.autoSpawnerBlacklist.contains(entityClass);
    }

    @Override
    public void apply() {
        if (this.existed) {
            MFRHacks.autoSpawnerBlacklist.remove(this.entityClass);
        }
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        if (this.existed) {
            MFRHacks.autoSpawnerBlacklist.add(this.entityClass);
        }
    }

    @Override
    public String describe() {
        return "Removing auto-spawner blacklist " + this.entityClass.getCanonicalName();
    }

    @Override
    public String describeUndo() {
        return "Restoring auto-spawner blacklist " + this.entityClass.getCanonicalName();
    }
}

