/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.ic2.functions;

import ic2.api.recipe.Recipes;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.TweakerNameSpace;
import stanhebben.minetweaker.api.value.TweakerArray;
import stanhebben.minetweaker.api.value.TweakerFunction;
import stanhebben.minetweaker.api.value.TweakerItemStackPattern;
import stanhebben.minetweaker.api.value.TweakerValue;
import stanhebben.minetweaker.mods.ic2.StackPatternRecipeInput;
import stanhebben.minetweaker.mods.ic2.actions.MachineAddRecipeAction;

public class OreWashingAddRecipeFunction
extends TweakerFunction {
    public static final OreWashingAddRecipeFunction INSTANCE = new OreWashingAddRecipeFunction();

    private OreWashingAddRecipeFunction() {
    }

    @Override
    public TweakerValue call(TweakerNameSpace namespace, TweakerValue ... arguments) {
        if (arguments.length < 2 || arguments.length > 3) {
            throw new TweakerExecuteException("adding an ore washing plant recipe requires 2-3 arguments");
        }
        TweakerItemStackPattern input = OreWashingAddRecipeFunction.notNull(arguments[1], "input argument cannot be null").toItemStackPattern("input argument must be an item stack pattern");
        TweakerValue output = OreWashingAddRecipeFunction.notNull(arguments[0], "output argument cannot be null");
        int amount = arguments.length < 3 || arguments[2] == null ? 1000 : arguments[2].toInt("amount must be an int").get();
        by nbt = new by();
        nbt.a("amount", amount);
        if (output.asArray() != null) {
            TweakerArray outputTA = output.asArray();
            ye[] outputArray = new ye[outputTA.size()];
            for (int i = 0; i < outputTA.size(); ++i) {
                outputArray[i] = OreWashingAddRecipeFunction.notNull(outputTA.get(i), "output value cannot be null").toItemStack("output values must be item stacks").get();
            }
            Tweaker.apply(new MachineAddRecipeAction(Recipes.oreWashing, "ore washing plant", new StackPatternRecipeInput(input), nbt, outputArray));
        } else if (output.asItemStack() != null) {
            Tweaker.apply(new MachineAddRecipeAction(Recipes.oreWashing, "ore washing plant", new StackPatternRecipeInput(input), nbt, output.asItemStack().get()));
        } else {
            throw new TweakerExecuteException("machine output must be either an item stack, or an array of item stacks");
        }
        return null;
    }

    @Override
    public String toString() {
        return "oreWashingPlant.addRecipe";
    }
}

