/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.forestry.actions;

import forestry.api.fuels.FuelManager;
import forestry.api.fuels.RainSubstrate;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.value.TweakerItem;

public class RainmakerAddItemAction
implements IUndoableAction {
    private final RainSubstrate substrate;

    public RainmakerAddItemAction(TweakerItem item, int duration, float speed, boolean reverse) {
        this.substrate = new RainSubstrate(item.make(1), duration, speed, reverse);
    }

    @Override
    public void apply() {
        FuelManager.rainSubstrate.put(this.substrate.item, this.substrate);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        FuelManager.rainSubstrate.remove(this.substrate.item);
    }

    @Override
    public String describe() {
        return this.substrate.reverse ? "Adding rain stopping item " + this.substrate.item.s() + " to the rainmaker" : "Adding rain making item " + this.substrate.item.s() + " to the rainmaker";
    }

    @Override
    public String describeUndo() {
        return this.substrate.reverse ? "Removing rain stopping item " + this.substrate.item.s() + " to the rainmaker" : "Removing rain making item " + this.substrate.item.s() + " to the rainmaker";
    }
}

