/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.forestry.actions;

import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import java.util.logging.Level;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.Tweaker;

public class FermenterRemoveFuelAction
implements IUndoableAction {
    private final ye item;
    private FermenterFuel fuel = null;
    private boolean asItem = false;

    public FermenterRemoveFuelAction(ye item) {
        this.item = item;
    }

    @Override
    public void apply() {
        if (FuelManager.fermenterFuel.containsKey(this.item)) {
            this.fuel = (FermenterFuel)FuelManager.fermenterFuel.remove(this.item);
            this.asItem = false;
        } else if (FuelManager.fermenterFuel.containsKey(this.item.b())) {
            this.fuel = (FermenterFuel)FuelManager.fermenterFuel.remove(this.item.b());
            this.asItem = true;
            this.fuel = (FermenterFuel)FuelManager.fermenterFuel.remove(this.item);
        } else {
            Tweaker.log(Level.WARNING, "Could not find " + this.item.s() + " as fermenter fuel");
        }
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        if (this.fuel != null) {
            if (this.asItem) {
                FuelManager.fermenterFuel.put(this.item.b(), this.fuel);
            } else {
                FuelManager.fermenterFuel.put(this.item, this.fuel);
            }
        }
    }

    @Override
    public String describe() {
        return "Removing fermenter fuel " + this.item.s();
    }

    @Override
    public String describeUndo() {
        return "Restoring fermenter fuel " + this.item.s();
    }
}

