/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.forestry.actions;

import forestry.api.recipes.RecipeManagers;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.value.TweakerItem;
import stanhebben.minetweaker.api.value.TweakerLiquid;
import stanhebben.minetweaker.api.value.TweakerLiquidStack;

public class FermenterAddRecipeAction
implements IUndoableAction {
    private final TweakerLiquid output;
    private final float modifier;
    private final int fermentationValue;
    private final TweakerItem input;
    private final TweakerLiquidStack inputLiquid;

    public FermenterAddRecipeAction(TweakerLiquid output, TweakerItem input, int fermentationValue, float modifier, TweakerLiquidStack inputLiquid) {
        this.output = output;
        this.input = input;
        this.modifier = modifier;
        this.fermentationValue = fermentationValue;
        this.inputLiquid = inputLiquid;
    }

    @Override
    public void apply() {
        if (this.inputLiquid == null) {
            RecipeManagers.fermenterManager.addRecipe(this.input.make(1), this.fermentationValue, this.modifier, this.output.make(1));
        } else {
            RecipeManagers.fermenterManager.addRecipe(this.input.make(1), this.fermentationValue, this.modifier, this.output.make(1), this.inputLiquid.get());
        }
    }

    @Override
    public boolean canUndo() {
        return false;
    }

    @Override
    public void undo() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String describe() {
        return "Adding a fermenter recipe for " + this.output.getDisplayName();
    }

    @Override
    public String describeUndo() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

