/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.forestry.actions;

import forestry.api.fuels.EngineCopperFuel;
import forestry.api.fuels.FuelManager;
import java.util.logging.Level;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.value.TweakerItem;

public class CopperEngineRemoveFuelAction
implements IUndoableAction {
    private final ye item;
    private boolean asItem;
    private EngineCopperFuel fuel;

    public CopperEngineRemoveFuelAction(TweakerItem item) {
        this.item = item.make(1);
    }

    @Override
    public void apply() {
        if (FuelManager.copperEngineFuel.containsKey(this.item)) {
            this.asItem = false;
            this.fuel = (EngineCopperFuel)FuelManager.copperEngineFuel.remove(this.item);
        } else if (FuelManager.copperEngineFuel.containsKey(this.item.b())) {
            this.asItem = true;
            this.fuel = (EngineCopperFuel)FuelManager.copperEngineFuel.remove(this.item.b());
        } else {
            Tweaker.log(Level.WARNING, "Did not found peat-fired engine fuel " + this.item.s());
        }
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        if (this.fuel != null) {
            if (this.asItem) {
                FuelManager.copperEngineFuel.put(this.item.b(), this.fuel);
            } else {
                FuelManager.copperEngineFuel.put(this.item, this.fuel);
            }
        }
    }

    @Override
    public String describe() {
        return "Removing peat-fired engine fuel " + this.item.s();
    }

    @Override
    public String describeUndo() {
        return "Restoring peat-fired engine fuel " + this.item.s();
    }
}

