/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.buildcraft.values;

import buildcraft.api.fuels.IronEngineFuel;
import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.value.TweakerField;
import stanhebben.minetweaker.api.value.TweakerLiquid;
import stanhebben.minetweaker.api.value.TweakerString;
import stanhebben.minetweaker.api.value.TweakerValue;
import stanhebben.minetweaker.mods.buildcraft.functions.AddFuelFunction;
import stanhebben.minetweaker.mods.buildcraft.functions.ContainsFuelFunction;
import stanhebben.minetweaker.mods.buildcraft.functions.RemoveFuelFunction;
import stanhebben.minetweaker.mods.buildcraft.values.FuelValue;

public class FuelsValue
extends TweakerValue {
    public static final FuelsValue INSTANCE = new FuelsValue();

    private FuelsValue() {
    }

    @Override
    public TweakerValue index(TweakerValue index) {
        if (index.getClass() == TweakerString.class) {
            return this.index(index.toBasicString());
        }
        if (index.asFluid() != null) {
            TweakerLiquid fluid = index.asFluid();
            if (!IronEngineFuel.fuels.containsKey(fluid.get().getName())) {
                throw new TweakerExecuteException("No such fuel: " + fluid.get().getLocalizedName());
            }
            return new FuelValue((IronEngineFuel.Fuel)IronEngineFuel.fuels.get(fluid.get().getName()));
        }
        return super.index(index);
    }

    @Override
    public TweakerValue index(String index) {
        switch (TweakerField.get(index)) {
            case ADD: {
                return AddFuelFunction.INSTANCE;
            }
            case REMOVE: {
                return RemoveFuelFunction.INSTANCE;
            }
            case CONTAINS: {
                return ContainsFuelFunction.INSTANCE;
            }
        }
        throw new TweakerExecuteException("No such member in buildcraft.fuels: " + index);
    }

    @Override
    public String toString() {
        return "buildcraft.fuels";
    }
}

