/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.buildcraft.values;

import buildcraft.api.fuels.IronEngineFuel;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.value.TweakerField;
import stanhebben.minetweaker.api.value.TweakerFloat;
import stanhebben.minetweaker.api.value.TweakerInt;
import stanhebben.minetweaker.api.value.TweakerLiquid;
import stanhebben.minetweaker.api.value.TweakerValue;
import stanhebben.minetweaker.mods.buildcraft.actions.SetFuelAction;

public class FuelValue
extends TweakerValue {
    private IronEngineFuel.Fuel fuel;

    public FuelValue(IronEngineFuel.Fuel fuel) {
        this.fuel = fuel;
    }

    @Override
    public TweakerValue index(String index) {
        switch (TweakerField.get(index)) {
            case LIQUID: {
                return new TweakerLiquid(this.fuel.liquid);
            }
            case POWERPERCYCLE: {
                return new TweakerFloat(this.fuel.powerPerCycle);
            }
            case TOTALBURNINGTIME: {
                return new TweakerInt(this.fuel.totalBurningTime);
            }
        }
        throw new TweakerExecuteException("Fuel has no " + index + " field");
    }

    @Override
    public void indexSet(String index, TweakerValue value) {
        switch (TweakerField.get(index)) {
            case POWERPERCYCLE: {
                float powerPerCycle = FuelValue.notNull(value, "power per cycle cannot be set to null").toFloat("power per cycle must be a float value").get();
                Tweaker.apply(new SetFuelAction(this.fuel.liquid, powerPerCycle, this.fuel.totalBurningTime));
                return;
            }
            case TOTALBURNINGTIME: {
                int totalBurningTime = FuelValue.notNull(value, "total burning time cannot be set to null").toInt("total burning time must be an int value").get();
                Tweaker.apply(new SetFuelAction(this.fuel.liquid, this.fuel.powerPerCycle, totalBurningTime));
                return;
            }
        }
        throw new TweakerExecuteException("No such settable member in fuel: " + index);
    }

    @Override
    public String toString() {
        return "fuel:" + this.fuel.liquid.getName();
    }
}

