/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.buildcraft.functions;

import buildcraft.api.core.StackWrapper;
import buildcraft.api.fuels.IronEngineCoolant;
import net.minecraftforge.fluids.Fluid;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.TweakerNameSpace;
import stanhebben.minetweaker.api.value.TweakerFunction;
import stanhebben.minetweaker.api.value.TweakerValue;
import stanhebben.minetweaker.mods.buildcraft.actions.RemoveLiquidCoolantAction;
import stanhebben.minetweaker.mods.buildcraft.actions.RemoveSolidCoolantAction;

public class RemoveCoolantFunction
extends TweakerFunction {
    public static final RemoveCoolantFunction INSTANCE = new RemoveCoolantFunction();

    private RemoveCoolantFunction() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TweakerValue call(TweakerNameSpace namespace, TweakerValue ... arguments) {
        if (arguments.length == 0) {
            throw new TweakerExecuteException("coolants.remove requires one argument");
        }
        TweakerValue coolant = RemoveCoolantFunction.notNull(arguments[0], "coolants.remove argument cannot be null");
        if (coolant.asFluid() != null) {
            Fluid coolantFluid = coolant.asFluid().get();
            if (!IronEngineCoolant.liquidCoolants.containsKey(coolantFluid.getName())) throw new TweakerExecuteException("this coolant does not exist: " + coolantFluid.getName());
            Tweaker.apply(new RemoveLiquidCoolantAction(coolantFluid));
            return null;
        } else {
            if (coolant.asItem() == null) throw new TweakerExecuteException("coolants.remove argument must be a fluid or item");
            StackWrapper coolantItem = new StackWrapper(coolant.asItem().make(1));
            if (!IronEngineCoolant.solidCoolants.containsKey(coolantItem)) throw new TweakerExecuteException("this coolant does not exist: " + coolantItem.stack.s());
            Tweaker.apply(new RemoveSolidCoolantAction(coolantItem));
        }
        return null;
    }

    @Override
    public String toString() {
        return "buildcraft.coolants.remove";
    }
}

