/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.buildcraft.actions;

import buildcraft.api.fuels.IronEngineCoolant;
import net.minecraftforge.fluids.Fluid;
import stanhebben.minetweaker.api.IUndoableAction;

public class RemoveLiquidCoolantAction
implements IUndoableAction {
    private final Fluid fluid;
    private final IronEngineCoolant.Coolant coolant;

    public RemoveLiquidCoolantAction(Fluid fluid) {
        this.fluid = fluid;
        this.coolant = (IronEngineCoolant.Coolant)IronEngineCoolant.liquidCoolants.get(fluid.getName());
    }

    @Override
    public void apply() {
        IronEngineCoolant.liquidCoolants.remove(this.fluid.getName());
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        IronEngineCoolant.liquidCoolants.put(this.fluid.getName(), this.coolant);
    }

    @Override
    public String describe() {
        return "Removing coolant liquid " + this.fluid.getName();
    }

    @Override
    public String describeUndo() {
        return "Restoring coolant liquid " + this.fluid.getName();
    }
}

