/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.buildcraft.actions;

import buildcraft.api.fuels.IronEngineFuel;
import net.minecraftforge.fluids.Fluid;
import stanhebben.minetweaker.api.IUndoableAction;

public class RemoveFuelAction
implements IUndoableAction {
    private final Fluid fluid;
    private final IronEngineFuel.Fuel fuel;

    public RemoveFuelAction(Fluid fluid) {
        this.fluid = fluid;
        this.fuel = IronEngineFuel.getFuelForFluid((Fluid)fluid);
    }

    @Override
    public void apply() {
        IronEngineFuel.fuels.remove(this.fluid.getName());
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        IronEngineFuel.fuels.put(this.fluid.getName(), this.fuel);
    }

    @Override
    public String describe() {
        return "Removing fuel " + this.fluid.getName();
    }

    @Override
    public String describeUndo() {
        return "Restoring fuel " + this.fluid.getName();
    }
}

