/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.buildcraft.actions;

import buildcraft.api.recipes.RefineryRecipes;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.value.TweakerLiquidStack;
import stanhebben.minetweaker.mods.buildcraft.BuildCraftUtil;

public class RefineryAddRecipeAction
implements IUndoableAction {
    private final TweakerLiquidStack output;
    private final int energy;
    private final int delay;
    private final TweakerLiquidStack input1;
    private final TweakerLiquidStack input2;

    public RefineryAddRecipeAction(TweakerLiquidStack output, int energy, int delay, TweakerLiquidStack input1, TweakerLiquidStack input2) {
        this.output = output;
        this.energy = energy;
        this.delay = delay;
        this.input1 = input1;
        this.input2 = input2;
    }

    @Override
    public void apply() {
        RefineryRecipes.addRecipe((FluidStack)this.input1.get(), (FluidStack)(this.input2 == null ? null : this.input2.get()), (FluidStack)this.output.get(), (int)this.energy, (int)this.delay);
    }

    @Override
    public boolean canUndo() {
        return BuildCraftUtil.getRefineryRecipes() != null;
    }

    @Override
    public void undo() {
        BuildCraftUtil.getRefineryRecipes().remove(BuildCraftUtil.getRefineryRecipes().last());
    }

    @Override
    public String describe() {
        return "Adding a refinery recipe for " + this.output.getDisplayName();
    }

    @Override
    public String describeUndo() {
        return "Removing a refinery recipe for " + this.output.getDisplayName();
    }
}

