/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.base.values;

import java.util.ArrayList;
import java.util.Iterator;
import net.minecraftforge.oredict.OreDictionary;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.value.TweakerArray;
import stanhebben.minetweaker.api.value.TweakerInt;
import stanhebben.minetweaker.api.value.TweakerItemPattern;
import stanhebben.minetweaker.api.value.TweakerItemSimple;
import stanhebben.minetweaker.api.value.TweakerItemSub;
import stanhebben.minetweaker.api.value.TweakerValue;
import stanhebben.minetweaker.base.actions.AddOreItemAction;
import stanhebben.minetweaker.base.actions.RemoveOreItemAction;

public class OreItemsValue
extends TweakerArray {
    private String ore;
    ArrayList<ye> ores;

    public OreItemsValue(String value) {
        this.ore = value;
        this.ores = OreDictionary.getOres((String)value);
    }

    @Override
    public int size() {
        return this.ores.size();
    }

    @Override
    public TweakerValue get(int index) throws TweakerExecuteException {
        if (index >= this.ores.size()) {
            throw new TweakerExecuteException("index out of bounds for ore list: " + index);
        }
        ye value = this.ores.get(index);
        if (value.h() && value.k() != Short.MAX_VALUE) {
            return new TweakerItemSub(value.d, value.k());
        }
        return new TweakerItemSimple(value.d);
    }

    @Override
    public TweakerValue remove(int index) throws TweakerExecuteException {
        TweakerValue result = this.get(index);
        Tweaker.apply(new RemoveOreItemAction(this.ore, index));
        return result;
    }

    @Override
    public TweakerValue addAssign(TweakerValue value) throws TweakerExecuteException {
        Tweaker.apply(new AddOreItemAction(this.ore, OreItemsValue.notNull(value, "cannot add null to the ore items list").toItem("can only add items to the ore items list").make(1)));
        return this;
    }

    @Override
    public TweakerValue subAssign(TweakerValue value) throws TweakerExecuteException {
        TweakerItemPattern pattern = OreItemsValue.notNull(value, "cannot remove null values").toItemPattern("can only remove items and item patterns from the ore list");
        int numRemoved = 0;
        for (int i = this.ores.size() - 1; i >= 0; --i) {
            if (!pattern.matches(this.ores.get(i))) continue;
            Tweaker.apply(new RemoveOreItemAction(this.ore, i));
            ++numRemoved;
        }
        return new TweakerInt(numRemoved);
    }

    @Override
    public Iterator<TweakerValue> iterator() {
        return new Iterator<TweakerValue>(){
            private Iterator<ye> base;
            {
                this.base = OreItemsValue.this.ores.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.base.hasNext();
            }

            @Override
            public TweakerValue next() {
                try {
                    ye value = this.base.next();
                    if (value.h() && value.k() != Short.MAX_VALUE) {
                        return new TweakerItemSub(value.d, value.k());
                    }
                    return new TweakerItemSimple(value.d);
                }
                catch (TweakerExecuteException ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public cl toTagValue(String name) {
        return null;
    }

    @Override
    public String toString() {
        return "OreItems:" + this.ore;
    }
}

