/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.base.actions;

import net.minecraftforge.fluids.FluidContainerRegistry;
import stanhebben.minetweaker.MineTweakerUtil;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.value.TweakerItem;

public final class RemoveLiquidContainerAction
implements IUndoableAction {
    private final TweakerItem filled;
    private final FluidContainerRegistry.FluidContainerData data;

    public RemoveLiquidContainerAction(TweakerItem filled) {
        this.filled = filled;
        this.data = MineTweakerUtil.getContainerData(filled);
    }

    @Override
    public void apply() {
        MineTweakerUtil.removeContainer(this.filled);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)this.data);
    }

    @Override
    public String describe() {
        return "Removing fluid container " + this.filled.getDisplayName();
    }

    @Override
    public String describeUndo() {
        return "Restoring fluid container " + this.filled.getDisplayName();
    }
}

