/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.base.actions;

import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.damage.DamageModifier;
import stanhebben.minetweaker.damage.DamageTweaker;

public class ModifyArmorDamageAction
implements IUndoableAction {
    private final DamageModifier oldModifier;
    private final DamageModifier newModifier;

    public ModifyArmorDamageAction(String type, float armorEffectiveness, float armorDamage) {
        this.oldModifier = DamageTweaker.modifiers == null ? null : DamageTweaker.modifiers.get(type);
        this.newModifier = new DamageModifier(type, armorEffectiveness, armorDamage);
    }

    @Override
    public void apply() {
        DamageTweaker.registerModifier(this.newModifier);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        if (this.oldModifier == null) {
            DamageTweaker.modifiers.remove(this.newModifier.getDamageType());
        } else {
            DamageTweaker.registerModifier(this.oldModifier);
        }
    }

    @Override
    public String describe() {
        return "Modifying " + this.newModifier.getDamageType() + " damage";
    }

    @Override
    public String describeUndo() {
        return "Restoring " + this.newModifier.getDamageType() + " damage";
    }
}

