/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.base.actions;

import net.minecraftforge.fluids.Fluid;
import stanhebben.minetweaker.api.IUndoableAction;

public final class LiquidSetDensityAction
implements IUndoableAction {
    private final Fluid fluid;
    private final int newValue;
    private final int oldValue;

    public LiquidSetDensityAction(Fluid fluid, int newValue) {
        this.fluid = fluid;
        this.newValue = newValue;
        this.oldValue = fluid.getDensity();
    }

    @Override
    public void apply() {
        this.fluid.setDensity(this.newValue);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        this.fluid.setDensity(this.oldValue);
    }

    @Override
    public String describe() {
        return "Setting " + this.fluid.getLocalizedName() + " density to " + this.newValue;
    }

    @Override
    public String describeUndo() {
        return "Restoring " + this.fluid.getLocalizedName() + " density to " + this.oldValue;
    }
}

