/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.base.actions;

import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import stanhebben.minetweaker.MineTweakerUtil;
import stanhebben.minetweaker.api.IUndoableAction;

public class ItemSetToolClassAction
implements IUndoableAction {
    private final yc item;
    private final String cls;
    private final int level;
    private final List oldValue;

    public ItemSetToolClassAction(yc item, String cls, int level) {
        this.item = item;
        this.cls = cls;
        this.level = level;
        this.oldValue = MineTweakerUtil.getToolClass(item);
    }

    @Override
    public void apply() {
        MinecraftForge.setToolClass((yc)this.item, (String)this.cls, (int)this.level);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        if (this.oldValue != null) {
            MineTweakerUtil.setToolClass(this.item, this.oldValue);
        }
    }

    @Override
    public String describe() {
        return "Setting " + this.item.a() + " tool class to " + this.cls + " level " + this.level;
    }

    @Override
    public String describeUndo() {
        return "Restoring " + this.item.a() + " tool class";
    }
}

