/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.api.value;

import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.functions.FunctionIndexOf;
import stanhebben.minetweaker.api.functions.FunctionSplit;
import stanhebben.minetweaker.api.functions.FunctionSubstring;
import stanhebben.minetweaker.api.value.TweakerByte;
import stanhebben.minetweaker.api.value.TweakerDouble;
import stanhebben.minetweaker.api.value.TweakerField;
import stanhebben.minetweaker.api.value.TweakerFloat;
import stanhebben.minetweaker.api.value.TweakerInt;
import stanhebben.minetweaker.api.value.TweakerLong;
import stanhebben.minetweaker.api.value.TweakerShort;
import stanhebben.minetweaker.api.value.TweakerValue;

public final class TweakerString
extends TweakerValue {
    private final String value;

    public TweakerString(String value) {
        this.value = value;
    }

    public String get() {
        return this.value;
    }

    @Override
    public TweakerByte asByte() {
        try {
            return new TweakerByte(Byte.parseByte(this.value));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Override
    public TweakerShort asShort() {
        try {
            return new TweakerShort(Short.parseShort(this.value));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Override
    public TweakerInt asInt() {
        try {
            return new TweakerInt(Integer.parseInt(this.value));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Override
    public TweakerLong asLong() {
        try {
            return new TweakerLong(Long.parseLong(this.value));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Override
    public TweakerString asString() {
        return this;
    }

    @Override
    public TweakerFloat asFloat() {
        try {
            return new TweakerFloat(Float.parseFloat(this.value));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Override
    public TweakerDouble asDouble() {
        try {
            return new TweakerDouble(Double.parseDouble(this.value));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Override
    public TweakerValue add(TweakerValue other) {
        if (other == null) {
            return new TweakerString(this.value + "null");
        }
        TweakerString ostring = other.asString();
        if (ostring == null) {
            throw new TweakerExecuteException(other + " cannot be converted to string");
        }
        return new TweakerString(this.value + ostring.value);
    }

    @Override
    public Object asRecipeItem() {
        return this.value;
    }

    @Override
    public TweakerValue index(String index) {
        switch (TweakerField.get(index)) {
            case LENGTH: {
                return new TweakerInt(this.value.length());
            }
            case SUBSTRING: 
            case SUBS: {
                return new FunctionSubstring(this.value);
            }
            case INDEXOF: {
                return new FunctionIndexOf(this.value);
            }
            case SPLIT: {
                return new FunctionSplit(this.value);
            }
        }
        throw new IndexOutOfBoundsException("Invalid string field " + index);
    }

    @Override
    public cl toTagValue(String name) {
        return new ck(name, this.value);
    }

    @Override
    public String toString() {
        return this.value;
    }

    public static String unescapeString(String oldstr) throws TweakerExecuteException {
        if (oldstr.charAt(0) != '\"' || oldstr.charAt(oldstr.length() - 1) != '\"') {
            throw new TweakerExecuteException("Not a valid string constant: " + oldstr);
        }
        oldstr = oldstr.substring(1, oldstr.length() - 1);
        StringBuffer newstr = new StringBuffer(oldstr.length());
        boolean saw_backslash = false;
        for (int i = 0; i < oldstr.length(); ++i) {
            int cp = oldstr.codePointAt(i);
            if (oldstr.codePointAt(i) > 65535) {
                ++i;
            }
            if (!saw_backslash) {
                if (cp == 92) {
                    saw_backslash = true;
                    continue;
                }
                newstr.append(Character.toChars(cp));
                continue;
            }
            if (cp == 92) {
                saw_backslash = false;
                newstr.append('\\');
                newstr.append('\\');
                continue;
            }
            switch (cp) {
                case 114: {
                    newstr.append('\r');
                    break;
                }
                case 110: {
                    newstr.append('\n');
                    break;
                }
                case 102: {
                    newstr.append('\f');
                    break;
                }
                case 98: {
                    newstr.append("\\b");
                    break;
                }
                case 116: {
                    newstr.append('\t');
                    break;
                }
                case 97: {
                    newstr.append('\u0007');
                    break;
                }
                case 101: {
                    newstr.append('\u001b');
                    break;
                }
                case 99: {
                    if (++i == oldstr.length()) {
                        throw new TweakerExecuteException("trailing \\c");
                    }
                    cp = oldstr.codePointAt(i);
                    if (cp > 127) {
                        throw new TweakerExecuteException("expected ASCII after \\c");
                    }
                    newstr.append(Character.toChars(cp ^ 0x40));
                    break;
                }
                case 56: 
                case 57: {
                    throw new TweakerExecuteException("illegal octal digit");
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    --i;
                }
                case 48: {
                    char ch2;
                    int j;
                    if (i + 1 == oldstr.length()) {
                        newstr.append(Character.toChars(0));
                        break;
                    }
                    ++i;
                    int digits = 0;
                    for (j = 0; j <= 2 && i + j != oldstr.length() && (ch2 = oldstr.charAt(i + j)) >= '0' && ch2 <= '7'; ++j) {
                        ++digits;
                    }
                    if (digits == 0) {
                        --i;
                        newstr.append('\u0000');
                        break;
                    }
                    int value = 0;
                    try {
                        value = Integer.parseInt(oldstr.substring(i, i + digits), 8);
                    }
                    catch (NumberFormatException nfe) {
                        throw new TweakerExecuteException("invalid octal value for \\0 escape");
                    }
                    newstr.append(Character.toChars(value));
                    i += digits - 1;
                    break;
                }
                case 120: {
                    char ch2;
                    int j;
                    if (i + 2 > oldstr.length()) {
                        throw new TweakerExecuteException("string too short for \\x escape");
                    }
                    boolean saw_brace = false;
                    if (oldstr.charAt(++i) == '{') {
                        ++i;
                        saw_brace = true;
                    }
                    for (j = 0; j < 8 && (saw_brace || j != 2); ++j) {
                        ch2 = oldstr.charAt(i + j);
                        if (ch2 > '\u007f') {
                            throw new TweakerExecuteException("illegal non-ASCII hex digit in \\x escape");
                        }
                        if (saw_brace && ch2 == '}') break;
                        if (ch2 >= '0' && ch2 <= '9' || ch2 >= 'a' && ch2 <= 'f' || ch2 >= 'A' && ch2 <= 'F') continue;
                        throw new TweakerExecuteException(String.format("illegal hex digit #%d '%c' in \\x", ch2, (int)ch2));
                    }
                    if (j == 0) {
                        throw new TweakerExecuteException("empty braces in \\x{} escape");
                    }
                    int value = 0;
                    try {
                        value = Integer.parseInt(oldstr.substring(i, i + j), 16);
                    }
                    catch (NumberFormatException nfe) {
                        throw new TweakerExecuteException("invalid hex value for \\x escape");
                    }
                    newstr.append(Character.toChars(value));
                    if (saw_brace) {
                        ++j;
                    }
                    i += j - 1;
                    break;
                }
                case 117: {
                    int j;
                    if (i + 4 > oldstr.length()) {
                        throw new TweakerExecuteException("string too short for \\u escape");
                    }
                    ++i;
                    for (j = 0; j < 4; ++j) {
                        if (oldstr.charAt(i + j) <= '\u007f') continue;
                        throw new TweakerExecuteException("illegal non-ASCII hex digit in \\u escape");
                    }
                    int value = 0;
                    try {
                        value = Integer.parseInt(oldstr.substring(i, i + j), 16);
                    }
                    catch (NumberFormatException nfe) {
                        throw new TweakerExecuteException("invalid hex value for \\u escape");
                    }
                    newstr.append(Character.toChars(value));
                    i += j - 1;
                    break;
                }
                case 85: {
                    int j;
                    if (i + 8 > oldstr.length()) {
                        throw new TweakerExecuteException("string too short for \\U escape");
                    }
                    ++i;
                    for (j = 0; j < 8; ++j) {
                        if (oldstr.charAt(i + j) <= '\u007f') continue;
                        throw new TweakerExecuteException("illegal non-ASCII hex digit in \\U escape");
                    }
                    int value = 0;
                    try {
                        value = Integer.parseInt(oldstr.substring(i, i + j), 16);
                    }
                    catch (NumberFormatException nfe) {
                        throw new TweakerExecuteException("invalid hex value for \\U escape");
                    }
                    newstr.append(Character.toChars(value));
                    i += j - 1;
                    break;
                }
                default: {
                    newstr.append('\\');
                    newstr.append(Character.toChars(cp));
                }
            }
            saw_backslash = false;
        }
        if (saw_backslash) {
            newstr.append('\\');
        }
        return newstr.toString();
    }

    private static final String uniplus(String s) {
        if (s.length() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(2 + 3 * s.length());
        sb.append("U+");
        for (int i = 0; i < s.length(); ++i) {
            sb.append(String.format("%X", s.codePointAt(i)));
            if (s.codePointAt(i) > 65535) {
                ++i;
            }
            if (i + 1 >= s.length()) continue;
            sb.append(".");
        }
        return sb.toString();
    }
}

