/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.api.value;

import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.value.TweakerBool;
import stanhebben.minetweaker.api.value.TweakerField;
import stanhebben.minetweaker.api.value.TweakerInt;
import stanhebben.minetweaker.api.value.TweakerItem;
import stanhebben.minetweaker.api.value.TweakerLiquidStack;
import stanhebben.minetweaker.api.value.TweakerString;
import stanhebben.minetweaker.api.value.TweakerValue;
import stanhebben.minetweaker.base.actions.LiquidSetDensityAction;
import stanhebben.minetweaker.base.actions.LiquidSetGaseousAction;
import stanhebben.minetweaker.base.actions.LiquidSetLuminosityAction;
import stanhebben.minetweaker.base.actions.LiquidSetTemperatureAction;
import stanhebben.minetweaker.base.actions.SetLocalizedStringAction;
import stanhebben.minetweaker.base.functions.AddFluidContainerFunction;
import stanhebben.minetweaker.base.functions.RemoveFluidContainerFunction;

public final class TweakerLiquid
extends TweakerValue {
    private final Fluid fluid;

    public static TweakerLiquid fromLiquidBlock(TweakerItem block) {
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            if (fluid.getBlockID() != block.getItemId()) continue;
            return new TweakerLiquid(fluid);
        }
        return null;
    }

    public static TweakerLiquid fromLiquidContainer(TweakerItem container) {
        if (FluidContainerRegistry.isFilledContainer((ye)container.make(1))) {
            return new TweakerLiquid(FluidContainerRegistry.getFluidForFilledItem((ye)container.make(1)).getFluid());
        }
        return null;
    }

    public TweakerLiquid(Fluid fluid) {
        this.fluid = fluid;
    }

    public Fluid get() {
        return this.fluid;
    }

    public FluidStack make(int amount) {
        return new FluidStack(this.fluid, amount);
    }

    public boolean equalsFluid(Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        return fluid.getName().equals(this.fluid.getName());
    }

    public String getName() {
        return this.fluid.getName();
    }

    public String getDisplayName() {
        return this.fluid.getLocalizedName();
    }

    @Override
    public TweakerLiquid asFluid() {
        return this;
    }

    @Override
    public TweakerLiquidStack asFluidStack() {
        return new TweakerLiquidStack(new FluidStack(this.fluid, 1));
    }

    @Override
    public TweakerValue mul(TweakerValue value) {
        int amount = TweakerLiquid.notNull(value, "cannot multiply a fluid by null").toInt("can only multiply a fluid by an int value").get();
        return new TweakerLiquidStack(new FluidStack(this.fluid, amount));
    }

    @Override
    public TweakerValue index(String index) {
        switch (TweakerField.get(index)) {
            case NAME: {
                return new TweakerString(this.fluid.getUnlocalizedName());
            }
            case DISPLAYNAME: {
                return new TweakerString(this.fluid.getLocalizedName());
            }
            case LUMINOSITY: {
                return new TweakerInt(this.fluid.getLuminosity());
            }
            case DENSITY: {
                return new TweakerInt(this.fluid.getDensity());
            }
            case TEMPERATURE: {
                return new TweakerInt(this.fluid.getTemperature());
            }
            case GASEOUS: {
                return TweakerBool.get(this.fluid.isGaseous());
            }
            case ADDCONTAINER: {
                return new AddFluidContainerFunction(this.fluid);
            }
            case REMOVECONTAINER: {
                return new RemoveFluidContainerFunction(this.fluid);
            }
        }
        throw new TweakerExecuteException("no such field in fluid: " + index);
    }

    @Override
    public void indexSet(String index, TweakerValue value) {
        switch (TweakerField.get(index)) {
            case DISPLAYNAME: {
                Tweaker.apply(new SetLocalizedStringAction(this.fluid.getUnlocalizedName(), "en_US", value.toBasicString()));
                return;
            }
            case LUMINOSITY: {
                Tweaker.apply(new LiquidSetLuminosityAction(this.fluid, TweakerLiquid.notNull(value, "luminosity value cannot be null").toInt("luminosity value must be an int").get()));
                return;
            }
            case DENSITY: {
                Tweaker.apply(new LiquidSetDensityAction(this.fluid, TweakerLiquid.notNull(value, "density value cannot be null").toInt("density value must be an int").get()));
                return;
            }
            case TEMPERATURE: {
                Tweaker.apply(new LiquidSetTemperatureAction(this.fluid, TweakerLiquid.notNull(value, "temperature value cannot be null").toInt("temperature value must be an int").get()));
                return;
            }
            case GASEOUS: {
                Tweaker.apply(new LiquidSetGaseousAction(this.fluid, TweakerLiquid.notNull(value, "gaseous value cannot be null").toBool("gaseous value must be a bool").get()));
                return;
            }
        }
        throw new TweakerExecuteException("no such settable field in fluid: " + index);
    }

    @Override
    public boolean equals(TweakerValue other) {
        TweakerLiquid asFluid = other.asFluid();
        if (asFluid == null) {
            return false;
        }
        return asFluid.fluid.getName().equals(this.fluid.getName());
    }

    @Override
    public String toString() {
        return "Fluid:" + this.fluid.getUnlocalizedName();
    }
}

