/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.api.value;

import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.functions.FunctionItemAddTool;
import stanhebben.minetweaker.api.functions.FunctionItemPatternOnly;
import stanhebben.minetweaker.api.functions.FunctionItemRemoveTool;
import stanhebben.minetweaker.api.functions.FunctionItemSetToolClass;
import stanhebben.minetweaker.api.functions.FunctionItemWithDamage;
import stanhebben.minetweaker.api.functions.FunctionSetItemDisplayName;
import stanhebben.minetweaker.api.value.TweakerField;
import stanhebben.minetweaker.api.value.TweakerInt;
import stanhebben.minetweaker.api.value.TweakerItemDamaged;
import stanhebben.minetweaker.api.value.TweakerItemPattern;
import stanhebben.minetweaker.api.value.TweakerItemPatternItem;
import stanhebben.minetweaker.api.value.TweakerItemSimple;
import stanhebben.minetweaker.api.value.TweakerItemStack;
import stanhebben.minetweaker.api.value.TweakerItemStackPattern;
import stanhebben.minetweaker.api.value.TweakerItemStackPatternFromItemPattern;
import stanhebben.minetweaker.api.value.TweakerItemSub;
import stanhebben.minetweaker.api.value.TweakerLiquid;
import stanhebben.minetweaker.api.value.TweakerLiquidStack;
import stanhebben.minetweaker.api.value.TweakerString;
import stanhebben.minetweaker.api.value.TweakerValue;

public abstract class TweakerItem
extends TweakerValue {
    public static TweakerItem get(ye stack) {
        if (stack.h()) {
            return new TweakerItemSub(stack.d, stack.k());
        }
        return new TweakerItemSimple(stack.d);
    }

    public static TweakerItem parse(String value) {
        try {
            int colon = value.indexOf(58);
            if (colon < 0) {
                return new TweakerItemSimple(Integer.parseInt(value));
            }
            return new TweakerItemSub(Integer.parseInt(value.substring(0, colon)), Integer.parseInt(value.substring(colon + 1)));
        }
        catch (NumberFormatException ex) {
            throw new TweakerExecuteException("not a valid item id: " + value);
        }
    }

    public abstract int getItemId();

    public abstract int getItemSubId();

    public abstract boolean isSubItem();

    public abstract ye make(int var1);

    public abstract ye make();

    public abstract String getName();

    public abstract String getDisplayName();

    public abstract void setDisplayName(String var1);

    public abstract void setDisplayName(String var1, String var2);

    public abstract int getMaxDamage();

    public abstract int getFuelValue();

    public abstract void setFuelValue(int var1);

    public abstract void addTool(String var1, int var2);

    public abstract void removeTool(String var1);

    public abstract void setToolClass(String var1, int var2);

    public abstract String toIdString();

    public boolean matches(ye stack) {
        return stack.d == this.getItemId() && (!this.isSubItem() || this.getItemSubId() == Short.MAX_VALUE || this.getItemSubId() == stack.k());
    }

    @Override
    public TweakerItem asItem() {
        return this;
    }

    @Override
    public TweakerItemPattern asItemPattern() {
        return new TweakerItemPatternItem(this);
    }

    @Override
    public TweakerItemStack asItemStack() {
        return new TweakerItemStack(this.make());
    }

    @Override
    public TweakerItemStackPattern asItemStackPattern() {
        return new TweakerItemStackPatternFromItemPattern(this.asItemPattern());
    }

    @Override
    public TweakerLiquid asFluid() {
        return TweakerLiquid.fromLiquidBlock(this);
    }

    @Override
    public TweakerLiquidStack asFluidStack() {
        return TweakerLiquidStack.fromLiquidBlock(this);
    }

    @Override
    public Object asRecipeItem() {
        return this.make(1);
    }

    @Override
    public TweakerValue mul(TweakerValue value) throws TweakerExecuteException {
        return new TweakerItemStack(this.make(value.toBasicInt()));
    }

    @Override
    public TweakerValue index(String index) throws TweakerExecuteException {
        switch (TweakerField.get(index)) {
            case ID: {
                return new TweakerInt(this.getItemId());
            }
            case META: {
                return new TweakerInt(this.getItemSubId());
            }
            case DAMAGE: {
                return new TweakerInt(this.getItemSubId());
            }
            case MAXDAMAGE: {
                return new TweakerInt(this.getMaxDamage());
            }
            case NAME: {
                return new TweakerString(this.getName());
            }
            case DISPLAYNAME: {
                return new TweakerString(this.getDisplayName());
            }
            case FUEL: {
                return new TweakerInt(this.getFuelValue());
            }
            case SETDISPLAYNAME: {
                return new FunctionSetItemDisplayName(this);
            }
            case WITHDAMAGE: {
                if (this.isSubItem()) {
                    throw new TweakerExecuteException("Cannot create a damage subitem");
                }
                return new FunctionItemWithDamage(this.getItemId());
            }
            case DAMAGED: {
                if (this.isSubItem()) {
                    return this;
                }
                return new TweakerItemDamaged(this.getItemId());
            }
            case LIQUID: {
                TweakerLiquid liquid = TweakerLiquid.fromLiquidContainer(this);
                if (liquid == null) {
                    throw new TweakerExecuteException(this.getDisplayName() + " is not a liquid container");
                }
                return liquid;
            }
            case ONLY: {
                return new FunctionItemPatternOnly(this.asItemPattern());
            }
            case ADDTOOL: {
                return new FunctionItemAddTool(this);
            }
            case REMOVETOOL: {
                return new FunctionItemRemoveTool(this);
            }
            case SETTOOLCLASS: {
                return new FunctionItemSetToolClass(this);
            }
        }
        throw new TweakerExecuteException("No such member in Item: " + index);
    }

    @Override
    public void indexSet(String index, TweakerValue value) throws TweakerExecuteException {
        switch (TweakerField.get(index)) {
            case DISPLAYNAME: {
                this.setDisplayName(value.toBasicString());
                return;
            }
            case FUEL: {
                this.setFuelValue(value.toBasicInt());
                return;
            }
        }
        throw new TweakerExecuteException("Not a settable member in Item: " + index);
    }

    @Override
    public boolean equals(TweakerValue other) {
        TweakerItem otherItem = other.toItem("value is not an item");
        return this.getItemId() == otherItem.getItemId() && this.getItemSubId() == otherItem.getItemSubId();
    }
}

