/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.api.value;

import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.value.TweakerByte;
import stanhebben.minetweaker.api.value.TweakerDouble;
import stanhebben.minetweaker.api.value.TweakerFloat;
import stanhebben.minetweaker.api.value.TweakerItem;
import stanhebben.minetweaker.api.value.TweakerItemPattern;
import stanhebben.minetweaker.api.value.TweakerItemStack;
import stanhebben.minetweaker.api.value.TweakerItemStackPattern;
import stanhebben.minetweaker.api.value.TweakerLong;
import stanhebben.minetweaker.api.value.TweakerShort;
import stanhebben.minetweaker.api.value.TweakerString;
import stanhebben.minetweaker.api.value.TweakerValue;

public final class TweakerInt
extends TweakerValue {
    public static final TweakerInt ZERO = new TweakerInt(0);
    private final int value;

    public TweakerInt(int value) {
        this.value = value;
    }

    public int get() {
        return this.value;
    }

    @Override
    public int toBasicInt() {
        return this.value;
    }

    @Override
    public long toBasicLong() {
        return this.value;
    }

    @Override
    public cl toTagValue(String name) {
        return new cf(name, this.value);
    }

    @Override
    public TweakerByte asByte() {
        if (this.value < -128 || this.value > 127) {
            return null;
        }
        return new TweakerByte((byte)this.value);
    }

    @Override
    public TweakerByte toByte(String error) {
        if (this.value < -128 || this.value > 127) {
            throw new TweakerExecuteException("Value outside byte range, cannot convert: " + this.value);
        }
        return new TweakerByte((byte)this.value);
    }

    @Override
    public TweakerShort asShort() {
        if (this.value < Short.MIN_VALUE || this.value > Short.MAX_VALUE) {
            return null;
        }
        return new TweakerShort((short)this.value);
    }

    @Override
    public TweakerShort toShort(String error) {
        if (this.value < Short.MIN_VALUE || this.value > Short.MAX_VALUE) {
            throw new TweakerExecuteException("Value outside short range, cannot convert: " + this.value);
        }
        return new TweakerShort((short)this.value);
    }

    @Override
    public TweakerInt asInt() {
        return this;
    }

    @Override
    public TweakerLong asLong() {
        return new TweakerLong(this.value);
    }

    @Override
    public TweakerFloat asFloat() {
        return new TweakerFloat(this.value);
    }

    @Override
    public TweakerDouble asDouble() {
        return new TweakerDouble(this.value);
    }

    @Override
    public TweakerString asString() {
        return new TweakerString(Integer.toString(this.value));
    }

    @Override
    public TweakerItem toItem(String error) {
        throw new TweakerExecuteException("Cannot use " + this.value + " as item. Did you intend to use <" + this.value + "> instead?");
    }

    @Override
    public TweakerItemPattern toItemPattern(String error) {
        throw new TweakerExecuteException("Cannot use " + this.value + " as item pattern. Did you intend to use <" + this.value + "> instead?");
    }

    @Override
    public TweakerItemStack toItemStack(String error) {
        throw new TweakerExecuteException("Cannot use " + this.value + " as item stack. Did you intend to use <" + this.value + "> instead?");
    }

    @Override
    public TweakerItemStackPattern toItemStackPattern(String error) {
        throw new TweakerExecuteException("Cannot use " + this.value + " as item stack pattern. Did you intend to use <" + this.value + "> instead?");
    }

    @Override
    public Object toRecipeItem(String error) {
        throw new TweakerExecuteException("Cannot convert " + this.value + " to a recipe item. Did you intend to use <" + this.value + "> instead?");
    }

    @Override
    public TweakerValue add(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannot add null to an int value");
        }
        return other.addToInt(this.value);
    }

    @Override
    public TweakerValue sub(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannot subtract null from an int value");
        }
        return other.subToInt(this.value);
    }

    @Override
    public TweakerValue mul(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannot multiply an int value by null");
        }
        return other.mulToInt(this.value);
    }

    @Override
    public TweakerValue div(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannod divide an int value by null");
        }
        return other.divToInt(this.value);
    }

    @Override
    public TweakerValue mod(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannot modulo an int value by null");
        }
        return other.modToInt(this.value);
    }

    @Override
    public TweakerValue neg() {
        return new TweakerInt(-this.value);
    }

    @Override
    public TweakerValue not() {
        return new TweakerInt(~this.value);
    }

    @Override
    public TweakerValue or(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannot or an int value with null");
        }
        return other.orToInt(this.value);
    }

    @Override
    public TweakerValue and(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannot and an int value with null");
        }
        return other.andToInt(this.value);
    }

    @Override
    public TweakerValue xor(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannot xor an int value with null");
        }
        return other.xorToInt(this.value);
    }

    @Override
    public boolean equals(TweakerValue other) {
        if (other == null) {
            return false;
        }
        return other.equalsInt(this.value);
    }

    @Override
    public int compare(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannot compare an int value with null");
        }
        return other.compareInt(this.value);
    }

    @Override
    public TweakerValue index(String index) {
        if (index.equals("abs")) {
            return new TweakerInt(Math.abs(this.value));
        }
        throw new TweakerExecuteException("Unknown member " + index + " of byte value");
    }

    @Override
    public String toString() {
        return Integer.toString(this.value);
    }

    @Override
    public TweakerValue addToInt(int value) {
        return new TweakerInt(this.value + value);
    }

    @Override
    public TweakerValue addToLong(long value) {
        return new TweakerLong((long)this.value + value);
    }

    @Override
    public TweakerValue addToFloat(float value) {
        return new TweakerFloat(value + (float)this.value);
    }

    @Override
    public TweakerValue addToDouble(double value) {
        return new TweakerDouble(value + (double)this.value);
    }

    @Override
    public TweakerValue subToInt(int value) {
        return new TweakerInt(value - this.value);
    }

    @Override
    public TweakerValue subToLong(long value) {
        return new TweakerLong(value - (long)this.value);
    }

    @Override
    public TweakerValue subToFloat(float value) {
        return new TweakerFloat(value - (float)this.value);
    }

    @Override
    public TweakerValue subToDouble(double value) {
        return new TweakerDouble(value - (double)this.value);
    }

    @Override
    public TweakerValue mulToInt(int value) {
        return new TweakerInt(value * this.value);
    }

    @Override
    public TweakerValue mulToLong(long value) {
        return new TweakerLong(value * (long)this.value);
    }

    @Override
    public TweakerValue mulToFloat(float value) {
        return new TweakerFloat(value * (float)this.value);
    }

    @Override
    public TweakerValue mulToDouble(double value) {
        return new TweakerDouble(value * (double)this.value);
    }

    @Override
    public TweakerValue divToInt(int value) {
        if (this.value == 0) {
            throw new TweakerExecuteException("Cannot divide an int value by zero");
        }
        return new TweakerInt(value / this.value);
    }

    @Override
    public TweakerValue divToLong(long value) {
        if (this.value == 0) {
            throw new TweakerExecuteException("Cannot divide a long value by zero");
        }
        return new TweakerLong(value / (long)this.value);
    }

    @Override
    public TweakerValue divToFloat(float value) {
        return new TweakerFloat(value / (float)this.value);
    }

    @Override
    public TweakerValue divToDouble(double value) {
        return new TweakerDouble(value / (double)this.value);
    }

    @Override
    public TweakerValue modToInt(int value) {
        if (this.value == 0) {
            throw new TweakerExecuteException("Cannot modulo an int value by zero");
        }
        return new TweakerInt(value % this.value);
    }

    @Override
    public TweakerValue modToLong(long value) {
        if (this.value == 0) {
            throw new TweakerExecuteException("Cannot modulo a long value by zero");
        }
        return new TweakerLong(value % (long)this.value);
    }

    @Override
    public TweakerValue modToFloat(float value) {
        return new TweakerFloat(value % (float)this.value);
    }

    @Override
    public TweakerValue modToDouble(double value) {
        return new TweakerDouble(value % (double)this.value);
    }

    @Override
    public TweakerValue orToByte(byte value) {
        return new TweakerInt(value | this.value);
    }

    @Override
    public TweakerValue orToShort(short value) {
        return new TweakerInt(value | this.value);
    }

    @Override
    public TweakerValue orToInt(int value) {
        return new TweakerInt(value | this.value);
    }

    @Override
    public TweakerValue orToLong(long value) {
        return new TweakerLong(value | (long)this.value);
    }

    @Override
    public TweakerValue andToByte(byte value) {
        return new TweakerByte((byte)(value & this.value));
    }

    @Override
    public TweakerValue andToShort(short value) {
        return new TweakerShort((short)(value & this.value));
    }

    @Override
    public TweakerValue andToInt(int value) {
        return new TweakerInt(value & this.value);
    }

    @Override
    public TweakerValue andToLong(long value) {
        return new TweakerByte((byte)(value & (long)this.value));
    }

    @Override
    public TweakerValue xorToByte(byte value) {
        return new TweakerInt(value ^ this.value);
    }

    @Override
    public TweakerValue xorToShort(short value) {
        return new TweakerInt(value ^ this.value);
    }

    @Override
    public TweakerValue xorToInt(int value) {
        return new TweakerInt(value ^ this.value);
    }

    @Override
    public TweakerValue xorToLong(long value) {
        return new TweakerLong(value ^ (long)this.value);
    }

    @Override
    public boolean equalsInt(int value) {
        return this.value == value;
    }

    @Override
    public boolean equalsLong(long value) {
        return (long)this.value == value;
    }

    @Override
    public boolean equalsFloat(float value) {
        return (double)Math.abs(value - (float)this.value) < 1.0E-5;
    }

    @Override
    public boolean equalsDouble(double value) {
        return Math.abs(value - (double)this.value) < 1.0E-5;
    }

    @Override
    public int compareInt(int value) {
        return value - this.value;
    }

    @Override
    public int compareLong(long value) {
        return Long.compare(value, this.value);
    }

    @Override
    public int compareFloat(float value) {
        if ((double)Math.abs(value - (float)this.value) < 1.0E-5) {
            return 0;
        }
        if (value > (float)this.value) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareDouble(double value) {
        if (Math.abs(value - (double)this.value) < 1.0E-5) {
            return 0;
        }
        if (value > (double)this.value) {
            return 1;
        }
        return 0;
    }
}

