/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.api.value;

import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.value.TweakerBool;
import stanhebben.minetweaker.api.value.TweakerByte;
import stanhebben.minetweaker.api.value.TweakerField;
import stanhebben.minetweaker.api.value.TweakerFloat;
import stanhebben.minetweaker.api.value.TweakerInt;
import stanhebben.minetweaker.api.value.TweakerLong;
import stanhebben.minetweaker.api.value.TweakerShort;
import stanhebben.minetweaker.api.value.TweakerString;
import stanhebben.minetweaker.api.value.TweakerValue;

public final class TweakerDouble
extends TweakerValue {
    private final double value;

    public TweakerDouble(double value) {
        this.value = value;
    }

    public double get() {
        return this.value;
    }

    @Override
    public TweakerByte asByte() {
        if (this.value < -128.0 || this.value > 127.0) {
            return null;
        }
        return new TweakerByte((byte)this.value);
    }

    @Override
    public TweakerByte toByte(String error) {
        if (this.value < -128.0 || this.value > 127.0) {
            throw new TweakerExecuteException("Value outside byte range, cannot convert: " + this.value);
        }
        return new TweakerByte((byte)this.value);
    }

    @Override
    public TweakerShort asShort() {
        if (this.value < -32768.0 || this.value > 32767.0) {
            return null;
        }
        return new TweakerShort((short)this.value);
    }

    @Override
    public TweakerShort toShort(String error) {
        if (this.value < -32768.0 || this.value > 32767.0) {
            throw new TweakerExecuteException("Value outside short range, cannot convert: " + this.value);
        }
        return new TweakerShort((short)this.value);
    }

    @Override
    public TweakerInt asInt() {
        if (this.value < -2.147483648E9 || this.value > 2.147483647E9) {
            return null;
        }
        return new TweakerInt((int)this.value);
    }

    @Override
    public TweakerInt toInt(String error) {
        if (this.value < -2.147483648E9 || this.value > 2.147483647E9) {
            throw new TweakerExecuteException("Value outside int range, cannot convert: " + this.value);
        }
        return new TweakerInt((int)this.value);
    }

    @Override
    public TweakerLong asLong() {
        if (this.value < -9.223372036854776E18 || this.value > 9.223372036854776E18) {
            return null;
        }
        return new TweakerLong((long)this.value);
    }

    @Override
    public TweakerLong toLong(String error) {
        if (this.value < -9.223372036854776E18 || this.value > 9.223372036854776E18) {
            throw new TweakerExecuteException("Value out of long range, cannot convert: " + this.value);
        }
        return new TweakerLong((long)this.value);
    }

    @Override
    public TweakerFloat asFloat() {
        return new TweakerFloat((float)this.value);
    }

    @Override
    public TweakerDouble asDouble() {
        return this;
    }

    @Override
    public TweakerString asString() {
        return new TweakerString(Double.toString(this.value));
    }

    @Override
    public cl toTagValue(String name) {
        return new cb(name, this.value);
    }

    @Override
    public TweakerValue add(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannot add null to a double");
        }
        return other.addToDouble(this.value);
    }

    @Override
    public TweakerValue sub(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannot subtract null from a double");
        }
        return other.subToDouble(this.value);
    }

    @Override
    public TweakerValue mul(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannot multiply a double with null");
        }
        return other.mulToDouble(this.value);
    }

    @Override
    public TweakerValue div(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannot divide a double by null");
        }
        return other.divToDouble(this.value);
    }

    @Override
    public TweakerValue mod(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannot modulo a double with null");
        }
        return other.modToDouble(this.value);
    }

    @Override
    public TweakerValue neg() {
        return new TweakerDouble(-this.value);
    }

    @Override
    public boolean equals(TweakerValue other) {
        if (other == null) {
            return false;
        }
        return other.equalsDouble(this.value);
    }

    @Override
    public int compare(TweakerValue other) {
        if (other == null) {
            throw new TweakerExecuteException("Cannot compare a double with null");
        }
        return other.compareDouble(this.value);
    }

    @Override
    public TweakerValue index(String index) {
        switch (TweakerField.get(index)) {
            case ABS: {
                return new TweakerDouble(Math.abs(this.value));
            }
            case ISNAN: {
                return TweakerBool.get(Double.isNaN(this.value));
            }
            case ISINFINITE: {
                return TweakerBool.get(Double.isInfinite(this.value));
            }
        }
        throw new TweakerExecuteException("Unknown member " + index + " of double value");
    }

    @Override
    public String toString() {
        return Double.toString(this.value);
    }

    @Override
    public TweakerValue addToInt(int value) {
        return new TweakerDouble(this.value + (double)value);
    }

    @Override
    public TweakerValue addToLong(long value) {
        return new TweakerDouble(this.value + (double)value);
    }

    @Override
    public TweakerValue addToFloat(float value) {
        return new TweakerDouble((double)value + this.value);
    }

    @Override
    public TweakerValue addToDouble(double value) {
        return new TweakerDouble(value + this.value);
    }

    @Override
    public TweakerValue subToInt(int value) {
        return new TweakerDouble((double)value - this.value);
    }

    @Override
    public TweakerValue subToLong(long value) {
        return new TweakerDouble((double)value - this.value);
    }

    @Override
    public TweakerValue subToFloat(float value) {
        return new TweakerDouble((double)value - this.value);
    }

    @Override
    public TweakerValue subToDouble(double value) {
        return new TweakerDouble(value - this.value);
    }

    @Override
    public TweakerValue mulToInt(int value) {
        return new TweakerDouble((double)value * this.value);
    }

    @Override
    public TweakerValue mulToLong(long value) {
        return new TweakerDouble((double)value * this.value);
    }

    @Override
    public TweakerValue mulToFloat(float value) {
        return new TweakerDouble((double)value * this.value);
    }

    @Override
    public TweakerValue mulToDouble(double value) {
        return new TweakerDouble(value * this.value);
    }

    @Override
    public TweakerValue divToInt(int value) {
        return new TweakerDouble((double)value / this.value);
    }

    @Override
    public TweakerValue divToLong(long value) {
        return new TweakerDouble((double)value / this.value);
    }

    @Override
    public TweakerValue divToFloat(float value) {
        return new TweakerDouble((double)value / this.value);
    }

    @Override
    public TweakerValue divToDouble(double value) {
        return new TweakerDouble(value / this.value);
    }

    @Override
    public TweakerValue modToInt(int value) {
        return new TweakerDouble((double)value % this.value);
    }

    @Override
    public TweakerValue modToLong(long value) {
        return new TweakerDouble((double)value % this.value);
    }

    @Override
    public TweakerValue modToFloat(float value) {
        return new TweakerDouble((double)value % this.value);
    }

    @Override
    public TweakerValue modToDouble(double value) {
        return new TweakerDouble(value % this.value);
    }

    @Override
    public boolean equalsInt(int value) {
        return Math.abs(this.value - (double)value) < 1.0E-5;
    }

    @Override
    public boolean equalsLong(long value) {
        return Math.abs(this.value - (double)value) < 1.0E-5;
    }

    @Override
    public boolean equalsFloat(float value) {
        return Math.abs(this.value - (double)value) < 1.0E-5;
    }

    @Override
    public boolean equalsDouble(double value) {
        return Math.abs(this.value - value) < 1.0E-5;
    }

    @Override
    public int compareInt(int value) {
        if (Math.abs((double)value - this.value) < 1.0E-5) {
            return 0;
        }
        if ((double)value > this.value) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareLong(long value) {
        if (Math.abs((double)value - this.value) < 1.0E-5) {
            return 0;
        }
        if ((double)value > this.value) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareFloat(float value) {
        if (Math.abs((double)value - this.value) < 1.0E-5) {
            return 0;
        }
        if ((double)value > this.value) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareDouble(double value) {
        if (Math.abs(value - this.value) < 1.0E-5) {
            return 0;
        }
        if (value > this.value) {
            return 1;
        }
        return 0;
    }
}

