/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils.io;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.UnsignedBytes;
import java.util.Arrays;
import java.util.Map;

public class PacketChunker {
    private byte packetId = 0;
    private final Map<Byte, byte[][]> chunks = Maps.newHashMap();
    public static final int MAX_CHUNK_SIZE = 32667;

    public byte[][] splitIntoChunks(byte[] data) {
        int numChunks = (data.length + 32667 - 1) / 32667;
        Preconditions.checkArgument((numChunks < 256 ? 1 : 0) != 0, (String)"%s chunks? Way too much data, man.", (Object[])new Object[]{numChunks});
        byte[][] result = new byte[numChunks][];
        int chunkOffset = 0;
        for (int chunkIndex = 0; chunkIndex < numChunks; ++chunkIndex) {
            int chunkSize = Math.min(data.length - chunkOffset, 32667);
            ByteArrayDataOutput buf = ByteStreams.newDataOutput((int)32667);
            buf.writeByte(numChunks);
            if (numChunks > 1) {
                buf.writeByte(chunkIndex);
                buf.writeByte((int)this.packetId);
            }
            buf.write(data, chunkOffset, chunkSize);
            result[chunkIndex] = buf.toByteArray();
            chunkOffset += chunkSize;
        }
        this.packetId = (byte)(this.packetId + 1);
        return result;
    }

    public byte[] consumeChunk(byte[] payload) {
        ByteArrayDataInput input = ByteStreams.newDataInput((byte[])payload);
        int numChunks = UnsignedBytes.toInt((byte)input.readByte());
        if (numChunks == 1) {
            return Arrays.copyOfRange(payload, 1, payload.length);
        }
        int chunkIndex = UnsignedBytes.toInt((byte)input.readByte());
        byte incomingPacketId = input.readByte();
        Object alreadyReceived = this.chunks.get(incomingPacketId);
        if (alreadyReceived == null) {
            alreadyReceived = new byte[numChunks][];
            this.chunks.put(incomingPacketId, (byte[][])alreadyReceived);
        }
        byte[] chunkBytes = new byte[payload.length - 3];
        input.readFully(chunkBytes);
        alreadyReceived[chunkIndex] = chunkBytes;
        for (byte[] s : alreadyReceived) {
            if (s != null) continue;
            return null;
        }
        ByteArrayDataOutput byteArrayDataOutput = ByteStreams.newDataOutput();
        for (int i = 0; i < numChunks; i = (int)((short)(i + 1))) {
            byte[] chunkPart = alreadyReceived[i];
            byteArrayDataOutput.write(chunkPart);
        }
        this.chunks.remove(incomingPacketId);
        return byteArrayDataOutput.toByteArray();
    }
}

