/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import openmods.sync.SyncableObjectBase;

public class SyncableByteArray
extends SyncableObjectBase {
    private byte[] value = new byte[0];

    public SyncableByteArray() {
    }

    public SyncableByteArray(byte[] val) {
        this.value = val;
    }

    public void setValue(byte[] newValue) {
        if (newValue != this.value) {
            this.value = newValue;
            this.markDirty();
        }
    }

    public byte[] getValue() {
        return this.value;
    }

    @Override
    public void readFromStream(DataInput stream) throws IOException {
        int length = stream.readInt();
        this.value = new byte[length];
        for (int i = 0; i < length; ++i) {
            this.value[i] = stream.readByte();
        }
    }

    @Override
    public void writeToStream(DataOutput stream, boolean fullData) throws IOException {
        if (this.value == null) {
            stream.writeInt(0);
        } else {
            stream.writeInt(this.value.length);
            for (byte element : this.value) {
                stream.writeByte(element);
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String name) {
        nbt.func_74773_a(name, this.value);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String name) {
        nbt.func_74770_j(name);
    }
}

