/*
 * Decompiled with CFR 0.152.
 */
package openmods.network;

import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.minecraft.network.packet.Packet250CustomPayload;
import openmods.OpenMods;

public class PacketLogger {
    private static Logger debugLog;

    public static void log(Packet250CustomPayload packet, boolean incoming, String ... extras) {
        PacketLogger.log(packet, incoming, Arrays.asList(extras));
    }

    public static void log(Packet250CustomPayload packet, boolean incoming, List<String> extras) {
        ArrayList fields = Lists.newArrayList();
        fields.add(packet.field_73630_a);
        fields.add(OpenMods.proxy.isServerThread() ? "server" : "client");
        fields.add(incoming ? "incoming" : "outgoing");
        fields.add(Integer.toString(packet.field_73629_c.length));
        fields.addAll(extras);
        String extra = Joiner.on((char)'\t').join((Iterable)fields);
        PacketLogger.getDebugLog().info(extra);
    }

    private static Logger getDebugLog() {
        if (debugLog == null) {
            debugLog = Logger.getLogger("packets");
            try {
                File dir = OpenMods.proxy.getMinecraftDir();
                File logPattern = new File(dir, "open-mods-packets.log");
                FileHandler handler = new FileHandler(logPattern.getCanonicalPath(), 0x100000, 5);
                handler.setFormatter(new PacketLogFormatter());
                debugLog.addHandler(handler);
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
        }
        return debugLog;
    }

    private static class PacketLogFormatter
    extends Formatter {
        private static final String LINE_SEPARATOR = System.getProperty("line.separator");
        private static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS");

        private PacketLogFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            String isoDate = df.format(new Date(record.getMillis()));
            return isoDate + "\t" + this.formatMessage(record) + LINE_SEPARATOR;
        }
    }
}

