/*
 * Decompiled with CFR 0.152.
 */
package openmods.movement;

import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import openmods.OpenModsCorePlugin;
import openmods.asm.MethodMatcher;
import openmods.asm.StopTransforming;
import openmods.asm.VisitorHelper;
import openmods.movement.PlayerMovementManager;
import org.apache.commons.lang3.ArrayUtils;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class MovementPatcher
extends ClassVisitor {
    private static final String MANAGER_CLASS = Type.getInternalName(PlayerMovementManager.class);
    private final Method callbackMethod;
    private final MethodMatcher injectedMethodMatcher;
    private final MethodMatcher calledMethodMatcher;

    public MovementPatcher(String obfClassName, ClassVisitor cv) {
        super(262144, cv);
        String movementInputName = "net/minecraft/util/MovementInput";
        String entityPlayerName = "net/minecraft/entity/player/EntityPlayer";
        if (VisitorHelper.useSrgNames()) {
            movementInputName = FMLDeobfuscatingRemapper.INSTANCE.unmap(movementInputName);
            entityPlayerName = FMLDeobfuscatingRemapper.INSTANCE.unmap(entityPlayerName);
        }
        Type movementInputType = Type.getObjectType((String)movementInputName);
        Type entityPlayerType = Type.getObjectType((String)entityPlayerName);
        this.callbackMethod = new Method("updateMovementState", Type.VOID_TYPE, (Type[])ArrayUtils.toArray((Object[])new Type[]{movementInputType, entityPlayerType}));
        this.calledMethodMatcher = new MethodMatcher(movementInputName, "()V", "updatePlayerMoveState", "func_78898_a");
        this.injectedMethodMatcher = new MethodMatcher(obfClassName, "()V", "onLivingUpdate", "func_70636_d");
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor parent = super.visitMethod(access, name, desc, signature, exceptions);
        return this.injectedMethodMatcher.match(name, desc) ? new CallInjector(parent) : parent;
    }

    private class CallInjector
    extends MethodVisitor {
        public CallInjector(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            boolean patch;
            boolean bl = patch = opcode == 182 && MovementPatcher.this.calledMethodMatcher.match(name, desc);
            if (patch) {
                if (PlayerMovementManager.callbackInjected) {
                    OpenModsCorePlugin.log.warning("Method code mismatch, aborting");
                    PlayerMovementManager.callbackInjected = false;
                    throw new StopTransforming();
                }
                this.visitInsn(89);
            }
            super.visitMethodInsn(opcode, owner, name, desc);
            if (patch) {
                this.visitVarInsn(25, 0);
                this.visitMethodInsn(184, MANAGER_CLASS, MovementPatcher.this.callbackMethod.getName(), MovementPatcher.this.callbackMethod.getDescriptor());
                OpenModsCorePlugin.log.info("Callback inserted. Using new movement handler.");
                PlayerMovementManager.callbackInjected = true;
            }
        }
    }
}

