/*
 * Decompiled with CFR 0.152.
 */
package openmods.item;

import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import openmods.item.IMetaItem;

public class MetaGeneric
implements IMetaItem {
    private final String mod;
    private final String name;
    private Icon icon;
    private Object[] recipes;
    private boolean visibleInCreative = true;

    public MetaGeneric(String mod, String name, Object ... recipes) {
        this.mod = mod;
        this.name = name;
        this.recipes = recipes;
    }

    public MetaGeneric hideFromCreative() {
        this.visibleInCreative = false;
        return this;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public String getUnlocalizedName(ItemStack stack) {
        return String.format("%s.%s", this.mod, this.name);
    }

    @Override
    public boolean hitEntity(ItemStack itemStack, EntityLivingBase target, EntityLivingBase player) {
        return false;
    }

    @Override
    public boolean onItemUse(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        return false;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack itemStack, EntityPlayer player, World world) {
        return itemStack;
    }

    @Override
    public void registerIcons(IconRegister register) {
        this.registerIcon(register, this.name);
    }

    protected void registerIcon(IconRegister register, String name) {
        this.icon = register.func_94245_a(String.format("%s:%s", this.mod, name));
    }

    @Override
    public void addRecipe() {
        if (this.recipes == null) {
            return;
        }
        FurnaceRecipes furnaceRecipes = FurnaceRecipes.func_77602_a();
        List craftingRecipes = CraftingManager.func_77594_a().func_77592_b();
        for (Object tmp : this.recipes) {
            if (tmp instanceof SmeltingRecipe) {
                SmeltingRecipe recipe = (SmeltingRecipe)tmp;
                furnaceRecipes.addSmelting(recipe.itemId, recipe.itemMeta, recipe.result, recipe.experience);
                continue;
            }
            if (tmp instanceof IRecipe) {
                craftingRecipes.add((IRecipe)tmp);
                continue;
            }
            throw new IllegalArgumentException("Invalid recipe object: " + tmp);
        }
    }

    @Override
    public void addToCreativeList(int itemId, int meta, List<ItemStack> result) {
        if (this.visibleInCreative) {
            result.add(new ItemStack(itemId, 1, meta));
        }
    }

    @Override
    public boolean hasEffect(int renderPass) {
        return false;
    }

    public static class SmeltingRecipe {
        public final int itemId;
        public final int itemMeta;
        public final ItemStack result;
        public final float experience;

        private SmeltingRecipe(int itemId, int itemMeta, ItemStack result, float experience) {
            this.itemId = itemId;
            this.itemMeta = itemMeta;
            this.result = result.func_77946_l();
            this.experience = experience;
        }
    }
}

