/*
 * Decompiled with CFR 0.152.
 */
package openmods;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import openmods.GenericInventory;
import openmods.utils.ItemUtils;

public class ItemInventory
extends GenericInventory {
    public static final String TAG_INVENTORY = "inventory";
    private final EntityPlayer player;
    private final ItemStack inventoryStack;
    private final int inventorySlot;

    public ItemInventory(EntityPlayer _player, int size) {
        this(_player, size, _player.field_71071_by.field_70461_c);
    }

    public ItemInventory(EntityPlayer _player, int size, int inventorySlot) {
        super("", false, size);
        this.player = _player;
        this.inventorySlot = inventorySlot;
        this.inventoryStack = this.player.field_71071_by.func_70301_a(inventorySlot);
        NBTTagCompound tag = ItemUtils.getItemTag(this.inventoryStack);
        this.readFromNBT(ItemInventory.getInventoryTag(tag));
    }

    @Override
    public void onInventoryChanged(int slotNumber) {
        super.onInventoryChanged(slotNumber);
        ItemStack currentStack = this.player.field_71071_by.func_70301_a(this.inventorySlot);
        if (currentStack == null || !currentStack.func_77969_a(this.inventoryStack)) {
            this.player.func_71053_j();
            return;
        }
        NBTTagCompound tag = ItemUtils.getItemTag(currentStack);
        NBTTagCompound inventoryTag = ItemInventory.getInventoryTag(tag);
        this.writeToNBT(inventoryTag);
        tag.func_74782_a(TAG_INVENTORY, (NBTBase)inventoryTag);
        currentStack.func_77982_d(tag);
        this.player.field_71071_by.func_70299_a(this.inventorySlot, currentStack);
    }

    public static NBTTagCompound getInventoryTag(NBTTagCompound tag) {
        return tag.func_74775_l(TAG_INVENTORY);
    }
}

