/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.blocks.logic;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Facing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.util.IActiveLogic;
import tconstruct.library.util.IFacingLogic;
import tmechworks.inventory.DrawbridgeContainer;
import tmechworks.lib.blocks.IDrawbridgeLogicBase;
import tmechworks.lib.blocks.InventoryLogic;
import tmechworks.lib.player.FakePlayerLogic;

public class DrawbridgeLogic
extends InventoryLogic
implements IFacingLogic,
IActiveLogic,
IDrawbridgeLogicBase {
    boolean active;
    boolean working;
    int ticks;
    byte extension;
    byte maxExtension = (byte)15;
    byte direction;
    byte placementDirection = (byte)4;
    FakePlayerLogic fakePlayer;
    ItemStack bufferStack = null;

    public DrawbridgeLogic() {
        super(2);
    }

    public void func_70313_j() {
        this.field_70328_o = true;
        this.fakePlayer = null;
    }

    private void initFakePlayer() {
        if (this.fakePlayer == null && !this.func_70320_p()) {
            this.fakePlayer = new FakePlayerLogic("Player.Drawbridge", this);
        }
    }

    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean flag) {
        this.active = flag;
        this.working = true;
    }

    public byte getRenderDirection() {
        return this.direction;
    }

    public ForgeDirection getForgeDirection() {
        return ForgeDirection.VALID_DIRECTIONS[this.direction];
    }

    public void setDirection(int side) {
    }

    @Override
    public boolean canDropInventorySlot(int slot) {
        return false;
    }

    public void setMaximumExtension(byte length) {
        this.maxExtension = length;
    }

    public void setDirection(float yaw, float pitch, EntityLivingBase player) {
        if (pitch > 45.0f) {
            this.direction = 1;
        } else if (pitch < -45.0f) {
            this.direction = 0;
        } else {
            int facing = MathHelper.func_76128_c((double)((double)(yaw / 360.0f) + 0.5)) & 3;
            switch (facing) {
                case 0: {
                    this.direction = (byte)2;
                    break;
                }
                case 1: {
                    this.direction = (byte)5;
                    break;
                }
                case 2: {
                    this.direction = (byte)3;
                    break;
                }
                case 3: {
                    this.direction = (byte)4;
                }
            }
        }
    }

    public void setPlacementDirection(byte keycode) {
        if (!this.field_70331_k.field_72995_K) {
            this.initFakePlayer();
            if (keycode == 4) {
                this.fakePlayer.field_70177_z = 0.0f;
                this.fakePlayer.field_70125_A = 0.0f;
            } else if (this.direction == 0 || this.direction == 1) {
                switch (keycode) {
                    case 0: {
                        this.fakePlayer.field_70177_z = 0.0f;
                        break;
                    }
                    case 1: {
                        this.fakePlayer.field_70177_z = 90.0f;
                        break;
                    }
                    case 2: {
                        this.fakePlayer.field_70177_z = 180.0f;
                        break;
                    }
                    case 3: {
                        this.fakePlayer.field_70177_z = 270.0f;
                    }
                }
                this.fakePlayer.field_70125_A = this.direction == 0 ? -90.0f : 90.0f;
            } else if (keycode == 0) {
                this.fakePlayer.field_70177_z = this.mapDirection() * 90;
                this.fakePlayer.field_70125_A = keycode == 0 ? 90.0f : -90.0f;
            } else if (keycode == 2) {
                int face = this.mapDirection() + 2;
                if (face > 3) {
                    face -= 4;
                }
                this.fakePlayer.field_70177_z = face * 90;
                this.fakePlayer.field_70125_A = keycode == 0 ? 90.0f : -90.0f;
            } else {
                this.fakePlayer.field_70125_A = 0.0f;
                int facing = this.mapDirection();
                facing = keycode == 1 ? ++facing : --facing;
                if (facing >= 4) {
                    facing = 0;
                }
                if (facing < 0) {
                    facing = 3;
                }
                this.fakePlayer.field_70177_z = facing * 90;
            }
        }
        this.placementDirection = keycode;
    }

    int mapDirection() {
        if (this.direction == 2) {
            return 0;
        }
        if (this.direction == 5) {
            return 1;
        }
        if (this.direction == 3) {
            return 2;
        }
        return 3;
    }

    @Override
    public byte getPlacementDirection() {
        return this.placementDirection;
    }

    @Override
    public Container getGuiContainer(InventoryPlayer inventoryplayer, World world, int x, int y, int z) {
        return new DrawbridgeContainer(inventoryplayer, this);
    }

    @Override
    protected String getDefaultName() {
        return "tmechworks.drawbridge";
    }

    @Override
    public void func_70299_a(int slot, ItemStack itemstack) {
        super.func_70299_a(slot, itemstack);
        if (slot == 1) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    @Override
    public ItemStack func_70298_a(int slot, int quantity) {
        ItemStack stack = super.func_70298_a(slot, quantity);
        if (slot == 1) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        return stack;
    }

    public void func_70316_g() {
        if (this.working && !this.func_70320_p()) {
            ++this.ticks;
            if (this.ticks == 5) {
                this.ticks = 0;
                if (this.active) {
                    if (this.inventory[0] != null && this.inventory[0].field_77994_a > 0 && this.extension < this.maxExtension) {
                        this.extension = (byte)(this.extension + 1);
                        int xPos = this.field_70329_l;
                        int yPos = this.field_70330_m;
                        int zPos = this.field_70327_n;
                        this.bufferStack = this.inventory[0].func_77946_l();
                        this.bufferStack.field_77994_a = 1;
                        switch (this.direction) {
                            case 0: {
                                yPos -= this.extension;
                                break;
                            }
                            case 1: {
                                yPos += this.extension;
                                break;
                            }
                            case 2: {
                                zPos -= this.extension;
                                break;
                            }
                            case 3: {
                                zPos += this.extension;
                                break;
                            }
                            case 4: {
                                xPos -= this.extension;
                                break;
                            }
                            case 5: {
                                xPos += this.extension;
                            }
                        }
                        Block block = Block.field_71973_m[this.field_70331_k.func_72798_a(xPos, yPos, zPos)];
                        if (block == null || block.isAirBlock(this.field_70331_k, xPos, yPos, zPos) || block.isBlockReplaceable(this.field_70331_k, xPos, yPos, zPos)) {
                            List list;
                            Block placeBlock;
                            this.initFakePlayer();
                            int blockToItem = TConstructRegistry.blockToItemMapping[this.bufferStack.field_77993_c];
                            if (blockToItem == 0) {
                                if (this.inventory[0].field_77993_c >= 4096 || Block.field_71973_m[this.inventory[0].field_77993_c] == null) {
                                    return;
                                }
                                placeBlock = Block.field_71973_m[this.bufferStack.field_77993_c];
                                this.placeBlockAt(this.bufferStack, (EntityPlayer)this.fakePlayer, this.field_70331_k, xPos, yPos, zPos, this.direction, 0.0f, 0.0f, 0.0f, this.bufferStack.func_77960_j(), placeBlock);
                            } else {
                                placeBlock = Block.field_71973_m[blockToItem];
                                this.placeBlockAt(this.bufferStack, (EntityPlayer)this.fakePlayer, this.field_70331_k, xPos, yPos, zPos, this.direction, 0.0f, 0.0f, 0.0f, this.bufferStack.func_77960_j(), placeBlock);
                            }
                            this.field_70331_k.func_72908_a((double)xPos + 0.5, (double)yPos + 0.5, (double)zPos + 0.5, "tile.piston.out", 0.25f, this.field_70331_k.field_73012_v.nextFloat() * 0.25f + 0.6f);
                            ArrayList pushedObjects = new ArrayList();
                            Block b1 = Block.field_71973_m[this.bufferStack.field_77993_c];
                            AxisAlignedBB axisalignedbb = b1 != null ? b1.func_71872_e(this.field_70331_k, xPos, yPos, zPos) : Block.field_71973_m[1].func_71872_e(this.field_70331_k, xPos, yPos, zPos);
                            if (axisalignedbb != null && !(list = this.field_70331_k.func_72839_b((Entity)null, axisalignedbb)).isEmpty()) {
                                pushedObjects.addAll(list);
                                for (Entity entity : pushedObjects) {
                                    entity.func_70091_d((double)Facing.field_71586_b[this.direction], (double)Facing.field_71587_c[this.direction], (double)Facing.field_71585_d[this.direction]);
                                }
                                pushedObjects.clear();
                            }
                            this.func_70298_a(0, 1);
                        } else {
                            this.extension = (byte)(this.extension - 1);
                            this.working = false;
                        }
                    } else {
                        this.working = false;
                    }
                } else if ((this.inventory[0] == null || this.inventory[0].field_77994_a < this.inventory[0].func_77976_d()) && this.extension > 0) {
                    int xPos = this.field_70329_l;
                    int yPos = this.field_70330_m;
                    int zPos = this.field_70327_n;
                    switch (this.direction) {
                        case 0: {
                            yPos -= this.extension;
                            break;
                        }
                        case 1: {
                            yPos += this.extension;
                            break;
                        }
                        case 2: {
                            zPos -= this.extension;
                            break;
                        }
                        case 3: {
                            zPos += this.extension;
                            break;
                        }
                        case 4: {
                            xPos -= this.extension;
                            break;
                        }
                        case 5: {
                            xPos += this.extension;
                        }
                    }
                    Block block = Block.field_71973_m[this.field_70331_k.func_72798_a(xPos, yPos, zPos)];
                    if (block != null) {
                        int meta = this.field_70331_k.func_72805_g(xPos, yPos, zPos);
                        if (this.bufferStack != null && this.validBlock(block) && this.validMetadata(block, meta) && this.validDrawbridge(xPos, yPos, zPos)) {
                            this.field_70331_k.func_72908_a((double)xPos + 0.5, (double)yPos + 0.5, (double)zPos + 0.5, "tile.piston.in", 0.25f, this.field_70331_k.field_73012_v.nextFloat() * 0.15f + 0.6f);
                            if (this.field_70331_k.func_94575_c(xPos, yPos, zPos, 0)) {
                                if (this.inventory[0] == null) {
                                    this.inventory[0] = this.bufferStack.func_77946_l();
                                } else {
                                    ++this.inventory[0].field_77994_a;
                                }
                            }
                        } else {
                            this.working = false;
                        }
                    }
                    this.extension = (byte)(this.extension - 1);
                } else {
                    this.working = false;
                }
            }
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata, Block block) {
        if (!world.func_72832_d(x, y, z, block.field_71990_ca, metadata, 3)) {
            return false;
        }
        if (world.func_72798_a(x, y, z) == block.field_71990_ca) {
            block.func_71860_a(world, x, y, z, (EntityLivingBase)player, stack);
            block.func_85105_g(world, x, y, z, metadata);
        }
        return true;
    }

    boolean validDrawbridge(int x, int y, int z) {
        TileEntity te = this.field_70331_k.func_72796_p(x, y, z);
        return !(te instanceof IDrawbridgeLogicBase) || !((IDrawbridgeLogicBase)te).hasExtended();
    }

    boolean validBlock(Block block) {
        int type = TConstructRegistry.interchangableBlockMapping[block.field_71990_ca];
        if (type != 0 && type == this.bufferStack.field_77993_c) {
            return true;
        }
        int blockToItem = TConstructRegistry.blockToItemMapping[block.field_71990_ca];
        if (blockToItem != 0 && blockToItem == this.bufferStack.field_77993_c) {
            return true;
        }
        return block.field_71990_ca == this.bufferStack.field_77993_c;
    }

    boolean validMetadata(Block block, int metadata) {
        int type = TConstructRegistry.drawbridgeState[block.field_71990_ca];
        if (type == 0) {
            return metadata == this.bufferStack.func_77960_j();
        }
        if (type == 1) {
            return true;
        }
        if (type == 2) {
            return false;
        }
        if (type == 3) {
            return true;
        }
        if (type == 4) {
            return true;
        }
        if (type == 5) {
            return metadata == this.bufferStack.func_77960_j();
        }
        return false;
    }

    @Override
    public void func_70307_a(NBTTagCompound tags) {
        super.func_70307_a(tags);
        this.active = tags.func_74767_n("Active");
        this.working = tags.func_74767_n("Working");
        this.extension = tags.func_74771_c("Extension");
        this.maxExtension = tags.func_74771_c("MaxExtension");
        NBTTagCompound bufferInv = (NBTTagCompound)tags.func_74781_a("BufferInv");
        if (bufferInv != null) {
            this.bufferStack = ItemStack.func_77949_a((NBTTagCompound)bufferInv);
        }
        if (this.bufferStack == null && this.inventory[0] != null) {
            this.bufferStack = this.inventory[0];
        }
        this.readCustomNBT(tags);
    }

    @Override
    public void func_70310_b(NBTTagCompound tags) {
        super.func_70310_b(tags);
        tags.func_74757_a("Active", this.active);
        tags.func_74757_a("Working", this.working);
        tags.func_74774_a("Extension", this.extension);
        tags.func_74774_a("MaxExtension", this.maxExtension);
        if (this.bufferStack != null) {
            NBTTagCompound bufferInv = new NBTTagCompound();
            this.bufferStack.func_77955_b(bufferInv);
            tags.func_74782_a("BufferInv", (NBTBase)bufferInv);
        }
        this.writeCustomNBT(tags);
    }

    public void readCustomNBT(NBTTagCompound tags) {
        this.direction = tags.func_74771_c("Direction");
        this.placementDirection = tags.func_74771_c("Placement");
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        tags.func_74774_a("Direction", this.direction);
        tags.func_74774_a("Placement", this.placementDirection);
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70310_b(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public boolean hasExtended() {
        return this.extension != 0;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.func_70301_a(0) != null) {
            this.bufferStack = this.func_70301_a(0).func_77946_l();
            this.bufferStack.field_77994_a = 1;
        }
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }
}

