/*
 * Decompiled with CFR 0.152.
 */
package enchiridion.api.pages;

import enchiridion.Enchiridion;
import enchiridion.api.GuiGuide;
import enchiridion.api.GuideHandler;
import enchiridion.api.XMLHelper;
import enchiridion.api.pages.PageParser;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.w3c.dom.Element;

public class PageImage
extends PageParser {
    private static final HashMap<String, LinkedTexture> imageCache = new HashMap();
    float stretch;
    private ResourceLocation resource;
    private TextureManager tm;
    private String mod;
    private String src;
    private String key;

    @Override
    public void init(GuiGuide gui, int x, int y, boolean left) {
        super.init(gui, x, y, left);
        this.tm = gui.getMC().func_110434_K();
    }

    @Override
    public void read(Element xml) {
        this.stretch = XMLHelper.getAttribAsFloat(xml, "stretch", Float.valueOf(1.0f)).floatValue();
        this.mod = XMLHelper.getAttribute(xml, "mod");
        if (!this.mod.equals("")) {
            this.resource = new ResourceLocation(this.mod, "textures/books/" + XMLHelper.getAttribute(xml, "src") + ".png");
        } else {
            this.src = XMLHelper.getAttribute(xml, "src");
            this.key = this.bookID + "|" + XMLHelper.getAttribute(xml, "src");
        }
    }

    @Override
    public void resize(Element xml) {
        this.x += XMLHelper.getAttribAsInteger(xml, "x", 0).intValue();
        this.y += XMLHelper.getAttribAsInteger(xml, "y", 0).intValue();
        this.size = XMLHelper.getAttribAsFloat(xml, "size", Float.valueOf(1.0f)).floatValue();
        this.x = (int)((float)this.x / (this.stretch * this.size) * 1.0f);
        GL11.glScalef((float)(this.stretch * this.size), (float)this.size, (float)this.size);
    }

    @Override
    public void parse() {
        if (!this.mod.equals("")) {
            this.tm.func_110577_a(this.resource);
            this.gui.func_73729_b(this.x, this.y, 0, 0, 256, 256);
        } else if (!GuideHandler.DEBUG_ENABLED) {
            LinkedTexture tex = imageCache.get(this.key);
            if (tex != null) {
                this.drawImage(tex.texture, tex.resource, this.x + (100 - tex.width) / 2, this.y + (100 - tex.height) / 2, tex.width, tex.height);
            }
        } else {
            File file = new File(Enchiridion.root + File.separator + "debug" + File.separator + this.src + ".png");
            try {
                BufferedImage img = ImageIO.read(file);
                DynamicTexture dm = new DynamicTexture(img);
                ResourceLocation texture = Minecraft.func_71410_x().func_110434_K().func_110578_a(this.key, dm);
                LinkedTexture tex = new LinkedTexture(img.getHeight(), img.getWidth(), dm, texture);
                this.drawImage(tex.texture, tex.resource, this.x + (100 - tex.width) / 2, this.y + (100 - tex.height) / 2, tex.width, tex.height);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void addToCache(String str, LinkedTexture tex) {
        imageCache.put(str, tex);
    }

    private void drawImage(DynamicTexture dm, ResourceLocation rs, int x, int y, int width, int height) {
        dm.func_110564_a();
        Tessellator tessellator = Tessellator.field_78398_a;
        this.tm.func_110577_a(rs);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + height), 0.0, 0.0, 1.0);
        tessellator.func_78374_a((double)(x + width), (double)(y + height), 0.0, 1.0, 1.0);
        tessellator.func_78374_a((double)(x + width), (double)y, 0.0, 1.0, 0.0);
        tessellator.func_78374_a((double)x, (double)y, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    public static class LinkedTexture {
        int height;
        int width;
        DynamicTexture texture;
        ResourceLocation resource;

        public LinkedTexture(int height, int width, DynamicTexture texture, ResourceLocation resource) {
            this.height = height;
            this.width = width;
            this.texture = texture;
            this.resource = resource;
        }
    }
}

