/*
 * Decompiled with CFR 0.152.
 */
package enchiridion.api;

import enchiridion.api.GuideHandler;
import enchiridion.api.StackHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class DisplayRegistry {
    private static final HashMap<String, Icon> fluidsCache = new HashMap();
    private static final HashMap<String, ItemStack> itemCache = new HashMap();
    private static final HashMap<String, Integer[]> metaCache = new HashMap();
    private static final ArrayList<String> oreDicCache = new ArrayList();

    public static void registerOreDictionaryCycling(String name) {
        if (!oreDicCache.contains(name)) {
            oreDicCache.add(name);
        }
    }

    public static void registerMetaCycling(Item item, String key, Integer[] metas) {
        metaCache.put(key, metas);
        DisplayRegistry.registerShorthand(key, new ItemStack(item));
    }

    public static void registerShorthand(String key, ItemStack stack) {
        if (!itemCache.containsKey(key)) {
            itemCache.put(key, stack);
        }
    }

    public static ItemStack getIcon(String str) {
        if (str.equals("")) {
            return null;
        }
        if (itemCache.containsKey(str)) {
            return itemCache.get(str);
        }
        if (OreDictionary.getOres((String)str).size() > 0) {
            itemCache.put(str, (ItemStack)OreDictionary.getOres((String)str).get(0));
        } else {
            ItemStack stack = StackHelper.getStackFromString(str);
            itemCache.put(str, stack);
        }
        return itemCache.get(str);
    }

    public static Icon getFluidIcon(String str) {
        if (fluidsCache.containsKey(str)) {
            return fluidsCache.get(str);
        }
        Fluid fluid = FluidRegistry.getFluid((String)str);
        if (fluid == null) {
            return null;
        }
        fluidsCache.put(str, fluid.getIcon());
        return FluidRegistry.getFluid((String)str).getIcon();
    }

    public static void updateIcons() {
        for (String string : oreDicCache) {
            ArrayList ores = OreDictionary.getOres((String)string);
            if (ores == null || ores.size() <= 0) continue;
            itemCache.put(string, (ItemStack)ores.get(GuideHandler.rand.nextInt(ores.size())));
        }
        for (Map.Entry entry : metaCache.entrySet()) {
            ItemStack stack = itemCache.get(entry.getKey());
            if (stack == null || entry == null || ((Integer[])entry.getValue()).length <= 0) continue;
            stack.func_77964_b(((Integer[])entry.getValue())[GuideHandler.rand.nextInt(((Integer[])entry.getValue()).length)].intValue());
            itemCache.put((String)entry.getKey(), stack);
        }
    }

    static {
        DisplayRegistry.registerShorthand("brick", new ItemStack(Item.field_77772_aH));
        DisplayRegistry.registerShorthand("brickBlock", new ItemStack(Block.field_72081_al));
        DisplayRegistry.registerShorthand("quartzSlab", new ItemStack((Block)Block.field_72079_ak, 1, 7));
        DisplayRegistry.registerShorthand("stoneSlab", new ItemStack((Block)Block.field_72079_ak, 1, 0));
        DisplayRegistry.registerShorthand("minecraft:bookshelf", new ItemStack(Block.field_72093_an));
        DisplayRegistry.registerShorthand("minecraft:hopper", new ItemStack((Block)Block.field_94340_cs));
        DisplayRegistry.registerShorthand("minecraft:sponge", new ItemStack(Block.field_71945_L));
        DisplayRegistry.registerShorthand("piston", new ItemStack((Block)Block.field_71963_Z));
        DisplayRegistry.registerShorthand("reeds", new ItemStack(Item.field_77758_aJ));
        DisplayRegistry.registerMetaCycling(Item.field_77698_e[Block.field_72101_ab.field_71990_ca], "wool", new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15});
    }
}

