/*
 * Decompiled with CFR 0.152.
 */
package enchiridion;

import cpw.mods.fml.client.FMLClientHandler;
import enchiridion.CommonProxy;
import enchiridion.CustomBooks;
import enchiridion.Enchiridion;
import enchiridion.api.GuiGuide;
import enchiridion.api.GuideHandler;
import enchiridion.api.IBookReader;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.minecraft.item.ItemStack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ClientProxy
extends CommonProxy
implements IBookReader {
    private static DocumentBuilderFactory factory;
    public static final HashMap<String, Document> bookCache;

    @Override
    public void init() {
        CustomBooks.preInit();
    }

    @Override
    public void postInit() {
        factory = DocumentBuilderFactory.newInstance();
        for (Map.Entry<String, String> entry : GuideHandler.getGuides().entrySet()) {
            String guide = entry.getValue();
            if (!guide.contains(":")) continue;
            String[] arr = guide.split(":", -1);
            bookCache.put(guide, ClientProxy.initModGuide(arr[0], arr[1]));
        }
        for (Map.Entry<String, Object> entry : bookCache.entrySet()) {
            if (((Document)entry.getValue()).getElementsByTagName("info").getLength() > 0) {
                CustomBooks.setup(entry.getKey(), (Element)((Document)entry.getValue()).getElementsByTagName("info").item(0));
            }
            GuideHandler.registerModBook(new ItemStack(Enchiridion.items, 1, 0), entry.getKey());
            GuideHandler.registerBookReader(entry.getKey(), this);
        }
    }

    private static Document initModGuide(String mod, String book) {
        try {
            String lang = FMLClientHandler.instance().getCurrentLanguage();
            InputStream stream = Enchiridion.class.getResourceAsStream("/assets/" + mod + "/books/" + book + "_" + lang + ".xml");
            if (stream == null) {
                stream = Enchiridion.class.getResourceAsStream("/assets/" + mod + "/books/" + book + "_en_US.xml");
            }
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(stream);
            doc.getDocumentElement().normalize();
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Document getDocument(String xml) {
        return bookCache.get(xml);
    }

    @Override
    public Document getDocumentDebugMode(String xml) {
        if (xml.contains(":")) {
            String[] arr = xml.split(":", -1);
            return ClientProxy.initModGuide(arr[0], arr[1]);
        }
        return CustomBooks.getDebugMode(xml);
    }

    @Override
    public Object getGui(ItemStack stack, String key) {
        if (GuideHandler.getGuis().containsKey(key)) {
            return GuideHandler.getGuis().get(key);
        }
        if (stack.func_77942_o()) {
            String id = CustomBooks.getID(stack);
            CustomBooks.BookInfo info = CustomBooks.bookInfo.get(id);
            return new GuiGuide(info.bookColor, info.background, id);
        }
        return null;
    }

    static {
        bookCache = new HashMap();
    }
}

