/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import java.util.Random;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class BlockFluidClassic
extends BlockFluidBase {
    protected boolean[] isOptimalFlowDirection = new boolean[4];
    protected int[] flowCost = new int[4];
    protected FluidStack stack;

    public BlockFluidClassic(int id2, Fluid fluid, akc material) {
        super(id2, fluid, material);
        this.stack = new FluidStack(fluid, 1000);
    }

    public BlockFluidClassic setFluidStack(FluidStack stack) {
        this.stack = stack;
        return this;
    }

    public BlockFluidClassic setFluidStackAmount(int amount) {
        this.stack.amount = amount;
        return this;
    }

    @Override
    public int getQuantaValue(acf world, int x2, int y2, int z2) {
        if (world.a(x2, y2, z2) == 0) {
            return 0;
        }
        if (world.a(x2, y2, z2) != this.cF) {
            return -1;
        }
        int quantaRemaining = this.quantaPerBlock - world.h(x2, y2, z2);
        return quantaRemaining;
    }

    @Override
    public boolean a(int meta, boolean fullHit) {
        return fullHit && meta == 0;
    }

    @Override
    public int getMaxRenderHeightMeta() {
        return 0;
    }

    @Override
    public int getLightValue(acf world, int x2, int y2, int z2) {
        if (this.maxScaledLight == 0) {
            return super.getLightValue(world, x2, y2, z2);
        }
        int data = this.quantaPerBlock - world.h(x2, y2, z2) - 1;
        return (int)((float)data / this.quantaPerBlockFloat * (float)this.maxScaledLight);
    }

    @Override
    public void a(abw world, int x2, int y2, int z2, Random rand) {
        int quantaRemaining = this.quantaPerBlock - world.h(x2, y2, z2);
        int expQuanta = -101;
        if (quantaRemaining < this.quantaPerBlock) {
            int y22 = y2 - this.densityDir;
            if (world.a(x2, y22, z2) == this.cF || world.a(x2 - 1, y22, z2) == this.cF || world.a(x2 + 1, y22, z2) == this.cF || world.a(x2, y22, z2 - 1) == this.cF || world.a(x2, y22, z2 + 1) == this.cF) {
                expQuanta = this.quantaPerBlock - 1;
            } else {
                int maxQuanta = -100;
                maxQuanta = this.getLargerQuanta(world, x2 - 1, y2, z2, maxQuanta);
                maxQuanta = this.getLargerQuanta(world, x2 + 1, y2, z2, maxQuanta);
                maxQuanta = this.getLargerQuanta(world, x2, y2, z2 - 1, maxQuanta);
                maxQuanta = this.getLargerQuanta(world, x2, y2, z2 + 1, maxQuanta);
                expQuanta = maxQuanta - 1;
            }
            if (expQuanta != quantaRemaining) {
                quantaRemaining = expQuanta;
                if (expQuanta <= 0) {
                    world.i(x2, y2, z2);
                } else {
                    world.b(x2, y2, z2, this.quantaPerBlock - expQuanta, 3);
                    world.a(x2, y2, z2, this.cF, this.tickRate);
                    world.f(x2, y2, z2, this.cF);
                }
            }
        } else if (quantaRemaining >= this.quantaPerBlock) {
            world.b(x2, y2, z2, 0, 2);
        }
        if (this.canDisplace(world, x2, y2 + this.densityDir, z2)) {
            this.flowIntoBlock(world, x2, y2 + this.densityDir, z2, 1);
            return;
        }
        int flowMeta = this.quantaPerBlock - quantaRemaining + 1;
        if (flowMeta >= this.quantaPerBlock) {
            return;
        }
        if (this.isSourceBlock(world, x2, y2, z2) || !this.isFlowingVertically(world, x2, y2, z2)) {
            boolean[] flowTo;
            if (world.a(x2, y2 - this.densityDir, z2) == this.cF) {
                flowMeta = 1;
            }
            if ((flowTo = this.getOptimalFlowDirections(world, x2, y2, z2))[0]) {
                this.flowIntoBlock(world, x2 - 1, y2, z2, flowMeta);
            }
            if (flowTo[1]) {
                this.flowIntoBlock(world, x2 + 1, y2, z2, flowMeta);
            }
            if (flowTo[2]) {
                this.flowIntoBlock(world, x2, y2, z2 - 1, flowMeta);
            }
            if (flowTo[3]) {
                this.flowIntoBlock(world, x2, y2, z2 + 1, flowMeta);
            }
        }
    }

    public boolean isFlowingVertically(acf world, int x2, int y2, int z2) {
        return world.a(x2, y2 + this.densityDir, z2) == this.cF || world.a(x2, y2, z2) == this.cF && this.canFlowInto(world, x2, y2 + this.densityDir, z2);
    }

    public boolean isSourceBlock(acf world, int x2, int y2, int z2) {
        return world.a(x2, y2, z2) == this.cF && world.h(x2, y2, z2) == 0;
    }

    protected boolean[] getOptimalFlowDirections(abw world, int x2, int y2, int z2) {
        int side;
        for (int side2 = 0; side2 < 4; ++side2) {
            this.flowCost[side2] = 1000;
            int x22 = x2;
            int y22 = y2;
            int z22 = z2;
            switch (side2) {
                case 0: {
                    --x22;
                    break;
                }
                case 1: {
                    ++x22;
                    break;
                }
                case 2: {
                    --z22;
                    break;
                }
                case 3: {
                    ++z22;
                }
            }
            if (!this.canFlowInto(world, x22, y22, z22) || this.isSourceBlock(world, x22, y22, z22)) continue;
            this.flowCost[side2] = this.canFlowInto(world, x22, y22 + this.densityDir, z22) ? 0 : this.calculateFlowCost(world, x22, y22, z22, 1, side2);
        }
        int min = this.flowCost[0];
        for (side = 1; side < 4; ++side) {
            if (this.flowCost[side] >= min) continue;
            min = this.flowCost[side];
        }
        for (side = 0; side < 4; ++side) {
            this.isOptimalFlowDirection[side] = this.flowCost[side] == min;
        }
        return this.isOptimalFlowDirection;
    }

    protected int calculateFlowCost(abw world, int x2, int y2, int z2, int recurseDepth, int side) {
        int cost = 1000;
        for (int adjSide = 0; adjSide < 4; ++adjSide) {
            int min;
            if (adjSide == 0 && side == 1 || adjSide == 1 && side == 0 || adjSide == 2 && side == 3 || adjSide == 3 && side == 2) continue;
            int x22 = x2;
            int y22 = y2;
            int z22 = z2;
            switch (adjSide) {
                case 0: {
                    --x22;
                    break;
                }
                case 1: {
                    ++x22;
                    break;
                }
                case 2: {
                    --z22;
                    break;
                }
                case 3: {
                    ++z22;
                }
            }
            if (!this.canFlowInto(world, x22, y22, z22) || this.isSourceBlock(world, x22, y22, z22)) continue;
            if (this.canFlowInto(world, x22, y22 + this.densityDir, z22)) {
                return recurseDepth;
            }
            if (recurseDepth >= 4 || (min = this.calculateFlowCost(world, x22, y22, z22, recurseDepth + 1, adjSide)) >= cost) continue;
            cost = min;
        }
        return cost;
    }

    protected void flowIntoBlock(abw world, int x2, int y2, int z2, int meta) {
        if (meta < 0) {
            return;
        }
        if (this.displaceIfPossible(world, x2, y2, z2)) {
            world.f(x2, y2, z2, this.cF, meta, 3);
        }
    }

    protected boolean canFlowInto(acf world, int x2, int y2, int z2) {
        if (world.c(x2, y2, z2)) {
            return true;
        }
        int bId = world.a(x2, y2, z2);
        if (bId == this.cF) {
            return true;
        }
        if (this.displacementIds.containsKey(bId)) {
            return (Boolean)this.displacementIds.get(bId);
        }
        akc material = aqz.s[bId].cU;
        if (material.c() || material == akc.h || material == akc.i || material == akc.D) {
            return false;
        }
        int density = BlockFluidClassic.getDensity(world, x2, y2, z2);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    protected int getLargerQuanta(acf world, int x2, int y2, int z2, int compare) {
        int quantaRemaining = this.getQuantaValue(world, x2, y2, z2);
        if (quantaRemaining <= 0) {
            return compare;
        }
        return quantaRemaining >= compare ? quantaRemaining : compare;
    }

    @Override
    public FluidStack drain(abw world, int x2, int y2, int z2, boolean doDrain) {
        if (!this.isSourceBlock(world, x2, y2, z2)) {
            return null;
        }
        if (doDrain) {
            world.i(x2, y2, z2);
        }
        return this.stack.copy();
    }

    @Override
    public boolean canDrain(abw world, int x2, int y2, int z2) {
        return this.isSourceBlock(world, x2, y2, z2);
    }
}

