/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.io.Files;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.ItemData;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;

public class GameData {
    private static Map<Integer, ItemData> idMap = Maps.newHashMap();
    private static CountDownLatch serverValidationLatch;
    private static CountDownLatch clientValidationLatch;
    private static MapDifference<Integer, ItemData> difference;
    private static boolean shouldContinue;
    private static boolean isSaveValid;
    private static ImmutableTable<String, String, Integer> modObjectTable;
    private static Table<String, String, ye> customItemStacks;
    private static Map<String, String> ignoredMods;
    private static boolean validated;

    private static boolean isModIgnoredForIdValidation(String modId) {
        if (ignoredMods == null) {
            File f2 = new File(Loader.instance().getConfigDir(), "fmlIDChecking.properties");
            if (f2.exists()) {
                Properties p2 = new Properties();
                try {
                    p2.load(new FileInputStream(f2));
                    ignoredMods = Maps.fromProperties(p2);
                    if (ignoredMods.size() > 0) {
                        FMLLog.log("fml.ItemTracker", Level.WARNING, "Using non-empty ignored mods configuration file %s", ignoredMods.keySet());
                    }
                }
                catch (Exception e2) {
                    Throwables.propagateIfPossible(e2);
                    FMLLog.log("fml.ItemTracker", Level.SEVERE, e2, "Failed to read ignored ID checker mods properties file", new Object[0]);
                    ignoredMods = ImmutableMap.of();
                }
            } else {
                ignoredMods = ImmutableMap.of();
            }
        }
        return ignoredMods.containsKey(modId);
    }

    public static void newItemAdded(yc item) {
        ModContainer mc = Loader.instance().activeModContainer();
        if (mc == null) {
            mc = Loader.instance().getMinecraftModContainer();
            if (Loader.instance().hasReachedState(LoaderState.INITIALIZATION) || validated) {
                FMLLog.severe("It appears something has tried to allocate an Item or Block outside of the preinitialization phase for mods. This will NOT work in 1.7 and beyond!", new Object[0]);
            }
        }
        String itemType = item.getClass().getName();
        ItemData itemData = new ItemData(item, mc);
        if (idMap.containsKey(item.cv)) {
            ItemData id2 = idMap.get(item.cv);
            FMLLog.log("fml.ItemTracker", Level.INFO, "The mod %s is overwriting existing item at %d (%s from %s) with %s", mc.getModId(), id2.getItemId(), id2.getItemType(), id2.getModId(), itemType);
        }
        idMap.put(item.cv, itemData);
        if (!"Minecraft".equals(mc.getModId())) {
            FMLLog.log("fml.ItemTracker", Level.FINE, "Adding item %s(%d) owned by %s", item.getClass().getName(), item.cv, mc.getModId());
        }
    }

    public static void validateWorldSave(Set<ItemData> worldSaveItems) {
        isSaveValid = true;
        shouldContinue = true;
        if (worldSaveItems == null) {
            serverValidationLatch.countDown();
            try {
                clientValidationLatch.await();
            }
            catch (InterruptedException e2) {
                // empty catch block
            }
            return;
        }
        Function<ItemData, Integer> idMapFunction = new Function<ItemData, Integer>(){

            @Override
            public Integer apply(ItemData input) {
                return input.getItemId();
            }
        };
        ImmutableMap<Integer, ItemData> worldMap = Maps.uniqueIndex(worldSaveItems, idMapFunction);
        difference = Maps.difference(worldMap, idMap);
        FMLLog.log("fml.ItemTracker", Level.FINE, "The difference set is %s", difference);
        if (!difference.entriesDiffering().isEmpty() || !difference.entriesOnlyOnLeft().isEmpty()) {
            FMLLog.log("fml.ItemTracker", Level.SEVERE, "FML has detected item discrepancies", new Object[0]);
            FMLLog.log("fml.ItemTracker", Level.SEVERE, "Missing items : %s", difference.entriesOnlyOnLeft());
            FMLLog.log("fml.ItemTracker", Level.SEVERE, "Mismatched items : %s", difference.entriesDiffering());
            boolean foundNonIgnored = false;
            for (ItemData itemData : difference.entriesOnlyOnLeft().values()) {
                if (GameData.isModIgnoredForIdValidation(itemData.getModId())) continue;
                foundNonIgnored = true;
            }
            for (MapDifference.ValueDifference valueDifference : difference.entriesDiffering().values()) {
                if (GameData.isModIgnoredForIdValidation(((ItemData)valueDifference.leftValue()).getModId()) || GameData.isModIgnoredForIdValidation(((ItemData)valueDifference.rightValue()).getModId())) continue;
                foundNonIgnored = true;
            }
            if (!foundNonIgnored) {
                FMLLog.log("fml.ItemTracker", Level.SEVERE, "FML is ignoring these ID discrepancies because of configuration. YOUR GAME WILL NOW PROBABLY CRASH. HOPEFULLY YOU WON'T HAVE CORRUPTED YOUR WORLD. BLAME %s", ignoredMods.keySet());
            }
            isSaveValid = !foundNonIgnored;
            serverValidationLatch.countDown();
        } else {
            isSaveValid = true;
            serverValidationLatch.countDown();
        }
        try {
            clientValidationLatch.await();
            if (!shouldContinue) {
                throw new RuntimeException("This server instance is going to stop abnormally because of a fatal ID mismatch");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void writeItemData(cg itemList) {
        for (ItemData dat : idMap.values()) {
            itemList.a(dat.toNBT());
        }
    }

    public static void initializeServerGate(int gateCount) {
        serverValidationLatch = new CountDownLatch(gateCount - 1);
        clientValidationLatch = new CountDownLatch(gateCount - 1);
    }

    public static MapDifference<Integer, ItemData> gateWorldLoadingForValidation() {
        try {
            serverValidationLatch.await();
            if (!isSaveValid) {
                return difference;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        difference = null;
        return null;
    }

    public static void releaseGate(boolean carryOn) {
        shouldContinue = carryOn;
        clientValidationLatch.countDown();
    }

    public static Set<ItemData> buildWorldItemData(cg modList) {
        HashSet<ItemData> worldSaveItems = Sets.newHashSet();
        for (int i2 = 0; i2 < modList.c(); ++i2) {
            by mod = (by)modList.b(i2);
            ItemData dat = new ItemData(mod);
            worldSaveItems.add(dat);
        }
        return worldSaveItems;
    }

    static void setName(yc item, String name, String modId) {
        int id2 = item.cv;
        ItemData itemData = idMap.get(id2);
        itemData.setName(name, modId);
    }

    public static void buildModObjectTable() {
        if (modObjectTable != null) {
            throw new IllegalStateException("Illegal call to buildModObjectTable!");
        }
        Map<Integer, Table.Cell<String, String, Integer>> map = Maps.transformValues(idMap, new Function<ItemData, Table.Cell<String, String, Integer>>(){

            @Override
            public Table.Cell<String, String, Integer> apply(ItemData data) {
                if ("Minecraft".equals(data.getModId()) || !data.isOveridden()) {
                    return null;
                }
                return Tables.immutableCell(data.getModId(), data.getItemType(), data.getItemId());
            }
        });
        ImmutableTable.Builder<String, String, Integer> tBuilder = ImmutableTable.builder();
        for (Table.Cell<String, String, Integer> c2 : map.values()) {
            if (c2 == null) continue;
            tBuilder.put(c2);
        }
        modObjectTable = tBuilder.build();
    }

    static yc findItem(String modId, String name) {
        if (modObjectTable == null || !modObjectTable.contains(modId, name)) {
            return null;
        }
        return yc.g[(Integer)modObjectTable.get(modId, name)];
    }

    static aqz findBlock(String modId, String name) {
        if (modObjectTable == null) {
            return null;
        }
        Integer blockId = (Integer)modObjectTable.get(modId, name);
        if (blockId == null || blockId >= aqz.s.length) {
            return null;
        }
        return aqz.s[blockId];
    }

    static ye findItemStack(String modId, String name) {
        aqz b2;
        yc i2;
        ye is2 = customItemStacks.get(modId, name);
        if (is2 == null && (i2 = GameData.findItem(modId, name)) != null) {
            is2 = new ye(i2, 0, 0);
        }
        if (is2 == null && (b2 = GameData.findBlock(modId, name)) != null) {
            is2 = new ye(b2, 0, Short.MAX_VALUE);
        }
        return is2;
    }

    static void registerCustomItemStack(String name, ye itemStack) {
        customItemStacks.put(Loader.instance().activeModContainer().getModId(), name, itemStack);
    }

    public static void dumpRegistry(File minecraftDir) {
        if (customItemStacks == null) {
            return;
        }
        if (Boolean.valueOf(System.getProperty("fml.dumpRegistry", "false")).booleanValue()) {
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            for (String modId : customItemStacks.rowKeySet()) {
                builder.putAll((Object)modId, customItemStacks.row(modId).keySet());
            }
            File f2 = new File(minecraftDir, "itemStackRegistry.csv");
            Joiner.MapJoiner mapJoiner = Joiner.on("\n").withKeyValueSeparator(",");
            try {
                Files.write(mapJoiner.join(builder.build().entries()), f2, Charsets.UTF_8);
                FMLLog.log(Level.INFO, "Dumped item registry data to %s", f2.getAbsolutePath());
            }
            catch (IOException e2) {
                FMLLog.log(Level.SEVERE, e2, "Failed to write registry data to %s", f2.getAbsolutePath());
            }
        }
    }

    static GameRegistry.UniqueIdentifier getUniqueName(aqz block) {
        if (block == null) {
            return null;
        }
        ItemData itemData = idMap.get(block.cF);
        if (itemData == null || !itemData.isOveridden() || customItemStacks.contains(itemData.getModId(), itemData.getItemType())) {
            return null;
        }
        return new GameRegistry.UniqueIdentifier(itemData.getModId(), itemData.getItemType());
    }

    static GameRegistry.UniqueIdentifier getUniqueName(yc item) {
        if (item == null) {
            return null;
        }
        ItemData itemData = idMap.get(item.cv);
        if (itemData == null || !itemData.isOveridden() || customItemStacks.contains(itemData.getModId(), itemData.getItemType())) {
            return null;
        }
        return new GameRegistry.UniqueIdentifier(itemData.getModId(), itemData.getItemType());
    }

    public static void validateRegistry() {
        for (int i2 = 0; i2 < yc.g.length; ++i2) {
            if (yc.g[i2] == null) continue;
            ItemData itemData = idMap.get(i2);
            if (itemData == null) {
                FMLLog.severe("Found completely unknown item of class %s with ID %d, this will NOT work for a 1.7 upgrade", yc.g[i2].getClass().getName(), i2);
                continue;
            }
            if (itemData.isOveridden() || "Minecraft".equals(itemData.getModId())) continue;
            FMLLog.severe("Found anonymous item of class %s with ID %d owned by mod %s, this item will NOT survive a 1.7 upgrade!", yc.g[i2].getClass().getName(), i2, itemData.getModId());
        }
        validated = true;
    }

    static {
        shouldContinue = true;
        isSaveValid = true;
        customItemStacks = HashBasedTable.create();
    }
}

