/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.network.FMLNetworkHandler;
import cpw.mods.fml.common.network.FMLPacket;
import cpw.mods.fml.common.network.IChatListener;
import cpw.mods.fml.common.network.IConnectionHandler;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.NetworkModHandler;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.minecraft.server.MinecraftServer;

public class NetworkRegistry {
    private static final NetworkRegistry INSTANCE = new NetworkRegistry();
    private Multimap<Player, String> activeChannels = ArrayListMultimap.create();
    private Multimap<String, IPacketHandler> universalPacketHandlers = ArrayListMultimap.create();
    private Multimap<String, IPacketHandler> clientPacketHandlers = ArrayListMultimap.create();
    private Multimap<String, IPacketHandler> serverPacketHandlers = ArrayListMultimap.create();
    private Set<IConnectionHandler> connectionHandlers = Sets.newLinkedHashSet();
    private Map<ModContainer, IGuiHandler> serverGuiHandlers = Maps.newHashMap();
    private Map<ModContainer, IGuiHandler> clientGuiHandlers = Maps.newHashMap();
    private List<IChatListener> chatListeners = Lists.newArrayList();

    public static NetworkRegistry instance() {
        return INSTANCE;
    }

    byte[] getPacketRegistry(Side side) {
        return Joiner.on('\u0000').join(Iterables.concat(Arrays.asList("FML"), this.universalPacketHandlers.keySet(), side.isClient() ? this.clientPacketHandlers.keySet() : this.serverPacketHandlers.keySet())).getBytes(Charsets.UTF_8);
    }

    public boolean isChannelActive(String channel, Player player) {
        return this.activeChannels.containsEntry(player, channel);
    }

    public void registerChannel(IPacketHandler handler, String channelName) {
        if (Strings.isNullOrEmpty(channelName) || channelName != null && channelName.length() > 16) {
            FMLLog.severe("Invalid channel name '%s' : %s", channelName, Strings.isNullOrEmpty(channelName) ? "Channel name is empty" : "Channel name is too long (16 chars is maximum)");
            throw new RuntimeException("Channel name is invalid");
        }
        this.universalPacketHandlers.put(channelName, handler);
    }

    public void registerChannel(IPacketHandler handler, String channelName, Side side) {
        if (side == null) {
            this.registerChannel(handler, channelName);
            return;
        }
        if (Strings.isNullOrEmpty(channelName) || channelName != null && channelName.length() > 16) {
            FMLLog.severe("Invalid channel name '%s' : %s", channelName, Strings.isNullOrEmpty(channelName) ? "Channel name is empty" : "Channel name is too long (16 chars is maximum)");
            throw new RuntimeException("Channel name is invalid");
        }
        if (side.isClient()) {
            this.clientPacketHandlers.put(channelName, handler);
        } else {
            this.serverPacketHandlers.put(channelName, handler);
        }
    }

    void activateChannel(Player player, String channel) {
        this.activeChannels.put(player, channel);
    }

    void deactivateChannel(Player player, String channel) {
        this.activeChannels.remove(player, channel);
    }

    public void registerConnectionHandler(IConnectionHandler handler) {
        this.connectionHandlers.add(handler);
    }

    public void registerChatListener(IChatListener listener) {
        this.chatListeners.add(listener);
    }

    void playerLoggedIn(jv player, ka netHandler, cm manager) {
        this.generateChannelRegistration(player, netHandler, manager);
        for (IConnectionHandler handler : this.connectionHandlers) {
            handler.playerLoggedIn((Player)((Object)player), netHandler, manager);
        }
    }

    String connectionReceived(jy netHandler, cm manager) {
        for (IConnectionHandler handler : this.connectionHandlers) {
            String kick = handler.connectionReceived(netHandler, manager);
            if (Strings.isNullOrEmpty(kick)) continue;
            return kick;
        }
        return null;
    }

    void connectionOpened(ez netClientHandler, String server, int port, cm networkManager) {
        for (IConnectionHandler handler : this.connectionHandlers) {
            handler.connectionOpened(netClientHandler, server, port, networkManager);
        }
    }

    void connectionOpened(ez netClientHandler, MinecraftServer server, cm networkManager) {
        for (IConnectionHandler handler : this.connectionHandlers) {
            handler.connectionOpened(netClientHandler, server, networkManager);
        }
    }

    void clientLoggedIn(ez clientHandler, cm manager, ep login) {
        this.generateChannelRegistration(clientHandler.getPlayer(), clientHandler, manager);
        for (IConnectionHandler handler : this.connectionHandlers) {
            handler.clientLoggedIn(clientHandler, manager, login);
        }
    }

    void connectionClosed(cm manager, uf player) {
        for (IConnectionHandler handler : this.connectionHandlers) {
            handler.connectionClosed(manager);
        }
        this.activeChannels.removeAll(player);
    }

    void generateChannelRegistration(uf player, ez netHandler, cm manager) {
        ea pkt = new ea();
        pkt.a = "REGISTER";
        pkt.c = this.getPacketRegistry(player instanceof jv ? Side.SERVER : Side.CLIENT);
        pkt.b = pkt.c.length;
        manager.a(pkt);
    }

    void handleCustomPacket(ea packet, cm network, ez handler) {
        if ("REGISTER".equals(packet.a)) {
            this.handleRegistrationPacket(packet, (Player)((Object)handler.getPlayer()));
        } else if ("UNREGISTER".equals(packet.a)) {
            this.handleUnregistrationPacket(packet, (Player)((Object)handler.getPlayer()));
        } else {
            this.handlePacket(packet, network, (Player)((Object)handler.getPlayer()));
        }
    }

    private void handlePacket(ea packet, cm network, Player player) {
        String channel = packet.a;
        for (IPacketHandler handler : Iterables.concat(this.universalPacketHandlers.get(channel), player instanceof jv ? this.serverPacketHandlers.get(channel) : this.clientPacketHandlers.get(channel))) {
            handler.onPacketData(network, packet, player);
        }
    }

    private void handleRegistrationPacket(ea packet, Player player) {
        List<String> channels = this.extractChannelList(packet);
        for (String channel : channels) {
            this.activateChannel(player, channel);
        }
    }

    private void handleUnregistrationPacket(ea packet, Player player) {
        List<String> channels = this.extractChannelList(packet);
        for (String channel : channels) {
            this.deactivateChannel(player, channel);
        }
    }

    private List<String> extractChannelList(ea packet) {
        String request = new String(packet.c, Charsets.UTF_8);
        ArrayList<String> channels = Lists.newArrayList(Splitter.on('\u0000').split(request));
        return channels;
    }

    public void registerGuiHandler(Object mod, IGuiHandler handler) {
        NetworkModHandler nmh;
        ModContainer mc = FMLCommonHandler.instance().findContainerFor(mod);
        if (mc == null) {
            mc = Loader.instance().activeModContainer();
            FMLLog.log(Level.WARNING, "Mod %s attempted to register a gui network handler during a construction phase", mc.getModId());
        }
        if ((nmh = FMLNetworkHandler.instance().findNetworkModHandler(mc)) == null) {
            FMLLog.log(Level.FINE, "The mod %s needs to be a @NetworkMod to register a Networked Gui Handler", mc.getModId());
        } else {
            this.serverGuiHandlers.put(mc, handler);
        }
        this.clientGuiHandlers.put(mc, handler);
    }

    void openRemoteGui(ModContainer mc, jv player, int modGuiId, abw world, int x, int y2, int z2) {
        uy container;
        IGuiHandler handler = this.serverGuiHandlers.get(mc);
        NetworkModHandler nmh = FMLNetworkHandler.instance().findNetworkModHandler(mc);
        if (handler != null && nmh != null && (container = (uy)handler.getServerGuiElement(modGuiId, player, world, x, y2, z2)) != null) {
            player.bN();
            player.k();
            int windowId = player.bY;
            ea pkt = new ea();
            pkt.a = "FML";
            pkt.c = FMLPacket.makePacket(FMLPacket.Type.GUIOPEN, windowId, nmh.getNetworkId(), modGuiId, x, y2, z2);
            pkt.b = pkt.c.length;
            player.a.b(pkt);
            player.bp = container;
            player.bp.d = windowId;
            player.bp.a(player);
        }
    }

    void openLocalGui(ModContainer mc, uf player, int modGuiId, abw world, int x, int y2, int z2) {
        IGuiHandler handler = this.clientGuiHandlers.get(mc);
        FMLCommonHandler.instance().showGuiScreen(handler.getClientGuiElement(modGuiId, player, world, x, y2, z2));
    }

    public dm handleChat(ez handler, dm chat) {
        Side s2 = Side.CLIENT;
        if (handler instanceof ka) {
            s2 = Side.SERVER;
        }
        for (IChatListener listener : this.chatListeners) {
            chat = s2.isClient() ? listener.clientChat(handler, chat) : listener.serverChat(handler, chat);
        }
        return chat;
    }

    public void handleTinyPacket(ez handler, dr mapData) {
        NetworkModHandler nmh = FMLNetworkHandler.instance().findNetworkModHandler(mapData.a);
        if (nmh == null) {
            FMLLog.info("Received a tiny packet for network id %d that is not recognised here", mapData.a);
            return;
        }
        if (nmh.hasTinyPacketHandler()) {
            nmh.getTinyPacketHandler().handle(handler, mapData);
        } else {
            FMLLog.info("Received a tiny packet for a network mod that does not accept tiny packets %s", nmh.getContainer().getModId());
        }
    }
}

