/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.asm.transformers.AccessTransformer;
import cpw.mods.fml.common.asm.transformers.ModAPITransformer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.modloader.BaseModProxy;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class ModClassLoader
extends URLClassLoader {
    private static final List<String> STANDARD_LIBRARIES = ImmutableList.of("jinput.jar", "lwjgl.jar", "lwjgl_util.jar");
    private LaunchClassLoader mainClassLoader;

    public ModClassLoader(ClassLoader parent) {
        super(new URL[0], (ClassLoader)null);
        this.mainClassLoader = (LaunchClassLoader)parent;
    }

    public void addFile(File modFile) throws MalformedURLException {
        URL url = modFile.toURI().toURL();
        this.mainClassLoader.addURL(url);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.mainClassLoader.loadClass(name);
    }

    public File[] getParentSources() {
        List urls = this.mainClassLoader.getSources();
        File[] sources = new File[urls.size()];
        try {
            for (int i2 = 0; i2 < urls.size(); ++i2) {
                sources[i2] = new File(((URL)urls.get(i2)).toURI());
            }
            return sources;
        }
        catch (URISyntaxException e2) {
            FMLLog.log(Level.SEVERE, e2, "Unable to process our input to locate the minecraft code", new Object[0]);
            throw new LoaderException(e2);
        }
    }

    public List<String> getDefaultLibraries() {
        return STANDARD_LIBRARIES;
    }

    public Class<? extends BaseModProxy> loadBaseModClass(String modClazzName) throws Exception {
        AccessTransformer accessTransformer = null;
        for (IClassTransformer transformer : this.mainClassLoader.getTransformers()) {
            if (!(transformer instanceof AccessTransformer)) continue;
            accessTransformer = (AccessTransformer)transformer;
            break;
        }
        if (accessTransformer == null) {
            FMLLog.log(Level.SEVERE, "No access transformer found", new Object[0]);
            throw new LoaderException();
        }
        accessTransformer.ensurePublicAccessFor(modClazzName);
        return Class.forName(modClazzName, true, this);
    }

    public void clearNegativeCacheFor(Set<String> classList) {
        this.mainClassLoader.clearNegativeEntries(classList);
    }

    public ModAPITransformer addModAPITransformer(ASMDataTable dataTable) {
        this.mainClassLoader.registerTransformer("cpw.mods.fml.common.asm.transformers.ModAPITransformer");
        List transformers = this.mainClassLoader.getTransformers();
        ModAPITransformer modAPI = (ModAPITransformer)transformers.get(transformers.size() - 1);
        modAPI.initTable(dataTable);
        return modAPI;
    }
}

