/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.gui;

import codechicken.lib.math.MathHelper;
import codechicken.lib.render.CCRenderState;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Arrays;
import java.util.List;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiDraw {
    public static final GuiHook gui = new GuiHook();
    public static avi fontRenderer = atv.w().l;
    public static bim renderEngine = atv.w().N;

    public static void drawRect(int x, int y, int w, int h, int colour) {
        GuiDraw.drawGradientRect(x, y, w, h, colour, colour);
    }

    public static void drawGradientRect(int x, int y, int w, int h, int colour1, int colour2) {
        gui.a(x, y, x + w, y + h, colour1, colour2);
    }

    public static void drawTexturedModalRect(int x, int y, int tx, int ty, int w, int h) {
        gui.b(x, y, tx, ty, w, h);
    }

    public static void drawString(String text, int x, int y, int colour, boolean shadow) {
        if (shadow) {
            fontRenderer.a(text, x, y, colour);
        } else {
            fontRenderer.b(text, x, y, colour);
        }
    }

    public static void drawString(String text, int x, int y, int colour) {
        GuiDraw.drawString(text, x, y, colour, true);
    }

    public static void drawStringC(String text, int x, int y, int w, int h, int colour, boolean shadow) {
        GuiDraw.drawString(text, x + (w - GuiDraw.getStringWidth(text)) / 2, y + (h - 8) / 2, colour, shadow);
    }

    public static void drawStringC(String text, int x, int y, int w, int h, int colour) {
        GuiDraw.drawStringC(text, x, y, w, h, colour, true);
    }

    public static void drawStringC(String text, int x, int y, int colour, boolean shadow) {
        GuiDraw.drawString(text, x - GuiDraw.getStringWidth(text) / 2, y, colour, shadow);
    }

    public static void drawStringC(String text, int x, int y, int colour) {
        GuiDraw.drawStringC(text, x, y, colour, true);
    }

    public static void drawStringR(String text, int x, int y, int colour, boolean shadow) {
        GuiDraw.drawString(text, x - GuiDraw.getStringWidth(text), y, colour, shadow);
    }

    public static void drawStringR(String text, int x, int y, int colour) {
        GuiDraw.drawStringR(text, x, y, colour, true);
    }

    public static int getStringWidth(String s) {
        if (s == null || s.equals("")) {
            return 0;
        }
        return GuiDraw.getStringWidthNoColours(fontRenderer, s);
    }

    public static int getStringWidthNoColours(avi fontRenderer, String s) {
        int pos;
        while ((pos = s.indexOf(167)) != -1) {
            s = s.substring(0, pos) + s.substring(pos + 2);
        }
        return fontRenderer.a(s);
    }

    public static Dimension displaySize() {
        atv mc = atv.w();
        awf res = new awf(mc.u, mc.d, mc.e);
        return new Dimension(res.a(), res.b());
    }

    public static Dimension displayRes() {
        atv mc = atv.w();
        return new Dimension(mc.d, mc.e);
    }

    public static Point getMousePosition() {
        Dimension size = GuiDraw.displaySize();
        Dimension res = GuiDraw.displayRes();
        return new Point(Mouse.getX() * size.width / res.width, size.height - Mouse.getY() * size.height / res.height - 1);
    }

    public static void changeTexture(String s) {
        CCRenderState.changeTexture((String)s);
    }

    public static void changeTexture(bjo r) {
        CCRenderState.changeTexture((bjo)r);
    }

    public static void drawTip(int x, int y, String text) {
        GuiDraw.drawMultilineTip(x, y, Arrays.asList(text));
    }

    public static void drawMultilineTip(int x, int y, List<String> list) {
        if (list.isEmpty()) {
            return;
        }
        GL11.glDisable((int)32826);
        att.a();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        int w = 0;
        for (String s : list) {
            int swidth = GuiDraw.getStringWidthNoColours(fontRenderer, s);
            if (swidth <= w) continue;
            w = swidth;
        }
        int h = -2;
        for (int i = 0; i < list.size(); ++i) {
            h += list.get(i).endsWith("\u00a7h") && i + 1 < list.size() ? 12 : 10;
        }
        if (x < 8) {
            x = 8;
        } else if (x > GuiDraw.displaySize().width - w - 8) {
            x -= 24 + w;
        }
        y = (int)MathHelper.clip((double)y, (double)8.0, (double)(GuiDraw.displaySize().height - 8 - h));
        gui.incZLevel(300.0f);
        GuiDraw.drawTooltipBox(x - 4, y - 4, w + 7, h + 7);
        for (String s : list) {
            fontRenderer.a(s, x, y, -1);
            if (s.endsWith("\u00a7h")) {
                y += 2;
            }
            y += 10;
        }
        gui.incZLevel(-300.0f);
    }

    public static void drawTooltipBox(int x, int y, int w, int h) {
        int bg = -267386864;
        GuiDraw.drawGradientRect(x + 1, y, w - 1, 1, bg, bg);
        GuiDraw.drawGradientRect(x + 1, y + h, w - 1, 1, bg, bg);
        GuiDraw.drawGradientRect(x + 1, y + 1, w - 1, h - 1, bg, bg);
        GuiDraw.drawGradientRect(x, y + 1, 1, h - 1, bg, bg);
        GuiDraw.drawGradientRect(x + w, y + 1, 1, h - 1, bg, bg);
        int grad1 = 0x505000FF;
        int grad2 = 1344798847;
        GuiDraw.drawGradientRect(x + 1, y + 2, 1, h - 3, grad1, grad2);
        GuiDraw.drawGradientRect(x + w - 1, y + 2, 1, h - 3, grad1, grad2);
        GuiDraw.drawGradientRect(x + 1, y + 1, w - 1, 1, grad1, grad1);
        GuiDraw.drawGradientRect(x + 1, y + h - 1, w - 1, 1, grad2, grad2);
    }

    public static class GuiHook
    extends avk {
        public void setZLevel(float f) {
            this.n = f;
        }

        public float getZLevel() {
            return this.n;
        }

        public void incZLevel(float f) {
            this.n += f;
        }

        public void a(int par1, int par2, int par3, int par4, int par5, int par6) {
            super.a(par1, par2, par3, par4, par5, par6);
        }
    }
}

