/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.asm;

import codechicken.core.asm.CodeChickenCoreModContainer;
import codechicken.core.launch.CodeChickenCorePlugin;
import codechicken.lib.asm.ASMHelper;
import codechicken.lib.asm.CC_ClassWriter;
import codechicken.lib.asm.ObfMapping;
import codechicken.lib.config.ConfigFile;
import codechicken.lib.config.ConfigTag;
import codechicken.obfuscator.IHeirachyEvaluator;
import codechicken.obfuscator.ObfuscationMap;
import codechicken.obfuscator.ObfuscationRun;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.asm.transformers.AccessTransformer;
import cpw.mods.fml.common.asm.transformers.DeobfuscationTransformer;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class MCPDeobfuscationTransformer
implements IClassTransformer,
Opcodes,
IHeirachyEvaluator {
    private static ObfuscationRun run;
    private static List<String> excludedPackages;
    private static MCPDeobfuscationTransformer instance;
    private static boolean activated;
    private static Field f_transformers;
    private static Field f_modifiers;
    private static Field f_Modifier_name;
    private static Field f_Modifier_desc;

    private static Object get(Field f, Object inst) {
        try {
            return f.get(inst);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void set(Field f, Object inst, Object value) {
        try {
            f.set(inst, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static List<IClassTransformer> getTransformers() {
        return (List)MCPDeobfuscationTransformer.get(f_transformers, CodeChickenCorePlugin.cl);
    }

    public static void load() {
        ConfigFile config = CodeChickenCoreModContainer.config;
        File mcDir = CodeChickenCorePlugin.minecraftDir;
        if (config.getTag("dev.deobfuscate").setComment("set to true to completely deobfuscate mcp names").getBooleanValue(!ObfMapping.obfuscated)) {
            run = new ObfuscationRun(false, MCPDeobfuscationTransformer.getConfFiles(mcDir, config), ObfuscationRun.fillDefaults(new HashMap<String, String>()));
            MCPDeobfuscationTransformer.run.obf.setHeirachyEvaluator(instance);
            run.setQuiet().parseMappings();
            for (String pkg : MCPDeobfuscationTransformer.run.config.get("excludedPackages").split(";")) {
                excludedPackages.add(pkg);
            }
            ObfMapping.runtimeMapper = MCPDeobfuscationTransformer.run.obfMapper;
            if (ObfMapping.obfuscated) {
                run.setSeargeConstants();
                MCPDeobfuscationTransformer.getTransformers().add(instance);
            } else {
                ObfMapping.mcpMapper = MCPDeobfuscationTransformer.run.obfMapper;
                MCPDeobfuscationTransformer.getTransformers().add(0, instance);
            }
        }
    }

    private static File confDirectoryGuess(int i, File mcDir, ConfigTag tag) {
        switch (i) {
            case 0: {
                return tag.value != null ? new File(tag.getValue()) : null;
            }
            case 1: {
                return new File(mcDir, "../conf");
            }
            case 2: {
                return new File(mcDir, "../build/unpacked");
            }
        }
        JFileChooser fc = new JFileChooser(mcDir);
        fc.setFileSelectionMode(1);
        fc.setDialogTitle("Select an mcp conf dir for the deobfuscator.");
        int ret = fc.showDialog(null, "Select");
        return ret == 0 ? fc.getSelectedFile() : null;
    }

    private static File[] getConfFiles(File mcDir, ConfigFile config) {
        ConfigTag tag = config.getTag("dev.mappingDir");
        for (int i = 0; i < 6; ++i) {
            File[] mappings;
            File dir = MCPDeobfuscationTransformer.confDirectoryGuess(i, mcDir, tag);
            if (dir == null || dir.isFile()) continue;
            try {
                mappings = ObfuscationRun.parseConfDir(dir);
            }
            catch (Exception e) {
                if (i < 3) continue;
                e.printStackTrace();
                continue;
            }
            tag.setValue(dir.getPath());
            return mappings;
        }
        throw new RuntimeException("Failed to select mappings directory, set it manually in the config");
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (name.equals("cpw.mods.fml.common.Loader")) {
            bytes = this.injectCallback(bytes);
            activated = true;
        }
        if (!activated || bytes == null) {
            return bytes;
        }
        ClassNode cnode = ASMHelper.createClassNode((byte[])bytes, (int)8);
        CC_ClassWriter cw = new CC_ClassWriter(0, true);
        run.remap(cnode, (ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] injectCallback(byte[] bytes) {
        ClassNode cnode = ASMHelper.createClassNode((byte[])bytes);
        MethodNode mnode = ASMHelper.findMethod((ObfMapping)new ObfMapping(cnode.name, "<clinit>", "()V"), (ClassNode)cnode);
        mnode.instructions.insert((AbstractInsnNode)new MethodInsnNode(184, "codechicken/core/asm/MCPDeobfuscationTransformer", "loadCallback", "()V"));
        return ASMHelper.createBytes((ClassNode)cnode, (int)0);
    }

    public static void loadCallback() {
        if (ObfMapping.obfuscated) {
            List<IClassTransformer> transformers = MCPDeobfuscationTransformer.getTransformers();
            Iterator<IClassTransformer> iterator = transformers.iterator();
            while (iterator.hasNext()) {
                IClassTransformer t = iterator.next();
                if (t != instance && !(t instanceof DeobfuscationTransformer)) continue;
                iterator.remove();
            }
            transformers.add(instance);
        } else {
            for (IClassTransformer t : MCPDeobfuscationTransformer.getTransformers()) {
                if (!(t instanceof AccessTransformer)) continue;
                MCPDeobfuscationTransformer.remapAccessTransformer(t);
            }
        }
    }

    private static void remapAccessTransformer(IClassTransformer t) {
        Multimap modifiers = (Multimap)MCPDeobfuscationTransformer.get(f_modifiers, t);
        HashMultimap t_modifiers = HashMultimap.create();
        for (Map.Entry entry : modifiers.entries()) {
            ObfMapping map;
            Object mod = entry.getValue();
            String m_owner = ((String)entry.getKey()).replace('.', '/');
            String m_name = (String)MCPDeobfuscationTransformer.get(f_Modifier_name, mod);
            String m_desc = (String)MCPDeobfuscationTransformer.get(f_Modifier_desc, mod);
            if (m_name.equals("*")) {
                map = new ObfMapping(m_owner);
                map.s_name = m_name;
                map.s_desc = m_desc;
            } else {
                map = new ObfMapping(m_owner, m_name, m_desc);
            }
            MCPDeobfuscationTransformer.set(f_Modifier_name, mod, map.s_name);
            MCPDeobfuscationTransformer.set(f_Modifier_desc, mod, map.s_desc);
            t_modifiers.put((Object)map.javaClass(), mod);
        }
        MCPDeobfuscationTransformer.set(f_modifiers, t, t_modifiers);
    }

    @Override
    public List<String> getParents(ObfuscationMap.ObfuscationEntry desc) {
        try {
            String name = ObfMapping.obfuscated ? desc.obf.s_owner : desc.mcp.s_owner;
            name = name.replace('/', '.');
            byte[] bytes = CodeChickenCorePlugin.cl.getClassBytes(name);
            if (bytes != null) {
                return ObfuscationRun.getParents(ASMHelper.createClassNode((byte[])bytes));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean isLibClass(ObfuscationMap.ObfuscationEntry desc) {
        String name = desc.srg.s_owner;
        for (String p : excludedPackages) {
            if (!name.startsWith(p)) continue;
            return true;
        }
        return false;
    }

    public static String unmap(String name) {
        if (run == null) {
            return null;
        }
        ObfuscationMap.ObfuscationEntry e = MCPDeobfuscationTransformer.run.obf.lookupMcpClass(name);
        if (e == null) {
            return null;
        }
        return e.obf.s_owner;
    }

    public static MCPDeobfuscationTransformer instance() {
        return instance;
    }

    static {
        excludedPackages = new LinkedList<String>();
        instance = new MCPDeobfuscationTransformer();
        try {
            f_transformers = LaunchClassLoader.class.getDeclaredField("transformers");
            f_modifiers = AccessTransformer.class.getDeclaredField("modifiers");
            Class<?> c_Modifier = Class.forName(AccessTransformer.class.getName() + "$Modifier", false, (ClassLoader)CodeChickenCorePlugin.cl);
            f_Modifier_name = c_Modifier.getDeclaredField("name");
            f_Modifier_desc = c_Modifier.getDeclaredField("desc");
            f_transformers.setAccessible(true);
            f_modifiers.setAccessible(true);
            f_Modifier_name.setAccessible(true);
            f_Modifier_desc.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

