/*
 * Decompiled with CFR 0.152.
 */
package cofh.util;

import cofh.CoFHCore;
import cofh.entity.EntityLightningBoltFake;
import cofh.network.PacketUtils;
import cofh.util.ServerHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet71Weather;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;

public class CoreUtils {
    public static Random rand = new Random();

    public static boolean isPlayer(EntityPlayer player) {
        return player instanceof EntityPlayerMP;
    }

    public static boolean isFakePlayer(EntityPlayer player) {
        return !(player instanceof EntityPlayerMP);
    }

    public static boolean isOp(EntityPlayer player) {
        return CoFHCore.proxy.isOp(player.field_71092_bJ);
    }

    public static boolean isOp(String playerName) {
        return CoFHCore.proxy.isOp(playerName);
    }

    public static boolean isOpOrServer(String senderName) {
        return CoFHCore.proxy.isOp(senderName) || senderName.equals("Server");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileUsingChannel(File source, File dest) throws IOException {
        AbstractInterruptibleChannel sourceChannel = null;
        AbstractInterruptibleChannel destChannel = null;
        try {
            sourceChannel = new FileInputStream(source).getChannel();
            destChannel = new FileOutputStream(dest).getChannel();
            ((FileChannel)destChannel).transferFrom((ReadableByteChannel)((Object)sourceChannel), 0L, ((FileChannel)sourceChannel).size());
        }
        finally {
            sourceChannel.close();
            destChannel.close();
        }
    }

    public static boolean dropItemStackIntoWorld(ItemStack stack, World world, double x, double y, double z) {
        return CoreUtils.dropItemStackIntoWorld(stack, world, x, y, z, false);
    }

    public static boolean dropItemStackIntoWorldWithVelocity(ItemStack stack, World world, double x, double y, double z) {
        return CoreUtils.dropItemStackIntoWorld(stack, world, x, y, z, true);
    }

    public static boolean dropItemStackIntoWorld(ItemStack stack, World world, double x, double y, double z, boolean velocity) {
        if (stack == null) {
            return false;
        }
        float x2 = 0.5f;
        float y2 = 0.0f;
        float z2 = 0.5f;
        if (velocity) {
            x2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            y2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            z2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        }
        EntityItem entity = new EntityItem(world, x + (double)x2, y + (double)y2, z + (double)z2, stack.func_77946_l());
        if (velocity) {
            entity.field_70159_w = (float)world.field_73012_v.nextGaussian() * 0.05f;
            entity.field_70181_x = (float)world.field_73012_v.nextGaussian() * 0.05f + 0.2f;
            entity.field_70179_y = (float)world.field_73012_v.nextGaussian() * 0.05f;
        } else {
            entity.field_70181_x = -0.05f;
            entity.field_70159_w = 0.0;
            entity.field_70179_y = 0.0;
        }
        world.func_72838_d((Entity)entity);
        return true;
    }

    public static void doFakeExplosion(World world, double x, double y, double z, boolean playSound) {
        world.func_72869_a("largeexplode", x, y + 1.0, z, 0.0, 0.0, 0.0);
        if (playSound) {
            world.func_72980_b(x, y, z, "random.explode", 1.0f, 1.0f, true);
        }
    }

    public static void doFakeLightningBolt(World world, double x, double y, double z) {
        EntityLightningBoltFake bolt = new EntityLightningBoltFake(world, x, y, z);
        world.func_72838_d((Entity)bolt);
        if (ServerHelper.isServerWorld(world)) {
            Packet71Weather packet = new Packet71Weather((Entity)bolt);
            packet.field_73535_e = 1;
            PacketUtils.sendToPlayers((Packet)packet, world, x, y, z, 512);
        }
    }

    public static boolean teleportEntityTo(EntityLivingBase entity, double x, double y, double z) {
        EnderTeleportEvent event = new EnderTeleportEvent(entity, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        double x2 = entity.field_70165_t;
        double y2 = entity.field_70163_u;
        double z2 = entity.field_70161_v;
        entity.field_70165_t = event.targetX;
        entity.field_70163_u = event.targetY;
        entity.field_70161_v = event.targetZ;
        entity.func_70634_a(event.targetX, event.targetY, event.targetZ);
        entity.field_70170_p.func_72908_a(x2, y2, z2, "mob.endermen.portal", 1.0f, 1.0f);
        entity.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }
}

